/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.profiler;

import com.sun.kvem.environment.ToolkitDirs;
import com.sun.kvem.profiler.CallRecord;
import com.sun.kvem.profiler.ProfView;
import com.sun.kvem.util.ToolkitResources;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

abstract class BaseTableModel
extends AbstractTableModel
implements Comparator {
    JTable table;
    ProfView viewer;
    String[] names = new String[]{ToolkitResources.getString((String)"PROFILER_EXT.TABLE.METHOD_NAME"), ToolkitResources.getString((String)"PROFILER_EXT.TABLE.METHOD_COUNT"), ToolkitResources.getString((String)"PROFILER_EXT.TABLE.METHOD_CYCLES"), ToolkitResources.getString((String)"PROFILER_EXT.TABLE.METHOD_PERCENTAGE"), ToolkitResources.getString((String)"PROFILER_EXT.TABLE.KIDS_CYCLES"), ToolkitResources.getString((String)"PROFILER_EXT.TABLE.KIDS_PERCENTAGE")};
    protected int sortColumn = 4;
    protected boolean sortAscending = false;

    BaseTableModel(ProfView profView) {
        this.viewer = profView;
    }

    void setOwner(JTable jTable) {
        this.table = jTable;
        this.setTableColumnWidths();
        this.addMouseListenerToHeaderInTable();
        JTableHeader jTableHeader = jTable.getTableHeader();
        DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)jTableHeader.getDefaultRenderer();
        jTableHeader.setDefaultRenderer(new HeaderCellRenderer(defaultTableCellRenderer));
    }

    abstract CallRecord[] getDataArray();

    abstract void setDataArray(CallRecord[] var1);

    abstract boolean isCallGraphNode();

    CallRecord getRecordByRow(int n) {
        return this.getDataArray()[n];
    }

    public int getColumnCount() {
        return 6;
    }

    public String getColumnName(int n) {
        return this.names[n];
    }

    public int getRowCount() {
        return this.getDataArray().length;
    }

    public Object getValueAt(int n, int n2) {
        CallRecord[] callRecordArray = this.getDataArray();
        CallRecord callRecord = callRecordArray[n];
        switch (n2) {
            case 0: {
                return callRecord.name;
            }
            case 1: {
                return new Integer(callRecord.count);
            }
            case 2: {
                return new Long(callRecord.onlyCycles);
            }
            case 3: {
                return this.getPercObject(callRecord.onlyCycles);
            }
            case 4: {
                return new Long(callRecord.kidsCycles);
            }
            case 5: {
                return this.getPercObject(callRecord.kidsCycles);
            }
        }
        return null;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Integer.class;
            }
            case 2: 
            case 4: {
                return Long.class;
            }
        }
        return Double.class;
    }

    void addMouseListenerToHeaderInTable() {
        this.table.setColumnSelectionAllowed(false);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                TableColumnModel tableColumnModel = BaseTableModel.this.table.getColumnModel();
                int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                int n2 = BaseTableModel.this.table.convertColumnIndexToModel(n);
                if (mouseEvent.getClickCount() == 1 && n2 != -1) {
                    BaseTableModel.this.setSortColumn(n2);
                    BaseTableModel.this.sort();
                    BaseTableModel.this.updateTable();
                }
            }
        };
        JTableHeader jTableHeader = this.table.getTableHeader();
        jTableHeader.addMouseListener(mouseAdapter);
    }

    public int compare(Object object, Object object2) {
        CallRecord callRecord;
        CallRecord callRecord2;
        if (this.sortAscending) {
            callRecord2 = (CallRecord)object;
            callRecord = (CallRecord)object2;
        } else {
            callRecord2 = (CallRecord)object2;
            callRecord = (CallRecord)object;
        }
        switch (this.sortColumn) {
            case 0: {
                return -callRecord2.name.compareTo(callRecord.name);
            }
            case 1: {
                return callRecord2.count - callRecord.count;
            }
            case 2: 
            case 3: {
                if (callRecord2.onlyCycles > callRecord.onlyCycles) {
                    return 1;
                }
                if (callRecord2.onlyCycles < callRecord.onlyCycles) {
                    return -1;
                }
                return 0;
            }
        }
        if (callRecord2.kidsCycles > callRecord.kidsCycles) {
            return 1;
        }
        if (callRecord2.kidsCycles < callRecord.kidsCycles) {
            return -1;
        }
        return 0;
    }

    public void setSortColumn(int n) {
        int n2 = n;
        if (this.sortColumn != n2) {
            this.sortColumn = n2;
            this.sortAscending = false;
        } else {
            this.sortAscending = !this.sortAscending;
        }
    }

    public void sort() {
        CallRecord[] callRecordArray = this.getDataArray();
        List<CallRecord> list = Arrays.asList(callRecordArray);
        Collections.sort(list, this);
        this.setDataArray((CallRecord[])list.toArray((Object[])callRecordArray));
    }

    void setTableColumnWidths() {
        if (this.table == null) {
            return;
        }
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        int n = 0;
        for (int i = 0; i < this.names.length; ++i) {
            int n2;
            switch (i) {
                case 0: {
                    n2 = 350;
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    n2 = 70;
                    break;
                }
                default: {
                    n2 = 40;
                }
            }
            tableColumnModel.getColumn(n).setPreferredWidth(n2);
            ++n;
        }
    }

    public void updateTable() {
        this.table.setModel(new DefaultTableModel());
        this.table.updateUI();
        this.table.setModel(this);
        this.setTableColumnWidths();
        this.table.updateUI();
    }

    Double getPercObject(long l) {
        double d = this.viewer.profile.root.kidsCycles;
        double d2 = (double)l / d;
        int n = (int)(d2 * 1000.0);
        d2 = (double)n / 10.0;
        return new Double(d2);
    }

    class HeaderCellRenderer
    implements TableCellRenderer {
        DefaultTableCellRenderer defaultRenderer;
        ImageIcon upIcon;
        ImageIcon downIcon;

        public HeaderCellRenderer(DefaultTableCellRenderer defaultTableCellRenderer) {
            this.defaultRenderer = defaultTableCellRenderer;
            defaultTableCellRenderer.setHorizontalTextPosition(2);
            this.upIcon = new ImageIcon(ToolkitDirs.LIB + "images" + File.separator + "up.gif");
            this.downIcon = new ImageIcon(ToolkitDirs.LIB + "images" + File.separator + "down.gif");
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = this.defaultRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (jTable.convertColumnIndexToModel(n2) == BaseTableModel.this.sortColumn) {
                component.setFont(component.getFont().deriveFont(1));
                if (BaseTableModel.this.sortAscending) {
                    this.defaultRenderer.setIcon(this.upIcon);
                } else {
                    this.defaultRenderer.setIcon(this.downIcon);
                }
            } else {
                this.defaultRenderer.setIcon(null);
            }
            return component;
        }
    }
}

