/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.pim;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.util.ToolkitResources;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

class PIMDatabase {
    private final File dir;
    private final Map categoriesMap = new HashMap();
    private static final Debug debug = Debug.create((Class)PIMDatabase.class);
    private static final String[] DIRECTORIES = new String[]{"contacts", "events", "todo"};
    String[][] LISTS = new String[][]{{"PIM.LISTS.CONTACT.1"}, {"PIM.LISTS.EVENT.1"}, {"PIM.LISTS.TODO.1"}};

    PIMDatabase(File file) {
        this.dir = file;
        if (!file.exists()) {
            file.mkdirs();
            for (int i = 0; i < DIRECTORIES.length; ++i) {
                File file2 = new File(file, DIRECTORIES[i]);
                file2.mkdir();
                for (int j = 0; j < this.LISTS[i].length; ++j) {
                    String string = ToolkitResources.getString((String)this.LISTS[i][j]);
                    new File(file2, string).mkdir();
                }
            }
        }
    }

    private File getTypeDir(int n) {
        return new File(this.dir, DIRECTORIES[n - 1]);
    }

    private File getListDir(int n, String string) {
        return new File(this.getTypeDir(n), string);
    }

    String[] getListNames(int n) {
        String[] stringArray = this.getTypeDir(n).list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return new File(file, string).isDirectory();
            }
        });
        return stringArray == null ? new String[]{} : stringArray;
    }

    String getDefaultListName(int n) {
        return ToolkitResources.getString((String)this.LISTS[n - 1][0]);
    }

    String[] getKeys(int n, String string) {
        String[] stringArray = this.getListDir(n, string).list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                if ((string = string.toLowerCase()).endsWith(".vcf")) {
                    return true;
                }
                return string.endsWith(".vcs");
            }
        });
        return stringArray == null ? new String[]{} : stringArray;
    }

    byte[] getElement(int n, String string, String string2) {
        try {
            File file = new File(this.getListDir(n, string), string2);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[256];
            int n2 = ((InputStream)bufferedInputStream).read(byArray);
            while (n2 != -1) {
                byteArrayOutputStream.write(byArray, 0, n2);
                n2 = ((InputStream)bufferedInputStream).read(byArray);
            }
            ((InputStream)bufferedInputStream).close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            debug.exception(1, (Throwable)iOException);
            return null;
        }
    }

    String commitElement(int n, String string, String string2, byte[] byArray) {
        Object object;
        Serializable serializable;
        File file = this.getListDir(n, string);
        if (string2 == null) {
            serializable = new HashSet<String>(Arrays.asList(this.getKeys(n, string)));
            switch (n) {
                case 1: {
                    object = ".vcf";
                    break;
                }
                default: {
                    object = ".vcs";
                }
            }
            string2 = 1 + (String)object;
            int n2 = 1;
            while (serializable.contains(n2 + (String)object)) {
                string2 = ++n2 + (String)object;
            }
        }
        try {
            serializable = new File(file, string2);
            if (byArray == null) {
                ((File)serializable).delete();
                return null;
            }
            object = new FileOutputStream((File)serializable);
            ((OutputStream)object).write(byArray);
            ((OutputStream)object).close();
            return string2;
        }
        catch (IOException iOException) {
            debug.exception(1, (Throwable)iOException);
            return null;
        }
    }

    private String categoryKey(int n, String string) {
        return "" + n + "." + string;
    }

    void setCategories(int n, String string, String string2) {
        try {
            File file = new File(this.getListDir(n, string), "categories.txt");
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(string2);
            ((Writer)fileWriter).close();
            this.categoriesMap.put(this.categoryKey(n, string), string2);
        }
        catch (IOException iOException) {
            debug.exception(1, (Throwable)iOException);
        }
    }

    String getCategories(int n, String string) {
        String string2 = this.categoryKey(n, string);
        String string3 = (String)this.categoriesMap.get(string2);
        if (string3 == null) {
            try {
                File file = new File(this.getListDir(n, string), "categories.txt");
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                StringBuffer stringBuffer = new StringBuffer();
                char[] cArray = new char[256];
                int n2 = bufferedReader.read(cArray);
                while (n2 != -1) {
                    stringBuffer.append(cArray, 0, n2);
                    n2 = bufferedReader.read(cArray);
                }
                ((Reader)bufferedReader).close();
                string3 = stringBuffer.toString();
                this.categoriesMap.put(string2, string3);
            }
            catch (IOException iOException) {
                debug.exception(1, (Throwable)iOException);
                return "";
            }
        }
        return string3;
    }
}

