/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.pim;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.environment.ToolkitDirs;
import com.sun.kvem.pim.PIMDatabase;
import com.sun.kvem.pim.PIMFieldDescriptor;
import com.sun.kvem.pim.SupportedPIMFields;
import com.sun.kvem.util.ToolkitResources;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public class PIMBridge {
    private static Map contactListFields = new HashMap();
    private static Map eventListFields = new HashMap();
    private static Map todoListFields = new HashMap();
    private static String storageRoot;
    private static PIMDatabase database;
    private static final Debug debug;
    public static final int CONTACT_LIST = 1;
    public static final int EVENT_LIST = 2;
    public static final int TODO_LIST = 3;
    private static boolean initialized;

    public static void setStorageRoot(String string) {
        storageRoot = string;
    }

    public static synchronized void initialize() {
        if (!initialized) {
            debug.println(1, "Initializing PIM");
            PIMBridge.initializeMap(contactListFields, SupportedPIMFields.CONTACT_LIST_FIELDS);
            PIMBridge.initializeMap(eventListFields, SupportedPIMFields.EVENT_LIST_FIELDS);
            PIMBridge.initializeMap(todoListFields, SupportedPIMFields.TODO_LIST_FIELDS);
            File file = new File(ToolkitDirs.APPDB, storageRoot);
            database = new PIMDatabase(new File(file, "pim"));
            initialized = true;
        }
    }

    private static void initializeMap(Map map, PIMFieldDescriptor[] pIMFieldDescriptorArray) {
        for (int i = 0; i < pIMFieldDescriptorArray.length; ++i) {
            map.put(new Integer(pIMFieldDescriptorArray[i].getField()), pIMFieldDescriptorArray[i]);
        }
    }

    private static Map getFields(int n) {
        Map map;
        switch (n) {
            case 1: {
                map = contactListFields;
                break;
            }
            case 2: {
                map = eventListFields;
                break;
            }
            case 3: {
                map = todoListFields;
                break;
            }
            default: {
                throw new IllegalArgumentException("List type " + n + " is not valid");
            }
        }
        return map;
    }

    private static PIMFieldDescriptor getFieldDescriptor(int n, int n2) {
        return (PIMFieldDescriptor)PIMBridge.getFields(n).get(new Integer(n2));
    }

    public static boolean isSupportedField(int n, int n2) {
        PIMBridge.initialize();
        return PIMBridge.getFieldDescriptor(n, n2) != null;
    }

    public static int getDefaultIntValue(int n, int n2) {
        PIMBridge.initialize();
        PIMFieldDescriptor pIMFieldDescriptor = PIMBridge.getFieldDescriptor(n, n2);
        return (Integer)pIMFieldDescriptor.getDefaultValue();
    }

    public static int getFieldDataType(int n, int n2) {
        PIMBridge.initialize();
        try {
            return PIMBridge.getFieldDescriptor(n, n2).getDataType();
        }
        catch (NullPointerException nullPointerException) {
            return -1;
        }
    }

    public static String getFieldLabel(int n, int n2, String string) {
        PIMBridge.initialize();
        try {
            return PIMBridge.getFieldDescriptor(n, n2).getLabel();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public static boolean hasDefaultValue(int n, int n2) {
        PIMBridge.initialize();
        return PIMBridge.getFieldDescriptor(n, n2).hasDefaultValue();
    }

    public static int getSupportedAttributesMask(int n, int n2) {
        PIMBridge.initialize();
        return (int)PIMBridge.getFieldDescriptor(n, n2).getSupportedAttributes();
    }

    public static int[] getSupportedAttributes(int n, int n2) {
        PIMBridge.initialize();
        long l = PIMBridge.getFieldDescriptor(n, n2).getSupportedAttributes();
        int n3 = 0;
        for (long i = l; i > 0L; i >>= 1) {
            if ((i & 1L) != 1L) continue;
            ++n3;
        }
        int[] nArray = new int[n3];
        int n4 = 0;
        int n5 = 0;
        while (l > 0L) {
            if ((l & 1L) == 1L) {
                nArray[n5++] = 1 << n4;
            }
            ++n4;
            l >>= 1;
        }
        return nArray;
    }

    public static String getAttributeLabel(int n, int n2) {
        PIMBridge.initialize();
        StringBuffer stringBuffer = new StringBuffer("PIM.Attributes.");
        if (n2 == 0) {
            stringBuffer.append("None");
        } else {
            switch (n) {
                case 1: {
                    stringBuffer.append("ContactList.");
                    break;
                }
                case 2: {
                    stringBuffer.append("EventList.");
                    break;
                }
                case 3: {
                    stringBuffer.append("ToDoList.");
                    break;
                }
                default: {
                    return null;
                }
            }
            int n3 = 0;
            while (n2 > 1) {
                ++n3;
                n2 >>= 1;
            }
            stringBuffer.append(n3);
        }
        return ToolkitResources.getString((String)stringBuffer.toString());
    }

    public static boolean isSupportedAttribute(int n, int n2, int n3) {
        PIMBridge.initialize();
        if (n3 == 0) {
            return true;
        }
        long l = PIMBridge.getFieldDescriptor(n, n2).getSupportedAttributes();
        return (l & (long)n3) != 0L;
    }

    public static int[] getSupportedFields(int n) {
        PIMBridge.initialize();
        Map map = PIMBridge.getFields(n);
        ArrayList arrayList = new ArrayList(map.keySet());
        int[] nArray = new int[arrayList.size()];
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            nArray[i] = (Integer)arrayList.get(i);
        }
        return nArray;
    }

    public static int getMaximumValues(int n, int n2) {
        PIMBridge.initialize();
        return PIMBridge.getFieldDescriptor(n, n2).getMaximumValues();
    }

    public static int getStringArraySize(int n, int n2) {
        PIMBridge.initialize();
        try {
            return PIMBridge.getFieldDescriptor(n, n2).getStringArraySize();
        }
        catch (NullPointerException nullPointerException) {
            debug.exception(1, (Throwable)nullPointerException);
            return 0;
        }
    }

    public static String getArrayElementLabel(int n, int n2, int n3) {
        PIMBridge.initialize();
        return PIMBridge.getFieldDescriptor(n, n2).getElementlabel(n3);
    }

    public static int getListNamesLength(int n) {
        PIMBridge.initialize();
        return database.getListNames(n).length;
    }

    public static String getListName(int n, int n2, String string) {
        PIMBridge.initialize();
        return database.getListNames(n)[n2];
    }

    public static String getDefaultListName(int n, String string) {
        PIMBridge.initialize();
        return database.getDefaultListName(n);
    }

    public static int getListKeysLength(int n, String string) {
        PIMBridge.initialize();
        int n2 = database.getKeys(n, string).length;
        debug.println(2, "Getting key count for list {1} of type {0}", n, (Object)string);
        debug.println(2, "List contains {0} keys", n2);
        return n2;
    }

    public static String getListKey(int n, String string, int n2) {
        PIMBridge.initialize();
        String[] stringArray = database.getKeys(n, string);
        debug.println(2, "key[{0}] = {1}", n2, (Object)stringArray[n2]);
        return stringArray[n2];
    }

    public static byte[] getListElement(int n, String string, String string2) {
        PIMBridge.initialize();
        return database.getElement(n, string, string2);
    }

    public static String commitListElement(int n, String string, String string2, byte[] byArray) {
        PIMBridge.initialize();
        debug.println(1, "Committing to list {0} of type {1}", (Object)string, n);
        debug.println(2, "Committing with key {0}, writing {1} bytes of data", (Object)string2, byArray == null ? 0 : byArray.length);
        string2 = database.commitElement(n, string, string2, byArray);
        debug.println(2, "New key is {0}", (Object)string2);
        return string2;
    }

    public static String getCategories(int n, String string) {
        return database.getCategories(n, string);
    }

    public static void setCategories(int n, String string, String string2) {
        database.setCategories(n, string, string2);
    }

    public static String composeDate(long l) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return simpleDateFormat.format(new Date(l));
    }

    public static String composeDateTime(long l) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        String string = simpleDateFormat.format(new Date(l));
        return string.substring(0, 8) + "T" + string.substring(8);
    }

    public static long parseDate(String string) {
        SimpleDateFormat simpleDateFormat = string.indexOf(45) != -1 ? new SimpleDateFormat("yyyy-MM-dd") : new SimpleDateFormat("yyyyMMdd");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        try {
            return simpleDateFormat.parse(string).getTime();
        }
        catch (ParseException parseException) {
            debug.exception(1, (Throwable)parseException);
            return -1L;
        }
    }

    public static long parseDateTime(String string) {
        String[] stringArray = string.split("T");
        debug.println(1, "elements = {0}", (Object)stringArray);
        if (stringArray.length == 2) {
            string = stringArray[0] + stringArray[1];
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        try {
            long l = simpleDateFormat.parse(string).getTime();
            if (debug.level(3)) {
                debug.println(3, "Parsed {0} as " + l, (Object)string);
            }
            return l;
        }
        catch (ParseException parseException) {
            debug.exception(1, (Throwable)parseException);
            return -1L;
        }
    }

    static {
        debug = Debug.create((Class)PIMBridge.class);
        initialized = false;
    }
}

