/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.netmon.util;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.netmon.DisplayableMsg;
import com.sun.kvem.netmon.SyntaxErrorException;
import com.sun.kvem.netmon.gui.NetMonPanel;
import com.sun.kvem.netmon.util.Filter;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Hashtable;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

public class Reader {
    private static final Debug debug = Debug.create((Class)Reader.class);
    private NetMonPanel[] protocols;
    private static final String netMonBase = "com.sun.kvem.netmon";

    public Reader(NetMonPanel[] netMonPanelArray) {
        this.protocols = netMonPanelArray;
    }

    public boolean loadSession(File file) throws FileNotFoundException, SyntaxErrorException {
        boolean bl = false;
        LinkedList<DisplayableMsg> linkedList = new LinkedList<DisplayableMsg>();
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            Node node = document.getFirstChild();
            while (!node.getNodeName().equals("Session")) {
                node = node.getNextSibling();
            }
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = nodeList.item(i);
                if (node2.getNodeType() != 1) continue;
                Class<?> clazz = Class.forName("com.sun.kvem.netmon." + node2.getNodeName());
                DisplayableMsg displayableMsg = (DisplayableMsg)clazz.newInstance();
                displayableMsg.readXML(node2);
                linkedList.add(displayableMsg);
            }
            bl = true;
        }
        catch (SyntaxErrorException syntaxErrorException) {
            throw syntaxErrorException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SyntaxErrorException(classNotFoundException);
        }
        catch (ClassCastException classCastException) {
            throw new SyntaxErrorException(classCastException);
        }
        catch (InstantiationException instantiationException) {
            throw new SyntaxErrorException(instantiationException);
        }
        catch (SAXParseException sAXParseException) {
            throw new SyntaxErrorException(sAXParseException);
        }
        catch (Exception exception) {
            debug.exception(1, (Throwable)exception);
        }
        if (bl) {
            for (int i = 0; i < this.protocols.length; ++i) {
                this.protocols[i].loadMessages(linkedList);
            }
        }
        return bl;
    }

    public boolean loadFilter(File file, Filter filter) throws FileNotFoundException, SyntaxErrorException {
        boolean bl = false;
        Hashtable<String, Node> hashtable = new Hashtable<String, Node>();
        try {
            Object object;
            int n;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            Node node = document.getFirstChild();
            while (!node.getNodeName().equals("Filters")) {
                node = node.getNextSibling();
            }
            NodeList nodeList = node.getChildNodes();
            int n2 = nodeList.getLength();
            for (n = 0; n < n2; ++n) {
                object = nodeList.item(n);
                if (object.getNodeType() != 1) continue;
                hashtable.put(object.getNodeName(), (Node)object);
            }
            bl = true;
            if (bl) {
                for (n = 0; n < this.protocols.length; ++n) {
                    object = this.protocols[n].getContentType();
                    Node node2 = (Node)hashtable.get(object);
                    Node node3 = node2.getFirstChild();
                    while (node3.getNodeType() != 1) {
                        node3 = node3.getNextSibling();
                    }
                    String string = node3.getNodeName();
                    Class<?> clazz = Class.forName("com.sun.kvem.netmon.util." + string + "Filter");
                    Filter filter2 = (Filter)clazz.newInstance();
                    filter2.readXML(node3);
                    this.protocols[n].setFilter(filter2);
                }
            }
        }
        catch (Exception exception) {
            Debug.warning((String)exception.toString());
            debug.exception(2, (Throwable)exception);
        }
        return bl;
    }
}

