/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.netmon.stream;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.netmon.DisplayableMsg;
import com.sun.kvem.netmon.MsgListener;
import com.sun.kvem.netmon.stream.StreamMessage;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public abstract class StreamMsgProducer {
    private static final Debug debug = Debug.create((Class)StreamMsgProducer.class);
    private Vector listeners = new Vector();
    private String msgType;
    protected long groupid;
    protected Properties props;
    protected StreamMessage msg;

    public StreamMsgProducer(String string, long l) {
        this.groupid = l;
        this.props = new Properties();
        int n = string.indexOf(59);
        if (n != -1) {
            string = string.substring(0, n);
        }
        this.props.setProperty("URL", string);
    }

    public synchronized void addMsgListener(MsgListener msgListener) {
        this.listeners.addElement(msgListener);
    }

    public synchronized void addMsgListener(Collection collection) {
        this.listeners.addAll(collection);
    }

    public synchronized void post(DisplayableMsg displayableMsg) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            MsgListener msgListener = (MsgListener)enumeration.nextElement();
            msgListener.post(displayableMsg);
        }
    }

    public void addData(int n, String string) {
        if (this.msg == null) {
            this.msg = this.newMessage();
            this.msg.setProperties(this.props);
            this.msg.setGroup(this.groupid);
            this.msg.fireMsgUpdateEvent(this.msg, true);
            this.post(this.msg);
        }
        this.msg.addData(n, string);
    }

    public void close() {
        if (this.msg != null) {
            this.msg.setComplete(true);
        }
    }

    public abstract StreamMessage newMessage();
}

