/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.netmon.stream;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.netmon.DisplayableMsg;
import com.sun.kvem.netmon.MsgFilterCriteria;
import com.sun.kvem.netmon.MsgTreeNode;
import com.sun.kvem.netmon.MsgUpdateListener;
import com.sun.kvem.netmon.SyntaxErrorException;
import com.sun.kvem.netmon.stream.StreamChunk;
import com.sun.kvem.netmon.util.Writer;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class StreamMessage
extends DefaultMutableTreeNode
implements DisplayableMsg {
    protected StreamChunk chunk;
    protected Date startDate;
    protected Date endDate;
    protected String msgType;
    protected long group;
    protected StringBuffer inBuffer;
    protected StringBuffer outBuffer;
    protected boolean complete = false;
    protected int currentDirection = 2;
    protected Vector chunks;
    protected Vector msgUpdateListeners = new Vector();
    protected Properties props;
    public static final String URL = "URL";
    private static final Debug debug = Debug.create((Class)StreamMessage.class);

    public StreamMessage() {
        this.inBuffer = new StringBuffer();
        this.outBuffer = new StringBuffer();
        this.startDate = new Date();
        this.endDate = new Date();
        this.chunks = new Vector();
        this.props = new Properties();
    }

    public abstract StreamChunk newChunk();

    public Properties getProperties() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.props);
        return properties;
    }

    public void setProperties(Properties properties) {
        this.props.putAll((Map<?, ?>)properties);
    }

    public void setGroup(long l) {
        this.group = l;
    }

    public void addData(int n, String string) {
        if (this.chunk == null || n != this.currentDirection) {
            if (this.chunk != null) {
                this.chunk.setComplete(true);
            }
            this.currentDirection = n;
            this.chunk = this.newChunk();
            this.chunk.setDirection(n);
            this.chunk.setProperties(this.props);
            this.chunk.setGroup(this.group);
            this.chunk.setIndex(this.chunks.size());
            this.addChunk(this.chunk);
            Iterator iterator = this.msgUpdateListeners.iterator();
            while (iterator.hasNext()) {
                this.chunk.addMsgUpdateListener((MsgUpdateListener)iterator.next());
            }
        }
        this.chunk.addData(n, string);
        if (n == 1) {
            this.inBuffer.append(string);
        } else {
            this.outBuffer.append(string);
        }
        this.fireMsgUpdateEvent(this, false);
    }

    public void setComplete(boolean bl) {
        this.complete = bl;
        this.fireMsgUpdateEvent(this, false);
    }

    public String getTitle() {
        return this.getURL();
    }

    public String getToolTip() {
        return this.getTitle();
    }

    public boolean isComplete() {
        return this.complete;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public int getDirection() {
        return 2;
    }

    public String getURL() {
        return this.props.getProperty(URL);
    }

    public long getGroup() {
        return this.group;
    }

    public DisplayableMsg getDisplayableMsg() {
        return this;
    }

    public String toString() {
        return this.getType() + ": " + this.getURL();
    }

    public void addMsgUpdateListener(MsgUpdateListener msgUpdateListener) {
        if (this.msgUpdateListeners == null) {
            this.msgUpdateListeners = new Vector();
        }
        this.msgUpdateListeners.addElement(msgUpdateListener);
    }

    public void removeMsgUpdateListener(MsgUpdateListener msgUpdateListener) {
        this.msgUpdateListeners.removeElement(msgUpdateListener);
    }

    public void removeAllMsgUpdateListener() {
        this.msgUpdateListeners.removeAllElements();
    }

    public void fireMsgUpdateEvent(MsgTreeNode msgTreeNode, boolean bl) {
        Enumeration enumeration = this.msgUpdateListeners.elements();
        while (enumeration.hasMoreElements()) {
            MsgUpdateListener msgUpdateListener = (MsgUpdateListener)enumeration.nextElement();
            msgUpdateListener.msgUpdated(this, msgTreeNode, bl);
        }
    }

    public String getClassSuffix() {
        String string = this.getClass().getName();
        String string2 = "com.sun.kvem.netmon.";
        int n = string.indexOf(string2);
        return string.substring(n + string2.length());
    }

    public void writeXML(String string, FileOutputStream fileOutputStream) throws IOException {
        Object object;
        fileOutputStream.write((string + "<" + this.getClassSuffix() + ">\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<StartDate>" + this.startDate.getTime() + "</StartDate>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<EndDate>" + (this.endDate == null ? -1L : this.endDate.getTime()) + "</EndDate>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<MsgType>" + this.msgType + "</MsgType>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<Group>" + this.group + "</Group>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<Complete>" + this.complete + "</Complete>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<Properties>\n").getBytes("UTF-8"));
        Enumeration<Object> enumeration = this.props.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            String string2 = this.props.getProperty((String)object);
            fileOutputStream.write((string + "\t\t<" + (String)object + ">" + Writer.encodeXML(string2) + "</" + (String)object + ">\n").getBytes("UTF-8"));
        }
        fileOutputStream.write((string + "\t</Properties>\n").getBytes("UTF-8"));
        enumeration = this.chunks.elements();
        while (enumeration.hasMoreElements()) {
            object = (StreamChunk)enumeration.nextElement();
            ((StreamChunk)object).writeXML(string + "\t", fileOutputStream);
        }
        fileOutputStream.write((string + "</" + this.getClassSuffix() + ">\n").getBytes("UTF-8"));
    }

    public void readXML(Node node) throws SyntaxErrorException {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        String string = this.newChunk().getClassSuffix();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.hasChildNodes()) continue;
            String string2 = node2.getNodeName();
            String string3 = node2.getFirstChild().getNodeValue();
            try {
                if (string2.equals("StartDate")) {
                    this.startDate = new Date(Long.parseLong(string3));
                    continue;
                }
                if (string2.equals("EndDate")) {
                    this.endDate = new Date(Long.parseLong(string3));
                    continue;
                }
                if (string2.equals("MsgType")) {
                    this.msgType = string3;
                    continue;
                }
                if (string2.equals("Group")) {
                    this.group = Long.parseLong(string3);
                    continue;
                }
                if (string2.equals("Complete")) {
                    this.complete = Boolean.valueOf(string3);
                    continue;
                }
                if (string2.equals("Properties")) {
                    this.readProperties(node2);
                    continue;
                }
                if (string2.equals(string)) {
                    this.chunk = this.newChunk();
                    this.chunk.readXML(node2);
                    this.chunk.setIndex(this.chunks.size());
                    this.add(this.chunk);
                    this.chunks.add(this.chunk);
                    if (this.chunk.getDirection() == 1) {
                        this.inBuffer.append(this.chunk.toString());
                    } else {
                        this.outBuffer.append(this.chunk.toString());
                    }
                    this.fireMsgUpdateEvent(this, false);
                    this.fireMsgUpdateEvent(this.chunk, true);
                    continue;
                }
                debug.println(2, "Unknown key: {0}", (Object)string2);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw new SyntaxErrorException(numberFormatException);
            }
        }
    }

    protected void readProperties(Node node) {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.hasChildNodes()) continue;
            String string = node2.getNodeName();
            String string2 = node2.getFirstChild().getNodeValue();
            this.props.setProperty(string, string2);
        }
    }

    public boolean complyWith(MsgFilterCriteria msgFilterCriteria) {
        Properties properties = msgFilterCriteria.getProperties();
        int n = Integer.parseInt(properties.getProperty("direction", "0"));
        String string = properties.getProperty(URL, "");
        String string2 = properties.getProperty("content", "");
        boolean bl = (n == 0 || n == 1) && this.inBuffer.length() > 0 || (n == 0 || n == 2) && this.outBuffer.length() > 0;
        boolean bl2 = this.getURL().toLowerCase().indexOf(string.toLowerCase()) >= 0;
        boolean bl3 = this.inBuffer.toString().toLowerCase().indexOf(string2.toLowerCase()) >= 0 || this.outBuffer.toString().toLowerCase().indexOf(string2.toLowerCase()) >= 0;
        return bl && bl2 && bl3;
    }

    public byte[] getInBytes() {
        return this.inBuffer.toString().getBytes();
    }

    public byte[] getOutBytes() {
        return this.outBuffer.toString().getBytes();
    }

    private void addChunk(StreamChunk streamChunk) {
        this.chunks.addElement(streamChunk);
        this.add(streamChunk);
        this.fireMsgUpdateEvent(streamChunk, true);
        this.fireMsgUpdateEvent(this, false);
    }
}

