/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.netmon.stream;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.netmon.DisplayableMsg;
import com.sun.kvem.netmon.MsgFilterCriteria;
import com.sun.kvem.netmon.MsgTreeNode;
import com.sun.kvem.netmon.MsgUpdateListener;
import com.sun.kvem.netmon.SyntaxErrorException;
import com.sun.kvem.netmon.util.HexConverter;
import com.sun.kvem.netmon.util.Writer;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class StreamChunk
extends DefaultMutableTreeNode
implements DisplayableMsg {
    protected Date startDate;
    protected Date endDate;
    protected int direction;
    protected String msgType;
    protected String URL;
    protected long group;
    protected StringBuffer rowData;
    protected boolean complete = false;
    protected Properties props;
    protected int index;
    protected int currentDirection = 2;
    private transient Vector msgUpdateListeners = new Vector();
    private static final Debug debug = Debug.create((Class)StreamChunk.class);

    public StreamChunk() {
        this.rowData = new StringBuffer();
        this.startDate = new Date();
        this.endDate = new Date();
        this.props = new Properties();
    }

    public void setDirection(int n) {
        this.direction = n;
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.props);
        return properties;
    }

    public void setProperties(Properties properties) {
        this.props.putAll((Map<?, ?>)properties);
    }

    public void setGroup(long l) {
        this.group = l;
    }

    public void setIndex(int n) {
        this.index = n;
    }

    public void addData(int n, String string) {
        this.rowData.append(string);
        this.fireMsgUpdateEvent(this, false);
    }

    public void setComplete(boolean bl) {
        this.complete = bl;
        this.fireMsgUpdateEvent(this, false);
    }

    public String getTitle() {
        return " " + this.index;
    }

    public String getToolTip() {
        return "";
    }

    public boolean isComplete() {
        return this.complete;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public int getDirection() {
        return this.direction;
    }

    public String getURL() {
        return this.props.getProperty("URL");
    }

    public long getGroup() {
        return this.group;
    }

    public DisplayableMsg getDisplayableMsg() {
        return this;
    }

    public String toString() {
        return this.rowData.toString();
    }

    public void addMsgUpdateListener(MsgUpdateListener msgUpdateListener) {
        if (this.msgUpdateListeners == null) {
            this.msgUpdateListeners = new Vector();
        }
        this.msgUpdateListeners.addElement(msgUpdateListener);
    }

    public void removeMsgUpdateListener(MsgUpdateListener msgUpdateListener) {
        this.msgUpdateListeners.removeElement(msgUpdateListener);
    }

    public void removeAllMsgUpdateListener() {
        this.msgUpdateListeners.removeAllElements();
    }

    public void fireMsgUpdateEvent(MsgTreeNode msgTreeNode, boolean bl) {
        Enumeration enumeration = this.msgUpdateListeners.elements();
        while (enumeration.hasMoreElements()) {
            MsgUpdateListener msgUpdateListener = (MsgUpdateListener)enumeration.nextElement();
            msgUpdateListener.msgUpdated(this, msgTreeNode, bl);
        }
    }

    public String getClassSuffix() {
        String string = this.getClass().getName();
        String string2 = "com.sun.kvem.netmon.";
        int n = string.indexOf(string2);
        return string.substring(n + string2.length());
    }

    public void writeXML(String string, FileOutputStream fileOutputStream) throws IOException {
        fileOutputStream.write((string + "<" + this.getClassSuffix() + ">\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<Direction>" + this.direction + "</Direction>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<URL>" + Writer.encodeXML(this.getURL()) + "</URL>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<Data>\n").getBytes("UTF-8"));
        fileOutputStream.write((HexConverter.toHex(string + "\t", this.rowData.toString().getBytes()) + "\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t</Data>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "</" + this.getClassSuffix() + ">\n").getBytes("UTF-8"));
    }

    public void readXML(Node node) throws SyntaxErrorException {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.hasChildNodes()) continue;
            String string = node2.getNodeName();
            String string2 = node2.getFirstChild().getNodeValue();
            try {
                if (string.equals("Direction")) {
                    this.direction = Integer.parseInt(string2);
                    continue;
                }
                if (string.equals("URL")) {
                    this.props.setProperty("URL", string2);
                    continue;
                }
                if (string.equals("Data")) {
                    this.rowData = new StringBuffer(new String(HexConverter.toBinary(string2)));
                    continue;
                }
                debug.println(2, "Unknown key: {0}", (Object)string);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw new SyntaxErrorException(numberFormatException);
            }
        }
    }

    public boolean complyWith(MsgFilterCriteria msgFilterCriteria) {
        Properties properties = msgFilterCriteria.getProperties();
        int n = Integer.parseInt(properties.getProperty("direction", "0"));
        String string = properties.getProperty("URL", "");
        String string2 = properties.getProperty("content", "");
        boolean bl = false;
        switch (n) {
            case 0: {
                bl = true;
                break;
            }
            case 1: {
                bl = this.direction == 1;
                break;
            }
            case 2: {
                bl = this.direction == 0;
            }
        }
        boolean bl2 = this.getURL().toLowerCase().indexOf(string.toLowerCase()) >= 0;
        boolean bl3 = this.rowData.toString().toLowerCase().indexOf(string2.toLowerCase()) >= 0;
        return bl && bl2 && bl3;
    }

    public byte[] getContentBytes() {
        return this.rowData.toString().getBytes();
    }
}

