/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.netmon.sms;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.midp.io.j2se.wma.Message;
import com.sun.kvem.netmon.DisplayableMsg;
import com.sun.kvem.netmon.MsgFilterCriteria;
import com.sun.kvem.netmon.MsgTreeNode;
import com.sun.kvem.netmon.MsgUpdateListener;
import com.sun.kvem.netmon.SyntaxErrorException;
import com.sun.kvem.netmon.sms.SMSBody;
import com.sun.kvem.netmon.sms.SMSHeader;
import com.sun.kvem.netmon.util.Writer;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SMSMessage
extends DefaultMutableTreeNode
implements DisplayableMsg {
    protected SMSHeader header;
    protected SMSBody body;
    protected int direction;
    protected String msgType = "sms";
    protected long group;
    protected boolean complete = false;
    protected Date startDate;
    protected Date endDate;
    protected String url = "";
    protected boolean text = true;
    protected Hashtable headerItems = new Hashtable();
    protected int currentDirection = 2;
    private transient List msgUpdateListeners = new Vector();
    static final String SMS_MSG_TYPE = "sms";
    private static final String CBS_MSG_TYPE = "cbs";
    private static final Debug debug = Debug.create((Class)SMSMessage.class);

    public SMSMessage() {
        this.header = new SMSHeader(this);
        this.body = new SMSBody(this);
        this.startDate = new Date();
        this.endDate = new Date();
    }

    public SMSHeader getHeader() {
        return this.header;
    }

    public SMSBody getBody() {
        return this.body;
    }

    public void setType(String string) {
        this.msgType = string;
    }

    public void setDirection(int n) {
        this.direction = n;
    }

    public void setURL(String string) {
        this.url = string;
    }

    public void setGroup(long l) {
        this.group = l;
    }

    public void addData(int n, Message message) {
        if (this.url.length() < 1) {
            this.add(this.body);
            this.setType(message.isSMS() ? SMS_MSG_TYPE : CBS_MSG_TYPE);
            this.url = message.getToAddress();
        }
        this.header.updateHeaderItems(message);
        this.body.updateBody(message);
        this.endDate = new Date();
        this.fireMsgUpdateEvent(this, false);
    }

    public void setComplete(boolean bl) {
        this.complete = bl;
        this.fireMsgUpdateEvent(this, false);
    }

    public void setText(boolean bl) {
        this.text = bl;
        this.fireMsgUpdateEvent(this, false);
    }

    public boolean isText() {
        return this.text;
    }

    public String getType() {
        return this.msgType;
    }

    public String getDefaultType() {
        return SMS_MSG_TYPE;
    }

    public String getTitle() {
        return this.url;
    }

    public String getToolTip() {
        return "SMS_TOOLTIP";
    }

    public boolean isComplete() {
        return this.complete;
    }

    public int getDirection() {
        return this.direction;
    }

    public String getURL() {
        return this.url;
    }

    public long getGroup() {
        return this.group;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public DisplayableMsg getDisplayableMsg() {
        return this;
    }

    public String toString() {
        return this.header.toString();
    }

    public void addMsgUpdateListener(MsgUpdateListener msgUpdateListener) {
        if (this.msgUpdateListeners == null) {
            this.msgUpdateListeners = new Vector();
        }
        this.msgUpdateListeners.add(msgUpdateListener);
    }

    public void removeMsgUpdateListener(MsgUpdateListener msgUpdateListener) {
        this.msgUpdateListeners.remove(msgUpdateListener);
    }

    public void removeAllMsgUpdateListener() {
        this.msgUpdateListeners.clear();
    }

    public void fireMsgUpdateEvent(MsgTreeNode msgTreeNode, boolean bl) {
        Iterator iterator = this.msgUpdateListeners.iterator();
        while (iterator.hasNext()) {
            MsgUpdateListener msgUpdateListener = (MsgUpdateListener)iterator.next();
            msgUpdateListener.msgUpdated(this, msgTreeNode, bl);
        }
    }

    public void writeXML(String string, FileOutputStream fileOutputStream) throws IOException {
        fileOutputStream.write((string + "<sms.SMSMessage>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<StartDate>" + this.startDate.getTime() + "</StartDate>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<EndDate>" + (this.endDate == null ? -1L : this.endDate.getTime()) + "</EndDate>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<Direction>" + this.direction + "</Direction>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<MsgType>" + this.msgType + "</MsgType>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<URL>" + Writer.encodeXML(this.url) + "</URL>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<Group>" + this.group + "</Group>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<Complete>" + this.complete + "</Complete>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<IsText>" + this.text + "</IsText>\n").getBytes("UTF-8"));
        this.header.writeXML(string + "\t", fileOutputStream);
        this.body.writeXML(string + "\t", fileOutputStream);
        fileOutputStream.write((string + "</sms.SMSMessage>\n").getBytes("UTF-8"));
    }

    public void readXML(Node node) throws SyntaxErrorException {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.hasChildNodes()) continue;
            String string = node2.getNodeName();
            String string2 = node2.getFirstChild().getNodeValue();
            if (string.equals("StartDate")) {
                this.startDate = new Date(Long.parseLong(string2));
                continue;
            }
            if (string.equals("EndDate")) {
                this.endDate = new Date(Long.parseLong(string2));
                continue;
            }
            if (string.equals("Direction")) {
                this.direction = Integer.parseInt(string2);
                continue;
            }
            if (string.equals("MsgType")) {
                this.msgType = string2;
                continue;
            }
            if (string.equals("URL")) {
                this.url = string2;
                continue;
            }
            if (string.equals("Group")) {
                this.group = Long.parseLong(string2);
                continue;
            }
            if (string.equals("Complete")) {
                this.complete = Boolean.valueOf(string2);
                continue;
            }
            if (string.equals("IsText")) {
                this.text = Boolean.valueOf(string2);
                continue;
            }
            if (string.equals("sms.SMSHeader")) {
                this.header.readXML(node2);
                this.fireMsgUpdateEvent(this, false);
                continue;
            }
            if (string.equals("sms.SMSBody")) {
                this.body.readXML(node2);
                this.add(this.body);
                this.fireMsgUpdateEvent(this, false);
                this.fireMsgUpdateEvent(this.body, true);
                continue;
            }
            debug.println(2, "Unknown key: {0}", (Object)string);
        }
    }

    public boolean complyWith(MsgFilterCriteria msgFilterCriteria) {
        Properties properties = msgFilterCriteria.getProperties();
        int n = Integer.parseInt(properties.getProperty("protocol", "0"));
        int n2 = Integer.parseInt(properties.getProperty("type", "0"));
        int n3 = Integer.parseInt(properties.getProperty("direction", "0"));
        String string = properties.getProperty("to", "");
        String string2 = properties.getProperty("from", "");
        String string3 = properties.getProperty("content", "");
        boolean bl = false;
        switch (n) {
            case 0: {
                bl = true;
                break;
            }
            case 1: {
                bl = this.msgType.equals(SMS_MSG_TYPE);
                break;
            }
            case 2: {
                bl = this.msgType.equals(CBS_MSG_TYPE);
            }
        }
        boolean bl2 = false;
        switch (n2) {
            case 0: {
                bl2 = true;
                break;
            }
            case 1: {
                bl2 = this.text;
                break;
            }
            case 2: {
                bl2 = !this.text;
            }
        }
        boolean bl3 = false;
        switch (n3) {
            case 0: {
                bl3 = true;
                break;
            }
            case 1: {
                bl3 = this.direction == 1;
                break;
            }
            case 2: {
                bl3 = this.direction == 0;
            }
        }
        SMSHeader sMSHeader = this.getHeader();
        boolean bl4 = sMSHeader.getAddress().toLowerCase().indexOf(string.toLowerCase()) >= 0;
        boolean bl5 = sMSHeader.getSenderAddress().toLowerCase().indexOf(string2.toLowerCase()) >= 0;
        boolean bl6 = this.text && this.getBody().toString().toLowerCase().indexOf(string3.toLowerCase()) >= 0;
        return bl && bl2 && bl3 && bl4 && bl5 && bl6;
    }
}

