/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.netmon.sms;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.midp.io.j2se.wma.Message;
import com.sun.kvem.netmon.DisplayableMsg;
import com.sun.kvem.netmon.MsgTreeNode;
import com.sun.kvem.netmon.SyntaxErrorException;
import com.sun.kvem.netmon.sms.SMSMessage;
import com.sun.kvem.util.ToolkitResources;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SMSHeader
extends DefaultMutableTreeNode
implements MsgTreeNode {
    public static final String SMS_HEADER_TYPE = "sms-header";
    private static final Debug debug = Debug.create((Class)SMSHeader.class);
    protected SMSMessage msg;
    protected Date startDate;
    protected Date endDate;
    private static SimpleDateFormat dateFormater = new SimpleDateFormat(ToolkitResources.getString((String)"NETMON_DATE_FORMAT"));
    private Hashtable header = new Hashtable();

    public SMSHeader() {
        this(null);
    }

    public SMSHeader(SMSMessage sMSMessage) {
        this.setUserObject(ToolkitResources.getString((String)"NETMON_HEADER"));
        this.msg = sMSMessage;
    }

    public void setMsg(SMSMessage sMSMessage) {
        this.msg = sMSMessage;
    }

    public boolean isRequest() {
        return this.msg.getDirection() == 0;
    }

    public boolean isResponse() {
        return this.msg.getDirection() == 1;
    }

    public String getHeader(String string) {
        String string2 = (String)this.header.get(string);
        if (string2 != null) {
            return string2;
        }
        return "";
    }

    public Hashtable getHashtable() {
        return this.header;
    }

    public Enumeration getHeaderNames() {
        return this.header.keys();
    }

    public int getIntHeader(String string) throws NumberFormatException {
        return Integer.parseInt(this.getHeader(string));
    }

    public String getType() {
        return SMS_HEADER_TYPE;
    }

    public String getDefaultType() {
        return "sms";
    }

    public String getTitle() {
        return ToolkitResources.getString((String)"NETMON_HEADER");
    }

    public String getToolTip() {
        return ToolkitResources.getString((String)"NETMON_HEADER");
    }

    public boolean isEmpty() {
        return this.header.size() == 0;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public DisplayableMsg getDisplayableMsg() {
        return this.msg;
    }

    public void updateHeaderItems(Message message) {
        int n;
        this.startDate = new Date();
        String string = (String)this.header.get("Fragment");
        string = string == null ? "" : string + ", ";
        String string2 = (String)this.header.get("Fragment-Size");
        if (string2 == null && (n = message.getFragmentSize()) != 0) {
            string2 = String.valueOf(n);
        }
        this.header.clear();
        String string3 = message.getFromAddress();
        if (string3 != null) {
            this.header.put("SenderAddress", string3);
        }
        this.header.put("Address", message.getToAddress());
        long l = message.getSendTime();
        if (l != 0L) {
            String string4 = dateFormater.format(new Date(l));
            this.header.put("Date", string4);
        }
        this.header.put("Content-Type", message.isText() ? "text" : "binary");
        this.header.put("Content-Length", String.valueOf(message.getContentLength()));
        this.header.put("Segments", String.valueOf(message.getNumSegments()));
        if (message.isText()) {
            this.header.put("Text-Encoding", message.getTextEncoding());
        }
        if (message.isFragmented()) {
            this.header.put("Fragment", string + String.valueOf(message.getFragmentNum()));
            this.header.put("Fragment-Size", string2);
            if (message.getNumSegments() > message.getFragmentNum() + 1) {
                this.header.put("Fragment-Offset", String.valueOf(message.getFragmentOffset()));
            }
        }
        this.endDate = new Date();
    }

    public void removeHeader(String string) {
        this.header.remove(string.trim());
    }

    public void clearHeader() {
        this.header.clear();
    }

    public String toString() {
        String string = (String)this.header.get("Content-Length");
        if (string != null) {
            return string;
        }
        return "";
    }

    public boolean equals(SMSHeader sMSHeader) {
        return this.header.equals(sMSHeader.header);
    }

    public void writeXML(String string, FileOutputStream fileOutputStream) throws IOException {
        fileOutputStream.write((string + "<sms.SMSHeader>\n").getBytes("UTF-8"));
        Enumeration enumeration = this.header.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            fileOutputStream.write((string + "\t<Key>\n").getBytes("UTF-8"));
            fileOutputStream.write((string2 + "\n").getBytes("UTF-8"));
            fileOutputStream.write("</Key>\n".getBytes("UTF-8"));
            fileOutputStream.write((string + "\t<Value>\n").getBytes("UTF-8"));
            fileOutputStream.write(((String)this.header.get(string2) + "\n").getBytes("UTF-8"));
            fileOutputStream.write("</Value>\n".getBytes("UTF-8"));
        }
        fileOutputStream.write((string + "</sms.SMSHeader>\n").getBytes("UTF-8"));
    }

    public void readXML(Node node) throws SyntaxErrorException {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (string.equals("Key")) {
                String string2 = node2.getFirstChild().getNodeValue();
                Node node3 = nodeList.item(++i);
                while (!node3.hasChildNodes()) {
                    node3 = nodeList.item(++i);
                }
                if (string.equals("Value")) {
                    throw new SyntaxErrorException();
                }
                String string3 = node3.getFirstChild().getNodeValue();
                this.header.put(string2, string3);
                continue;
            }
            debug.println(2, "Unknown key: {0}", (Object)string);
        }
    }

    public int getDirection() {
        return 2;
    }

    public String getAddress() {
        return this.getHeader("Address");
    }

    public String getSenderAddress() {
        String string = this.getHeader("SenderAddress");
        if (string == null) {
            return "";
        }
        return string;
    }
}

