/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.netmon.sms;

import com.sun.kvem.netmon.DisplayableMsg;
import com.sun.kvem.netmon.MsgTreeNode;
import com.sun.kvem.netmon.SyntaxErrorException;
import com.sun.kvem.netmon.sms.SMSBody;
import com.sun.kvem.netmon.util.HexConverter;
import com.sun.kvem.util.ToolkitResources;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SMSFragment
extends DefaultMutableTreeNode
implements MsgTreeNode {
    public static final String FRAGMENT_TYPE = "sms-fragment";
    protected Date startDate;
    protected Date endDate;
    protected int fragmentIndex = -1;
    private byte[] fragment = new byte[0];
    private String text = "";
    private SMSBody body;

    public SMSFragment() {
        this.body = null;
    }

    public SMSFragment(SMSBody sMSBody) {
        this.body = sMSBody;
    }

    public void setFragment(byte[] byArray, String string, int n) {
        this.fragment = byArray;
        this.text = string;
        this.fragmentIndex = n;
    }

    public void setBody(SMSBody sMSBody) {
        this.body = sMSBody;
    }

    public String getType() {
        return FRAGMENT_TYPE;
    }

    public String getDefaultType() {
        return "sms";
    }

    public SMSBody getBody() {
        return this.body;
    }

    public String getTitle() {
        if (this.fragmentIndex >= 0) {
            return ToolkitResources.getString((String)"NETMON_FRAGMENT") + " " + this.fragmentIndex;
        }
        return ToolkitResources.getString((String)"NETMON_FRAGMENT");
    }

    public String getToolTip() {
        return ToolkitResources.getString((String)"NETMON_FRAGMENT_TOOLTIP");
    }

    public int getSize() {
        return this.fragment.length;
    }

    public int getDataSize() {
        return this.fragment.length;
    }

    public byte[] getDataBytes() {
        return this.fragment;
    }

    public String getText() {
        return this.text;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public String getURL() {
        return this.body.getURL();
    }

    public String toString() {
        return this.text;
    }

    public void writeXML(String string, FileOutputStream fileOutputStream) throws IOException {
        fileOutputStream.write((string + "<sms.SMSFragment>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<Fragment-Index>" + this.fragmentIndex + "</Fragment-Index>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<Text>\n").getBytes("UTF-8"));
        fileOutputStream.write((HexConverter.toHex(string + "\t", this.text.getBytes("UTF-8")) + "\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t</Text>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<Data>\n").getBytes("UTF-8"));
        fileOutputStream.write((HexConverter.toHex(string + "\t", this.fragment) + "\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t</Data>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "</sms.SMSFragment>\n").getBytes("UTF-8"));
    }

    public void readXML(Node node) throws SyntaxErrorException {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (string.equals("Fragment-Index")) {
                this.fragmentIndex = Integer.parseInt(node2.getFirstChild().getNodeValue());
                continue;
            }
            if (!node2.hasChildNodes()) continue;
            String string2 = node2.getFirstChild().getNodeValue();
            if (string.equals("Data")) {
                this.fragment = HexConverter.toBinary(string2);
                continue;
            }
            if (!string.equals("Text")) continue;
            this.text = new String(HexConverter.toBinary(string2));
        }
    }

    public DisplayableMsg getDisplayableMsg() {
        return this.body.getDisplayableMsg();
    }

    public int getDirection() {
        return 2;
    }
}

