/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.netmon.sms;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.midp.io.j2se.wma.Message;
import com.sun.kvem.netmon.DisplayableMsg;
import com.sun.kvem.netmon.MsgTreeNode;
import com.sun.kvem.netmon.SyntaxErrorException;
import com.sun.kvem.netmon.sms.SMSFragment;
import com.sun.kvem.netmon.sms.SMSMessage;
import com.sun.kvem.util.ToolkitResources;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SMSBody
extends DefaultMutableTreeNode
implements MsgTreeNode {
    public static final String SMS_BODY_TYPE = "sms-body";
    protected Date startDate;
    protected Date endDate;
    private SMSMessage msg;
    private int length = -1;
    private List fragments;
    private ByteArrayOutputStream body = new ByteArrayOutputStream();
    private String text = "";
    private static final Debug debug = Debug.create((Class)SMSBody.class);

    public SMSBody() {
        this.msg = null;
    }

    public SMSBody(SMSMessage sMSMessage) {
        this.msg = sMSMessage;
    }

    public void setMsg(SMSMessage sMSMessage) {
        this.msg = sMSMessage;
        if (this.fragments != null) {
            Iterator iterator = this.fragments.iterator();
            while (iterator.hasNext()) {
                SMSFragment sMSFragment = (SMSFragment)iterator.next();
                sMSFragment.setBody(this);
            }
        }
    }

    public SMSMessage getMessage() {
        return this.msg;
    }

    public int getSize() {
        return this.body.size();
    }

    public byte[] getContentBytes() {
        return this.body.toByteArray();
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.body.toByteArray());
    }

    public String getType() {
        return SMS_BODY_TYPE;
    }

    public String getDefaultType() {
        return "sms";
    }

    public String getTitle() {
        return ToolkitResources.getString((String)"NETMON_BODY");
    }

    public String getToolTip() {
        return ToolkitResources.getString((String)"NETMON_BODY_TOOLTIP");
    }

    public String getURL() {
        return this.msg.getURL();
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void updateBody(Message message) {
        if (this.startDate == null) {
            this.startDate = new Date();
            if (message.isText()) {
                this.msg.setText(true);
            } else {
                this.msg.setText(false);
            }
        }
        SMSFragment sMSFragment = new SMSFragment(this);
        String string = message.toString();
        sMSFragment.setFragment(message.getData(), string, message.getFragmentNum());
        this.addFragment(sMSFragment);
        int n = message.getNumSegments();
        if (n == 1 || n == message.getFragmentNum() + 1) {
            this.msg.setComplete(true);
        }
        this.endDate = new Date();
        if (debug.level(3)) {
            StringBuffer stringBuffer = new StringBuffer();
            System.out.print("\nbody:");
            byte[] byArray = this.getContentBytes();
            for (int i = Math.max(0, byArray.length - 4); i < byArray.length; ++i) {
                stringBuffer.append(" ");
                stringBuffer.append(byArray[i]);
            }
            System.out.println(stringBuffer.toString());
            System.out.println("\n");
        }
    }

    private void addFragment(SMSFragment sMSFragment) {
        if (this.fragments == null) {
            this.fragments = new Vector();
        }
        this.fragments.add(sMSFragment);
        this.add(sMSFragment);
        this.msg.fireMsgUpdateEvent(sMSFragment, true);
        try {
            this.body.write(sMSFragment.getDataBytes());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.text = this.text + sMSFragment.getText();
        this.length = this.body.size();
        this.msg.fireMsgUpdateEvent(this, false);
    }

    public String toString() {
        return this.text;
    }

    public void writeXML(String string, FileOutputStream fileOutputStream) throws IOException {
        fileOutputStream.write((string + "<sms.SMSBody>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<Length>" + this.length + "</Length>\n").getBytes("UTF-8"));
        if (this.fragments != null) {
            Iterator iterator = this.fragments.iterator();
            while (iterator.hasNext()) {
                SMSFragment sMSFragment = (SMSFragment)iterator.next();
                sMSFragment.writeXML(string + "\t", fileOutputStream);
            }
        }
        fileOutputStream.write((string + "</sms.SMSBody>\n").getBytes("UTF-8"));
    }

    public void readXML(Node node) throws SyntaxErrorException {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        try {
            for (int i = 0; i < n; ++i) {
                Node node2 = nodeList.item(i);
                if (!node2.hasChildNodes()) continue;
                String string = node2.getNodeName();
                String string2 = node2.getFirstChild().getNodeValue();
                if (string.equals("Length")) {
                    this.length = Integer.parseInt(string2);
                    continue;
                }
                if (string.equals("sms.SMSFragment")) {
                    while (node2 != null) {
                        if (node2 instanceof Element) {
                            SMSFragment sMSFragment = new SMSFragment(this);
                            sMSFragment.readXML(node2);
                            this.addFragment(sMSFragment);
                        }
                        node2 = node2.getNextSibling();
                    }
                    break;
                }
                debug.println(2, "Unknown key: {0}", (Object)string);
            }
        }
        catch (Exception exception) {
            debug.exception(1, (Throwable)exception);
            throw new SyntaxErrorException(exception.getMessage());
        }
    }

    public DisplayableMsg getDisplayableMsg() {
        return this.msg;
    }

    public int getDirection() {
        return 2;
    }
}

