/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.netmon.obex;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.netmon.SyntaxErrorException;
import com.sun.kvem.netmon.obex.ObexAppParameter;
import com.sun.kvem.netmon.obex.ObexConnection;
import com.sun.kvem.netmon.obex.ObexHeader;
import com.sun.kvem.netmon.stream.StreamChunk;
import com.sun.kvem.netmon.stream.StreamMessage;
import com.sun.kvem.netmon.util.HexConverter;
import com.sun.kvem.util.ToolkitResources;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ObexPacket
extends StreamMessage {
    private static final Debug debug = Debug.create((Class)ObexPacket.class);
    String title;
    byte[] data;
    byte[] body;
    int direction;
    int length;
    private boolean bad;
    private boolean finalBit;
    private Vector headers;
    private static final String OBEX_MSG_TYPE = "obex";
    int type;
    private ObexConnection conn;
    private static final int OBEX_HTTP_OK = 160;
    private static final int OBEX_HTTP_CREATED = 161;
    private static final int OBEX_HTTP_ACCEPTED = 162;
    private static final int OBEX_HTTP_NOT_AUTHORITATIVE = 163;
    private static final int OBEX_HTTP_NO_CONTENT = 164;
    private static final int OBEX_HTTP_RESET = 165;
    private static final int OBEX_HTTP_PARTIAL = 166;
    private static final int OBEX_HTTP_MULT_CHOICE = 176;
    private static final int OBEX_HTTP_MOVED_PERM = 177;
    private static final int OBEX_HTTP_MOVED_TEMP = 178;
    private static final int OBEX_HTTP_SEE_OTHER = 179;
    private static final int OBEX_HTTP_NOT_MODIFIED = 180;
    private static final int OBEX_HTTP_USE_PROXY = 181;
    private static final int OBEX_HTTP_BAD_REQUEST = 192;
    private static final int OBEX_HTTP_UNAUTHORIZED = 193;
    private static final int OBEX_HTTP_PAYMENT_REQUIRED = 194;
    private static final int OBEX_HTTP_FORBIDDEN = 195;
    private static final int OBEX_HTTP_NOT_FOUND = 196;
    private static final int OBEX_HTTP_BAD_METHOD = 197;
    private static final int OBEX_HTTP_NOT_ACCEPTABLE = 198;
    private static final int OBEX_HTTP_PROXY_AUTH = 199;
    private static final int OBEX_HTTP_TIMEOUT = 200;
    private static final int OBEX_HTTP_CONFLICT = 201;
    private static final int OBEX_HTTP_GONE = 202;
    private static final int OBEX_HTTP_LENGTH_REQUIRED = 203;
    private static final int OBEX_HTTP_PRECON_FAILED = 204;
    private static final int OBEX_HTTP_ENTITY_TOO_LARGE = 205;
    private static final int OBEX_HTTP_REQ_TOO_LARGE = 206;
    private static final int OBEX_HTTP_UNSUPPORTED_TYPE = 207;
    private static final int OBEX_HTTP_INTERNAL_ERROR = 208;
    private static final int OBEX_HTTP_NOT_IMPLEMENTED = 209;
    private static final int OBEX_HTTP_BAD_GATEWAY = 210;
    private static final int OBEX_HTTP_UNAVAILABLE = 211;
    private static final int OBEX_HTTP_GATEWAY_TIMEOUT = 212;
    private static final int OBEX_HTTP_VERSION = 213;
    private static final int OBEX_DATABASE_FULL = 224;
    private static final int OBEX_DATABASE_LOCKED = 225;
    private static final int OPCODE_CONNECT = 128;
    private static final int OPCODE_DISCONNECT = 129;
    private static final int OPCODE_PUT = 2;
    private static final int OPCODE_GET = 3;
    private static final int OPCODE_SETPATH = 133;
    private static final int OPCODE_CONTINUE = 144;
    private static final int OPCODE_ABORT = 255;
    private static final int OPCODE_FINAL = 128;

    ObexPacket(ObexConnection obexConnection) {
        this.conn = obexConnection;
        this.headers = new Vector();
    }

    ObexPacket(ObexConnection obexConnection, int n, byte[] byArray) {
        this.direction = n;
        this.data = byArray;
        this.conn = obexConnection;
        this.length = byArray.length;
        this.headers = new Vector();
        try {
            this.parse();
        }
        catch (Exception exception) {
            this.bad = true;
        }
        if (!this.bad) {
            byArray = null;
        }
        this.complete = true;
    }

    public String getType() {
        return OBEX_MSG_TYPE;
    }

    public String getDefaultType() {
        return OBEX_MSG_TYPE;
    }

    public String getTitle() {
        return this.title;
    }

    public int getDirection() {
        return this.direction;
    }

    public int getLength() {
        return this.length;
    }

    public boolean getFinalBit() {
        return this.finalBit;
    }

    public Vector getHeaders() {
        return this.headers;
    }

    public byte[] getBody() {
        return this.body;
    }

    public boolean isBad() {
        return this.bad;
    }

    public byte[] getData() {
        return this.data;
    }

    public StreamChunk newChunk() {
        return null;
    }

    private String getPacketType(int n) {
        String string = null;
        switch (n) {
            case 160: {
                string = "OBEX_HTTP_OK";
                break;
            }
            case 161: {
                string = "OBEX_HTTP_CREATED";
                break;
            }
            case 162: {
                string = "OBEX_HTTP_ACCEPTED";
                break;
            }
            case 163: {
                string = "OBEX_HTTP_NOT_AUTHORITATIVE";
                break;
            }
            case 164: {
                string = "OBEX_HTTP_NO_CONTENT";
                break;
            }
            case 165: {
                string = "OBEX_HTTP_RESET";
                break;
            }
            case 166: {
                string = "OBEX_HTTP_PARTIAL";
                break;
            }
            case 176: {
                string = "OBEX_HTTP_MULT_CHOICE";
                break;
            }
            case 177: {
                string = "OBEX_HTTP_MOVED_PERM";
                break;
            }
            case 178: {
                string = "OBEX_HTTP_MOVED_TEMP";
                break;
            }
            case 179: {
                string = "OBEX_HTTP_SEE_OTHER";
                break;
            }
            case 180: {
                string = "OBEX_HTTP_NOT_MODIFIED";
                break;
            }
            case 181: {
                string = "OBEX_HTTP_USE_PROXY";
                break;
            }
            case 192: {
                string = "OBEX_HTTP_BAD_REQUEST";
                break;
            }
            case 193: {
                string = "OBEX_HTTP_UNAUTHORIZED";
                break;
            }
            case 194: {
                string = "OBEX_HTTP_PAYMENT_REQUIRED";
                break;
            }
            case 195: {
                string = "OBEX_HTTP_FORBIDDEN";
                break;
            }
            case 196: {
                string = "OBEX_HTTP_NOT_FOUND";
                break;
            }
            case 197: {
                string = "OBEX_HTTP_BAD_METHOD";
                break;
            }
            case 198: {
                string = "OBEX_HTTP_NOT_ACCEPTABLE";
                break;
            }
            case 199: {
                string = "OBEX_HTTP_PROXY_AUTH";
                break;
            }
            case 200: {
                string = "OBEX_HTTP_TIMEOUT";
                break;
            }
            case 201: {
                string = "OBEX_HTTP_CONFLICT";
                break;
            }
            case 202: {
                string = "OBEX_HTTP_GONE";
                break;
            }
            case 203: {
                string = "OBEX_HTTP_LENGTH_REQUIRED";
                break;
            }
            case 204: {
                string = "OBEX_HTTP_PRECON_FAILED";
                break;
            }
            case 205: {
                string = "OBEX_HTTP_ENTITY_TOO_LARGE";
                break;
            }
            case 206: {
                string = "OBEX_HTTP_REQ_TOO_LARGE";
                break;
            }
            case 207: {
                string = "OBEX_HTTP_UNSUPPORTED_TYPE";
                break;
            }
            case 208: {
                string = "OBEX_HTTP_INTERNAL_ERROR";
                break;
            }
            case 209: {
                string = "OBEX_HTTP_NOT_IMPLEMENTED";
                break;
            }
            case 210: {
                string = "OBEX_HTTP_BAD_GATEWAY";
                break;
            }
            case 211: {
                string = "OBEX_HTTP_UNAVAILABLE";
                break;
            }
            case 212: {
                string = "OBEX_HTTP_GATEWAY_TIMEOUT";
                break;
            }
            case 213: {
                string = "OBEX_HTTP_VERSION";
                break;
            }
            case 224: {
                string = "OBEX_DATABASE_FULL";
                break;
            }
            case 225: {
                string = "OBEX_DATABASE_LOCKED";
            }
        }
        if (string == null) {
            switch (n) {
                case 128: {
                    string = "NETMON_OBEX_PACKET_TYPE_CONNECT";
                    break;
                }
                case 129: {
                    string = "NETMON_OBEX_PACKET_TYPE_DISCONNECT";
                    break;
                }
                case 130: {
                    this.finalBit = true;
                }
                case 2: {
                    string = "NETMON_OBEX_PACKET_TYPE_PUT";
                    break;
                }
                case 131: {
                    this.finalBit = true;
                }
                case 3: {
                    string = "NETMON_OBEX_PACKET_TYPE_GET";
                    break;
                }
                case 133: {
                    string = "NETMON_OBEX_PACKET_TYPE_SETPATH";
                    break;
                }
                case 144: {
                    string = "NETMON_OBEX_PACKET_TYPE_CONTINUE";
                    break;
                }
                case 255: {
                    string = "NETMON_OBEX_PACKET_TYPE_ABORT";
                    break;
                }
                default: {
                    string = ToolkitResources.format((String)"NETMON_OBEX_PACKET_TYPE_UNKNOWN", (Object)Integer.toHexString(n).toUpperCase());
                    return string;
                }
            }
            string = ToolkitResources.getString((String)string);
        }
        return string;
    }

    private int parseValue16(int n) {
        return ((this.data[n] & 0xFF) << 8) + (this.data[n + 1] & 0xFF);
    }

    private int parseValue8(int n) {
        return this.data[n] & 0xFF;
    }

    private void parse() throws Exception {
        int n;
        int n2;
        int n3;
        this.type = this.parseValue8(0);
        this.title = this.getPacketType(this.type);
        if (this.type == 128) {
            this.conn.isConnect = true;
        }
        if (this.data.length != this.parseValue16(1)) {
            this.bad = true;
            debug.println(2, "ObexPacket: bad packet length");
            return;
        }
        int n4 = 3;
        if (this.conn.isConnect) {
            n4 = 7;
            n3 = this.parseValue8(3);
            n2 = this.parseValue8(4);
            n = this.parseValue16(5);
            this.headers.add(new ObexHeader(ToolkitResources.getString((String)"NETMON_OBEX_PROTOCOL_VERSION"), Integer.toString(n3 >> 4) + "." + Integer.toString(n3 & 0xF), 1));
            this.headers.add(new ObexHeader(ToolkitResources.getString((String)"NETMON_OBEX_CONNECT_FLAGS"), Integer.toString(n2), 1));
            this.headers.add(new ObexHeader(ToolkitResources.getString((String)"NETMON_OBEX_WINDOW_SIZE"), Integer.toString(n), 2));
        }
        if (this.type == 133) {
            n3 = this.parseValue8(3);
            this.headers.add(new ObexHeader(ToolkitResources.getString((String)"NETMON_OBEX_SETPATH_BACKUP"), new Boolean((n3 & 1) == 1).toString(), 1));
            this.headers.add(new ObexHeader(ToolkitResources.getString((String)"NETMON_OBEX_SETPATH_CREATE"), new Boolean((n3 & 2) == 0).toString(), 0));
            n4 = 5;
        }
        while (n4 < this.data.length) {
            ObexHeader obexHeader = ObexHeader.create(this.data, n4);
            this.headers.add(obexHeader);
            n4 += obexHeader.getLength();
        }
        n3 = 0;
        for (n2 = 0; n2 < this.headers.size(); ++n2) {
            ObexHeader obexHeader = (ObexHeader)this.headers.elementAt(n2);
            n3 += obexHeader.getDataLength();
        }
        if (n3 > 0) {
            this.body = new byte[n3];
            for (n2 = 0; n2 < this.headers.size(); ++n2) {
                n = 0;
                ObexHeader obexHeader = (ObexHeader)this.headers.elementAt(n2);
                if (!obexHeader.isData()) continue;
                n += obexHeader.copyData(this.body, n);
            }
        }
        if (n4 > this.data.length) {
            this.bad = true;
            debug.println(2, "ObexPacket: lengths mismatch " + n4 + " > " + this.data.length);
            return;
        }
        if (this.type != 128) {
            this.conn.isConnect = false;
        }
    }

    public void writeXML(String string, FileOutputStream fileOutputStream) throws IOException {
        fileOutputStream.write((string + "<" + this.getClassSuffix() + ">\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<Title>" + this.title + "</Title>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<Length>" + this.length + "</Length>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<StartDate>" + this.startDate.getTime() + "</StartDate>\n").getBytes("UTF-8"));
        if (this.bad) {
            fileOutputStream.write((string + "\t<Bad>" + this.bad + "</Bad>\n").getBytes("UTF-8"));
            fileOutputStream.write((string + "\t<Data>\n").getBytes("UTF-8"));
            fileOutputStream.write((HexConverter.toHex(string + "\t", this.data) + "\n").getBytes("UTF-8"));
            fileOutputStream.write((string + "\t</Data>\n").getBytes("UTF-8"));
            fileOutputStream.write((string + "</" + this.getClassSuffix() + ">\n").getBytes("UTF-8"));
            return;
        }
        fileOutputStream.write((string + "\t<FinalBit>" + this.finalBit + "</FinalBit>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<Direction>" + this.direction + "</Direction>\n").getBytes("UTF-8"));
        if (this.body != null) {
            fileOutputStream.write((string + "\t<Body>\n").getBytes("UTF-8"));
            fileOutputStream.write((HexConverter.toHex(string + "\t", this.body) + "\n").getBytes("UTF-8"));
            fileOutputStream.write((string + "\t</Body>\n").getBytes("UTF-8"));
        }
        Enumeration enumeration = this.headers.elements();
        while (enumeration.hasMoreElements()) {
            ObexHeader obexHeader = (ObexHeader)enumeration.nextElement();
            obexHeader.writeXML(string + "\t", fileOutputStream);
        }
        fileOutputStream.write((string + "</" + this.getClassSuffix() + ">\n").getBytes("UTF-8"));
    }

    public void readXML(Node node) throws SyntaxErrorException {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        this.complete = true;
        String string = new ObexHeader().getClassSuffix();
        String string2 = new ObexAppParameter().getClassSuffix();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.hasChildNodes()) continue;
            String string3 = node2.getNodeName();
            String string4 = node2.getFirstChild().getNodeValue();
            try {
                ObexHeader obexHeader;
                if (string3.equals("StartDate")) {
                    this.startDate = this.endDate = new Date(Long.parseLong(string4));
                    continue;
                }
                if (string3.equals("Bad")) {
                    this.bad = Boolean.valueOf(string4);
                    continue;
                }
                if (string3.equals("FinalBit")) {
                    this.finalBit = Boolean.valueOf(string4);
                    continue;
                }
                if (string3.equals("Title")) {
                    this.title = string4;
                    continue;
                }
                if (string3.equals("Direction")) {
                    this.direction = Integer.parseInt(string4);
                    continue;
                }
                if (string3.equals("Length")) {
                    this.length = Integer.parseInt(string4);
                    continue;
                }
                if (string3.equals("Data")) {
                    this.data = HexConverter.toBinary(string4);
                    continue;
                }
                if (string3.equals("Body")) {
                    this.body = HexConverter.toBinary(string4);
                    continue;
                }
                if (string3.equals(string)) {
                    obexHeader = new ObexHeader();
                    obexHeader.readXML(node2);
                    this.headers.add(obexHeader);
                    continue;
                }
                if (string3.equals(string2)) {
                    obexHeader = new ObexAppParameter();
                    obexHeader.readXML(node2);
                    this.headers.add(obexHeader);
                    continue;
                }
                debug.println(2, "Unknown key: {0}", (Object)string3);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw new SyntaxErrorException(numberFormatException);
            }
        }
    }

    public boolean matchHeaders(String string) {
        for (int i = 0; i < this.headers.size(); ++i) {
            boolean bl;
            String string2 = ((ObexHeader)this.headers.elementAt(i)).getValue();
            if (string2 == null) continue;
            boolean bl2 = bl = string2.toLowerCase().indexOf(string) >= 0;
            if (!bl) continue;
            return true;
        }
        return false;
    }
}

