/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.netmon.obex;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.netmon.SyntaxErrorException;
import com.sun.kvem.netmon.obex.ObexConnection;
import com.sun.kvem.netmon.obex.ObexHeader;
import com.sun.kvem.netmon.obex.ObexPacket;
import com.sun.kvem.netmon.stream.StreamChunk;
import com.sun.kvem.netmon.stream.StreamMessage;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ObexOperation
extends StreamMessage {
    private static final Debug debug = Debug.create((Class)ObexOperation.class);
    private static final String OBEX_MSG_TYPE = "obex";
    private ObexConnection conn;
    private Vector packets = new Vector();
    private Vector recvHeaders = new Vector();
    private Vector sentHeaders = new Vector();
    private String type;
    private String result;
    private int dataLength;

    ObexOperation(ObexConnection obexConnection) {
        this.conn = obexConnection;
    }

    public String getOperationType() {
        return this.type;
    }

    public String getOperationResult() {
        if (this.result == null) {
            return "";
        }
        return this.result;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public Vector getPackets() {
        return this.packets;
    }

    public Vector getRecvHeaders() {
        return this.recvHeaders;
    }

    public Vector getSentHeaders() {
        return this.sentHeaders;
    }

    public String getType() {
        return OBEX_MSG_TYPE;
    }

    public String getDefaultType() {
        return OBEX_MSG_TYPE;
    }

    public void addPacket(ObexPacket obexPacket) {
        Object object;
        this.packets.add(obexPacket);
        this.add(obexPacket);
        this.fireMsgUpdateEvent(obexPacket, true);
        this.fireMsgUpdateEvent(this, false);
        Vector vector = obexPacket.getHeaders();
        Vector vector2 = this.sentHeaders;
        if (obexPacket.getDirection() == 1) {
            vector2 = this.recvHeaders;
        }
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            object = (ObexHeader)iterator.next();
            vector2.add(object);
        }
        object = obexPacket.getBody();
        if (object != null) {
            this.dataLength += ((byte[])object).length;
        }
        if (obexPacket.type >= 160 && obexPacket.type <= 225) {
            this.result = obexPacket.getTitle();
            this.endDate = obexPacket.getEndDate();
            this.complete = true;
            this.conn.activeOperation = null;
        }
        if (this.type == null) {
            this.type = obexPacket.getTitle();
        }
    }

    public StreamChunk newChunk() {
        return null;
    }

    public String getTitle() {
        if (this.result != null) {
            return this.type + ": " + this.result;
        }
        return this.type;
    }

    public void writeXML(String string, FileOutputStream fileOutputStream) throws IOException {
        fileOutputStream.write((string + "<" + this.getClassSuffix() + ">\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<Type>" + this.type + "</Type>\n").getBytes("UTF-8"));
        if (this.result != null) {
            fileOutputStream.write((string + "\t<Result>" + this.result + "</Result>\n").getBytes("UTF-8"));
        }
        fileOutputStream.write((string + "\t<StartDate>" + this.startDate.getTime() + "</StartDate>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<EndDate>" + (this.endDate == null ? -1L : this.endDate.getTime()) + "</EndDate>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<Complete>" + this.complete + "</Complete>\n").getBytes("UTF-8"));
        Enumeration enumeration = this.packets.elements();
        while (enumeration.hasMoreElements()) {
            ObexPacket obexPacket = (ObexPacket)enumeration.nextElement();
            obexPacket.writeXML(string + "\t", fileOutputStream);
        }
        fileOutputStream.write((string + "</" + this.getClassSuffix() + ">\n").getBytes("UTF-8"));
    }

    public void readXML(Node node) throws SyntaxErrorException {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        String string = new ObexPacket(this.conn).getClassSuffix();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.hasChildNodes()) continue;
            String string2 = node2.getNodeName();
            String string3 = node2.getFirstChild().getNodeValue();
            try {
                if (string2.equals("StartDate")) {
                    this.startDate = new Date(Long.parseLong(string3));
                    continue;
                }
                if (string2.equals("EndDate")) {
                    this.endDate = new Date(Long.parseLong(string3));
                    continue;
                }
                if (string2.equals("Complete")) {
                    this.complete = Boolean.valueOf(string3);
                    continue;
                }
                if (string2.equals("Type")) {
                    this.type = string3;
                    continue;
                }
                if (string2.equals("Result")) {
                    this.result = string3;
                    continue;
                }
                if (string2.equals(string)) {
                    Object object;
                    ObexPacket obexPacket = new ObexPacket(this.conn);
                    obexPacket.readXML(node2);
                    this.add(obexPacket);
                    this.packets.add(obexPacket);
                    Vector vector = obexPacket.getHeaders();
                    Vector vector2 = this.sentHeaders;
                    if (obexPacket.getDirection() == 1) {
                        vector2 = this.recvHeaders;
                    }
                    Iterator iterator = vector.iterator();
                    while (iterator.hasNext()) {
                        object = (ObexHeader)iterator.next();
                        vector2.add(object);
                    }
                    object = obexPacket.getBody();
                    if (object == null) continue;
                    this.dataLength += ((byte[])object).length;
                    continue;
                }
                debug.println(2, "Unknown key: {0}", (Object)string2);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw new SyntaxErrorException(numberFormatException);
            }
        }
    }

    public boolean matchHeaders(String string) {
        for (int i = 0; i < this.packets.size(); ++i) {
            boolean bl = ((ObexPacket)this.packets.elementAt(i)).matchHeaders(string);
            if (!bl) continue;
            return true;
        }
        return false;
    }
}

