/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.netmon.obex;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.netmon.MsgListener;
import com.sun.kvem.netmon.obex.ObexMsgProducer;
import java.util.Vector;

public final class ObexMsgReceiver {
    private static final Debug debug = Debug.create((Class)ObexMsgReceiver.class);
    private static Vector listeners = new Vector();
    private static Vector producers = new Vector();

    public static int connect(String string, long l) {
        debug.println(2, "ObexMsgReceiver.connect");
        ObexMsgProducer obexMsgProducer = new ObexMsgProducer(string, l);
        obexMsgProducer.addMsgListener(listeners);
        producers.add(obexMsgProducer);
        obexMsgProducer.newConnection();
        return producers.size() - 1;
    }

    public static void disconnect(int n) {
        debug.println(2, "ObexMsgReceiver.disconnect");
        ObexMsgProducer obexMsgProducer = (ObexMsgProducer)producers.get(n);
        obexMsgProducer.close();
    }

    public static void read(int n, byte[] byArray) {
        debug.println(2, "ObexMsgReceiver.read");
        ObexMsgProducer obexMsgProducer = (ObexMsgProducer)producers.get(n);
        obexMsgProducer.newPacket(1, byArray);
    }

    public static void write(int n, byte[] byArray) {
        debug.println(2, "ObexMsgReceiver.write");
        ObexMsgProducer obexMsgProducer = (ObexMsgProducer)producers.get(n);
        obexMsgProducer.newPacket(0, byArray);
    }

    public static void addMsgListener(MsgListener msgListener) {
        debug.println(2, "ObexMsgReceiver.addMsgListener");
        listeners.addElement(msgListener);
    }

    public static void removeMsgListener(MsgListener msgListener) {
        debug.println(2, "ObexMsgReceiver.removeMsgListener");
        listeners.removeElement(msgListener);
    }

    public static Vector getListeners() {
        return listeners;
    }
}

