/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.netmon.obex;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.netmon.SyntaxErrorException;
import com.sun.kvem.netmon.obex.ObexAppParameter;
import com.sun.kvem.netmon.util.Writer;
import com.sun.kvem.util.ToolkitResources;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.JTable;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ObexHeader {
    private static final Debug debug = Debug.create((Class)ObexHeader.class);
    private static final int HEADER_COUNT = 192;
    private static final int HEADER_NAME = 1;
    private static final int HEADER_TYPE = 66;
    private static final int HEADER_LENGTH = 195;
    private static final int HEADER_TIME_ISO_8601 = 68;
    private static final int HEADER_TIME_4_BYTE = 196;
    private static final int HEADER_DESCRIPTION = 5;
    private static final int HEADER_TARGET = 70;
    private static final int HEADER_HTTP = 71;
    private static final int HEADER_WHO = 74;
    private static final int HEADER_OBJECT_CLASS = 79;
    private static final int HEADER_APPLICATION_PARAMETER = 76;
    private static final int HEADER_BODY = 72;
    private static final int HEADER_EOFBODY = 73;
    private static final int HEADER_CONNECTION_ID = 203;
    private static final int HEADER_AUTH_CHALLENGE = 77;
    private static final int HEADER_AUTH_RESPONSE = 78;
    private static TimeZone utcTimeZone = TimeZone.getTimeZone("UTC");
    protected String name;
    protected String value;
    protected int length;
    protected int type;
    protected byte[] data;
    protected int offset;

    public ObexHeader() {
    }

    ObexHeader(String string, String string2, int n) {
        this.name = string;
        this.value = string2;
        this.length = n;
    }

    ObexHeader(byte[] byArray, int n) throws Exception {
        this.data = byArray;
        this.offset = n;
        this.parseHeader();
        if (!this.isData()) {
            byArray = null;
        }
    }

    protected static final ObexHeader create(byte[] byArray, int n) throws Exception {
        int n2 = byArray[n] & 0xFF;
        if (n2 == 76) {
            return new ObexAppParameter(byArray, n);
        }
        return new ObexHeader(byArray, n);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public int getLength() {
        return this.length;
    }

    public int getDataLength() {
        if (!this.isData()) {
            return 0;
        }
        return this.length - 3;
    }

    public boolean isData() {
        return this.type == 72 || this.type == 73;
    }

    public int copyData(byte[] byArray, int n) {
        System.arraycopy(this.data, this.offset + 3, byArray, n, this.length - 3);
        this.data = null;
        return this.length - 3;
    }

    public String getLabelName() {
        return null;
    }

    public JTable getComponent() {
        return null;
    }

    protected static final String getHeaderName(int n) {
        switch (n) {
            case 192: {
                return "COUNT";
            }
            case 1: {
                return "NAME";
            }
            case 66: {
                return "TYPE";
            }
            case 195: {
                return "LENGTH";
            }
            case 68: {
                return "TIME_ISO_8601";
            }
            case 196: {
                return "TIME_4_BYTE";
            }
            case 5: {
                return "DESCRIPTION";
            }
            case 70: {
                return "TARGET";
            }
            case 71: {
                return "HTTP";
            }
            case 74: {
                return "WHO";
            }
            case 79: {
                return "OBJECT_CLASS";
            }
            case 76: {
                return "APPLICATION_PARAMETER";
            }
            case 72: {
                return ToolkitResources.getString((String)"NETMON_OBEX_HEADER_DATA");
            }
            case 73: {
                return ToolkitResources.getString((String)"NETMON_OBEX_HEADER_EOF_DATA");
            }
            case 203: {
                return ToolkitResources.getString((String)"NETMON_OBEX_HEADER_CONNECTION_ID");
            }
            case 77: {
                return ToolkitResources.getString((String)"NETMON_OBEX_HEADER_AUTH_CHALLENGE");
            }
            case 78: {
                return ToolkitResources.getString((String)"NETMON_OBEX_HEADER_AUTH_RESPONSE");
            }
        }
        if ((0x30 & n) == 48) {
            return ToolkitResources.format((String)"NETMON_OBEX_HEADER_USER_DEFINED", (Object)Integer.toHexString(n).toUpperCase());
        }
        return ToolkitResources.format((String)"NETMON_OBEX_HEADER_UNKNOWN", (Object)Integer.toHexString(n).toUpperCase());
    }

    private long parseValue32(int n) {
        return (((long)this.data[n] & 0xFFL) << 24) + (((long)this.data[n + 1] & 0xFFL) << 16) + (((long)this.data[n + 2] & 0xFFL) << 8) + ((long)this.data[n + 3] & 0xFFL);
    }

    protected final int parseValue16(int n) {
        return ((this.data[n] & 0xFF) << 8) + (this.data[n + 1] & 0xFF);
    }

    protected final int parseValue8(int n) {
        return this.data[n] & 0xFF;
    }

    protected void parseHeader() throws Exception {
        this.type = this.parseValue8(this.offset);
        this.name = ObexHeader.getHeaderName(this.type);
        switch (this.type) {
            case 68: {
                this.length = this.parseValue16(this.offset + 1);
                this.parseTime8601();
                return;
            }
            case 66: {
                this.length = this.parseValue16(this.offset + 1);
                if (this.data[this.offset + this.length - 1] != 0) {
                    throw new Exception();
                }
                this.value = "\"" + new String(this.data, this.offset + 3, this.length - 4, "ISO-8859-1") + "\"";
                return;
            }
            case 196: {
                this.length = 5;
                long l = this.parseValue32(this.offset + 1) * 1000L;
                this.value = DateFormat.getDateTimeInstance().format(new Date(l));
                return;
            }
            case 77: {
                this.length = this.parseValue16(this.offset + 1);
                this.parseAuthChallenge();
                return;
            }
            case 78: {
                this.length = this.parseValue16(this.offset + 1);
                this.parseAuthResponse();
                return;
            }
            case 72: 
            case 73: {
                this.length = this.parseValue16(this.offset + 1);
                int n = this.length - 3;
                if (n > 20) {
                    n = 20;
                    this.value = this.hexValue(this.offset + 3, n) + "...";
                } else {
                    this.value = this.hexValue(this.offset + 3, n);
                }
                return;
            }
            case 76: {
                throw new RuntimeException();
            }
        }
        switch (this.type >> 6) {
            case 0: {
                this.length = this.parseValue16(this.offset + 1);
                if (this.length < 5 || this.data[this.offset + this.length - 1] != 0 || this.data[this.offset + this.length - 2] != 0) {
                    throw new Exception();
                }
                this.value = "\"" + new String(this.data, this.offset + 3, this.length - 5, "UTF-16BE") + "\"";
                return;
            }
            case 1: {
                this.length = this.parseValue16(this.offset + 1);
                this.value = this.hexValue(this.offset + 3, this.length - 3);
                return;
            }
            case 2: {
                this.length = 2;
                int n = this.parseValue8(this.offset + 1);
                this.value = Integer.toString(n) + " (" + Integer.toHexString(n).toUpperCase() + ")";
                return;
            }
            case 3: {
                this.length = 5;
                long l = this.parseValue32(this.offset + 1);
                this.value = Long.toString(l) + " (0x" + Long.toHexString(l).toUpperCase() + ")";
                return;
            }
        }
    }

    private void parseTime8601() throws Exception {
        if (this.length < 18 || this.length > 19 || this.data[this.offset + 11] != 84 || this.length == 19 && this.data[this.offset + 18] != 90) {
            throw new Exception("corrupted time header");
        }
        for (int i = 3; i < 17; ++i) {
            int n;
            if (i == 11 || (n = this.data[this.offset + i] - 48) >= 0 && n <= 9) continue;
            throw new Exception("corrupted time header");
        }
        int n = (this.data[this.offset + 3] - 48) * 1000 + (this.data[this.offset + 4] - 48) * 100 + (this.data[this.offset + 5] - 48) * 10 + (this.data[this.offset + 6] - 48);
        int n2 = (this.data[this.offset + 7] - 48) * 10 + (this.data[this.offset + 8] - 48);
        int n3 = (this.data[this.offset + 9] - 48) * 10 + (this.data[this.offset + 10] - 48);
        int n4 = (this.data[this.offset + 12] - 48) * 10 + (this.data[this.offset + 13] - 48);
        int n5 = (this.data[this.offset + 14] - 48) * 10 + (this.data[this.offset + 15] - 48);
        int n6 = (this.data[this.offset + 16] - 48) * 10 + (this.data[this.offset + 17] - 48);
        Calendar calendar = this.length == 19 ? Calendar.getInstance(utcTimeZone) : Calendar.getInstance();
        calendar.set(1, n);
        calendar.set(2, n2 - 1);
        calendar.set(5, n3);
        calendar.set(10, n4);
        calendar.set(12, n5);
        calendar.set(13, n6);
        this.value = DateFormat.getDateTimeInstance().format(calendar.getTime());
    }

    private void parseAuthString(String string, int n, int n2, String string2) {
        String string3;
        int n3 = this.parseValue8(this.offset + n + 2);
        if (n3 == 255) {
            string3 = "UTF-16BE";
        } else if (n3 == 0) {
            string3 = "US-ASCII";
        } else if (n3 < 10) {
            string3 = "ISO-8859-" + n3;
        } else {
            debug.println(2, "authChallenge: unknown encoding");
            return;
        }
        try {
            this.value = this.value + string2 + string + "\"" + new String(this.data, this.offset + n + 3, n2 - 1, string3) + "\"";
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            debug.println(2, "authChallenge: unsupported encoding");
            return;
        }
    }

    private void parseAuthChallenge() throws Exception {
        int n;
        int n2;
        this.value = new String();
        String string = "";
        block4: for (n = 3; n < this.length; n += n2 + 2) {
            int n3 = this.parseValue8(this.offset + n);
            n2 = this.parseValue8(this.offset + n + 1);
            switch (n3) {
                case 1: {
                    if (n2 != 1) {
                        debug.println(2, "authChallenge: option len != 1");
                        continue block4;
                    }
                    int n4 = this.parseValue8(this.offset + n + 2);
                    this.value = (n4 & 2) == 2 ? this.value + string + ToolkitResources.getString((String)"NETMON_OBEX_READONLY_SHORT") : this.value + string + ToolkitResources.getString((String)"NETMON_OBEX_READWRITE_SHORT");
                    if ((n4 & 1) == 1) {
                        this.value = this.value + ", " + ToolkitResources.getString((String)"NETMON_OBEX_USERNAME");
                    }
                    string = ", ";
                    continue block4;
                }
                case 2: {
                    this.parseAuthString("realm=", n, n2, string);
                    string = ", ";
                }
            }
        }
        if (n != this.length) {
            debug.println(2, "authChallenge: wrong length");
        }
    }

    private void parseAuthResponse() throws Exception {
        int n;
        int n2;
        this.value = new String();
        String string = "";
        block5: for (n = 3; n < this.length; n += n2 + 2) {
            int n3 = this.parseValue8(this.offset + n);
            n2 = this.parseValue8(this.offset + n + 1);
            switch (n3) {
                case 1: {
                    try {
                        this.value = this.value + string + ToolkitResources.getString((String)"NETMON_OBEX_USERNAME") + "=\"" + new String(this.data, this.offset + n + 2, n2, "ISO-8859-1") + "\"";
                        string = ", ";
                        continue block5;
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        debug.println(2, "authChallenge: unsupported encoding");
                    }
                }
            }
        }
        if (n != this.length) {
            debug.println(2, "authChallenge: wrong length");
        }
    }

    protected String hexValue(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n2; ++i) {
            int n3 = this.parseValue8(n + i);
            int n4 = n3 / 16;
            int n5 = n3 % 16;
            if (n4 <= 9) {
                stringBuffer.append((char)(48 + n4));
            } else {
                stringBuffer.append((char)(55 + n4));
            }
            if (n5 <= 9) {
                stringBuffer.append((char)(48 + n5));
            } else {
                stringBuffer.append((char)(55 + n5));
            }
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    protected String getClassSuffix() {
        String string = this.getClass().getName();
        String string2 = "com.sun.kvem.netmon.";
        int n = string.indexOf(string2);
        return string.substring(n + string2.length());
    }

    public void writeXML(String string, FileOutputStream fileOutputStream) throws IOException {
        fileOutputStream.write((string + "<" + this.getClassSuffix() + ">\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<Name>" + this.name + "</Name>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<Value>" + Writer.encodeXML(this.value) + "</Value>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<Length>" + this.length + "</Length>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "</" + this.getClassSuffix() + ">\n").getBytes("UTF-8"));
    }

    public void readXML(Node node) throws SyntaxErrorException {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.hasChildNodes()) continue;
            String string = node2.getNodeName();
            String string2 = node2.getFirstChild().getNodeValue();
            try {
                if (string.equals("Value")) {
                    this.value = string2;
                    continue;
                }
                if (string.equals("Length")) {
                    this.length = Integer.parseInt(string2);
                    continue;
                }
                if (string.equals("Name")) {
                    this.name = string2;
                    continue;
                }
                debug.println(2, "Unknown key: {0}", (Object)string);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw new SyntaxErrorException(numberFormatException);
            }
        }
    }
}

