/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.netmon.obex;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.netmon.MsgFilterCriteria;
import com.sun.kvem.netmon.SyntaxErrorException;
import com.sun.kvem.netmon.obex.ObexHandler;
import com.sun.kvem.netmon.obex.ObexOperation;
import com.sun.kvem.netmon.obex.ObexPacket;
import com.sun.kvem.netmon.stream.StreamChunk;
import com.sun.kvem.netmon.util.Writer;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ObexConnection
extends ObexHandler {
    private static final Debug debug = Debug.create((Class)ObexConnection.class);
    boolean isConnect;
    ObexOperation activeOperation;
    Vector operations = new Vector();

    public void setEndDateAndComplete() {
        this.complete = true;
        this.endDate = new Date();
    }

    private void newOperation() {
        this.activeOperation = new ObexOperation(this);
        this.add(this.activeOperation);
        this.operations.add(this.activeOperation);
        this.fireMsgUpdateEvent(this, false);
        this.fireMsgUpdateEvent(this.activeOperation, true);
    }

    public void addPacket(ObexPacket obexPacket) {
        if (this.activeOperation == null) {
            this.newOperation();
        }
        ObexOperation obexOperation = this.activeOperation;
        obexOperation.addPacket(obexPacket);
        this.fireMsgUpdateEvent(this, false);
        this.fireMsgUpdateEvent(obexOperation, false);
        this.fireMsgUpdateEvent(obexPacket, true);
    }

    public StreamChunk newChunk() {
        return null;
    }

    public Vector getOperations() {
        return this.operations;
    }

    public void writeXML(String string, FileOutputStream fileOutputStream) throws IOException {
        Object object;
        fileOutputStream.write((string + "<" + this.getClassSuffix() + ">\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<StartDate>" + this.startDate.getTime() + "</StartDate>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<EndDate>" + (this.endDate == null ? -1L : this.endDate.getTime()) + "</EndDate>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<MsgType>" + this.msgType + "</MsgType>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<Group>" + this.group + "</Group>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<Complete>" + this.complete + "</Complete>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<Properties>\n").getBytes("UTF-8"));
        Enumeration<Object> enumeration = this.props.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            String string2 = this.props.getProperty((String)object);
            fileOutputStream.write((string + "\t\t<" + (String)object + ">" + Writer.encodeXML(string2) + "</" + (String)object + ">\n").getBytes("UTF-8"));
        }
        fileOutputStream.write((string + "\t</Properties>\n").getBytes("UTF-8"));
        enumeration = this.operations.elements();
        while (enumeration.hasMoreElements()) {
            object = (ObexOperation)enumeration.nextElement();
            ((ObexOperation)object).writeXML(string + "\t", fileOutputStream);
        }
        fileOutputStream.write((string + "</" + this.getClassSuffix() + ">\n").getBytes("UTF-8"));
    }

    public void readXML(Node node) throws SyntaxErrorException {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        String string = new ObexOperation(this).getClassSuffix();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.hasChildNodes()) continue;
            String string2 = node2.getNodeName();
            String string3 = node2.getFirstChild().getNodeValue();
            try {
                if (string2.equals("StartDate")) {
                    this.startDate = new Date(Long.parseLong(string3));
                    continue;
                }
                if (string2.equals("EndDate")) {
                    this.endDate = new Date(Long.parseLong(string3));
                    continue;
                }
                if (string2.equals("MsgType")) {
                    this.msgType = string3;
                    continue;
                }
                if (string2.equals("Group")) {
                    this.group = Long.parseLong(string3);
                    continue;
                }
                if (string2.equals("Complete")) {
                    this.complete = Boolean.valueOf(string3);
                    continue;
                }
                if (string2.equals("Properties")) {
                    this.readProperties(node2);
                    continue;
                }
                if (string2.equals(string)) {
                    this.activeOperation = new ObexOperation(this);
                    this.activeOperation.readXML(node2);
                    this.add(this.activeOperation);
                    this.operations.add(this.activeOperation);
                    continue;
                }
                debug.println(2, "Unknown key: {0}", (Object)string2);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw new SyntaxErrorException(numberFormatException);
            }
        }
    }

    public boolean complyWith(MsgFilterCriteria msgFilterCriteria) {
        Properties properties = msgFilterCriteria.getProperties();
        int n = Integer.parseInt(properties.getProperty("direction", "0"));
        String string = properties.getProperty("URL", "");
        String string2 = properties.getProperty("content", "");
        boolean bl = true;
        if (string2.length() > 0) {
            bl = this.matchHeaders(string2.toLowerCase());
        }
        boolean bl2 = this.getURL().toLowerCase().indexOf(string.toLowerCase()) >= 0;
        return bl && bl2;
    }

    public boolean matchHeaders(String string) {
        for (int i = 0; i < this.operations.size(); ++i) {
            boolean bl = ((ObexOperation)this.operations.elementAt(i)).matchHeaders(string);
            if (!bl) continue;
            return true;
        }
        return false;
    }
}

