/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.netmon.obex;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.netmon.SyntaxErrorException;
import com.sun.kvem.netmon.obex.AppParamTableModel;
import com.sun.kvem.netmon.obex.ObexHeader;
import com.sun.kvem.netmon.obex.ObexPacket;
import com.sun.kvem.netmon.util.Writer;
import com.sun.kvem.util.ToolkitResources;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ObexAppParameter
extends ObexHeader {
    private static final Debug debug = Debug.create((Class)ObexPacket.class);
    Vector types;
    Vector lengths;
    Vector values;
    private static JTable table;
    private static AppParamTableModel model;

    ObexAppParameter() {
        this.types = new Vector();
        this.lengths = new Vector();
        this.values = new Vector();
    }

    ObexAppParameter(byte[] byArray, int n) throws Exception {
        super(byArray, n);
    }

    protected void parseHeader() throws Exception {
        int n;
        this.types = new Vector();
        this.lengths = new Vector();
        this.values = new Vector();
        this.type = this.parseValue8(this.offset);
        this.name = ObexAppParameter.getHeaderName(this.type);
        this.length = this.parseValue16(this.offset + 1);
        this.value = this.hexValue(this.offset + 3, this.length - 3);
        for (int i = 3; i < this.length; i += n + 2) {
            int n2 = this.parseValue8(this.offset + i);
            n = this.parseValue8(this.offset + i + 1);
            this.types.add("0x" + Integer.toHexString(n2).toUpperCase());
            if (i + n > this.length) {
                n = this.length - i;
                this.lengths.add(ToolkitResources.format((String)"NETMON_DATALEN_TRUNCATED", (Object)Integer.toString(n)));
                i = this.length;
            } else {
                this.lengths.add(ToolkitResources.format((String)"NETMON_DATALENGTH", (Object)Integer.toString(n)));
            }
            this.values.add(this.hexValue(this.offset + i + 2, n));
        }
    }

    public String getLabelName() {
        return ToolkitResources.getString((String)"NETMON_OBEX_APP_PARAM_TITLE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JTable getComponent() {
        Class clazz = ObexAppParameter.class;
        synchronized (clazz) {
            if (table != null) {
                ObexAppParameter.model.parm = this;
                return table;
            }
            table = new JTable();
            model = new AppParamTableModel();
            ObexAppParameter.model.parm = this;
            table.setModel(model);
            TableColumnModel tableColumnModel = table.getColumnModel();
            tableColumnModel.getColumn(0).setPreferredWidth(80);
            tableColumnModel.getColumn(1).setPreferredWidth(100);
            tableColumnModel.getColumn(2).setPreferredWidth(600);
            tableColumnModel.getColumn(3).setPreferredWidth(300);
            return table;
        }
    }

    public void writeXML(String string, FileOutputStream fileOutputStream) throws IOException {
        fileOutputStream.write((string + "<" + this.getClassSuffix() + ">\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<Name>" + this.name + "</Name>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<Value>" + Writer.encodeXML(this.value) + "</Value>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<Length>" + this.length + "</Length>\n").getBytes("UTF-8"));
        for (int i = 0; i < this.types.size(); ++i) {
            fileOutputStream.write((string + "\t<Params>\n").getBytes("UTF-8"));
            fileOutputStream.write((string + "\t\t<Type>" + this.types.elementAt(i).toString() + "</Type>\n").getBytes("UTF-8"));
            fileOutputStream.write((string + "\t\t<Value>" + this.values.elementAt(i).toString() + "</Value>\n").getBytes("UTF-8"));
            fileOutputStream.write((string + "\t\t<Length>" + this.lengths.elementAt(i).toString() + "</Length>\n").getBytes("UTF-8"));
            fileOutputStream.write((string + "\t</Params>\n").getBytes("UTF-8"));
        }
        fileOutputStream.write((string + "</" + this.getClassSuffix() + ">\n").getBytes("UTF-8"));
    }

    private void readParams(Node node) throws SyntaxErrorException {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        String string = "";
        String string2 = "";
        String string3 = "";
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.hasChildNodes()) continue;
            String string4 = node2.getNodeName();
            String string5 = node2.getFirstChild().getNodeValue();
            try {
                if (string4.equals("Value")) {
                    string2 = string5;
                    continue;
                }
                if (string4.equals("Length")) {
                    string3 = string5;
                    continue;
                }
                if (string4.equals("Type")) {
                    string = string5;
                    continue;
                }
                debug.println(2, "Unknown key: {0}", (Object)string4);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw new SyntaxErrorException(numberFormatException);
            }
        }
        this.types.add(string);
        this.values.add(string2);
        this.lengths.add(string3);
    }

    public void readXML(Node node) throws SyntaxErrorException {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.hasChildNodes()) continue;
            String string = node2.getNodeName();
            String string2 = node2.getFirstChild().getNodeValue();
            try {
                if (string.equals("Value")) {
                    this.value = string2;
                    continue;
                }
                if (string.equals("Length")) {
                    this.length = Integer.parseInt(string2);
                    continue;
                }
                if (string.equals("Name")) {
                    this.name = string2;
                    continue;
                }
                if (string.equals("Params")) {
                    this.readParams(node2);
                    continue;
                }
                debug.println(2, "Unknown key: {0}", (Object)string);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw new SyntaxErrorException(numberFormatException);
            }
        }
    }
}

