/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.netmon.mms;

import com.sun.kvem.midp.io.j2se.wma.MessagePart;
import com.sun.kvem.netmon.DisplayableMsg;
import com.sun.kvem.netmon.MsgTreeNode;
import com.sun.kvem.netmon.SyntaxErrorException;
import com.sun.kvem.netmon.mms.MMSBody;
import com.sun.kvem.netmon.util.HexConverter;
import com.sun.kvem.util.ToolkitResources;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MMSPart
extends DefaultMutableTreeNode
implements MsgTreeNode {
    public static final String PART_TYPE = "mms-part";
    protected Date startDate;
    protected Date endDate;
    private MMSBody body;
    private byte[] content;
    private String contentID;
    private String contentLocation;
    private String encoding;
    private String mimeType;

    public MMSPart() {
        this.body = null;
    }

    public MMSPart(MMSBody mMSBody) {
        this.body = mMSBody;
    }

    public void init(MessagePart messagePart) {
        this.init(messagePart.getContent(), messagePart.getContentID(), messagePart.getContentLocation(), messagePart.getEncoding(), messagePart.getMIMEType());
    }

    public void init(byte[] byArray, String string, String string2, String string3, String string4) {
        this.content = byArray;
        this.contentID = string;
        this.contentLocation = string2;
        this.encoding = string3;
        this.mimeType = string4;
    }

    public void setBody(MMSBody mMSBody) {
        this.body = mMSBody;
    }

    public String getType() {
        return PART_TYPE;
    }

    public String getDefaultType() {
        return "mms";
    }

    public String getTitle() {
        return this.contentID;
    }

    public String getToolTip() {
        return ToolkitResources.getString((String)"WMA_CONSOLE.PART_TOOLTIP");
    }

    public String getMIMEType() {
        return this.mimeType;
    }

    public String getContentID() {
        return this.contentID;
    }

    public byte[] getContent() {
        return this.content;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public String getContentLocation() {
        return this.contentLocation;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String toString() {
        return "";
    }

    public void writeXML(String string, FileOutputStream fileOutputStream) throws IOException {
        fileOutputStream.write((string + "<mms.MMSPart>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<ContentID>").getBytes("UTF-8"));
        fileOutputStream.write(this.contentID.getBytes("UTF-8"));
        fileOutputStream.write("</ContentID>\n".getBytes("UTF-8"));
        if (this.contentLocation != null) {
            fileOutputStream.write((string + "\t<ContentLocation>").getBytes("UTF-8"));
            fileOutputStream.write(this.contentLocation.getBytes("UTF-8"));
            fileOutputStream.write("</ContentLocation>\n".getBytes("UTF-8"));
        }
        if (this.encoding != null) {
            fileOutputStream.write((string + "\t<Encoding>").getBytes("UTF-8"));
            fileOutputStream.write(this.encoding.getBytes("UTF-8"));
            fileOutputStream.write("</Encoding>\n".getBytes("UTF-8"));
        }
        if (this.mimeType != null) {
            fileOutputStream.write((string + "\t<MIME-Type>").getBytes("UTF-8"));
            fileOutputStream.write(this.mimeType.getBytes("UTF-8"));
            fileOutputStream.write("</MIME-Type>\n".getBytes("UTF-8"));
        }
        if (this.content != null) {
            fileOutputStream.write((string + "\t<Content>\n").getBytes("UTF-8"));
            fileOutputStream.write((HexConverter.toHex(string + "\t\t", this.content) + "\n").getBytes("UTF-8"));
            fileOutputStream.write((string + "\t</Content>\n").getBytes("UTF-8"));
        }
        fileOutputStream.write((string + "</mms.MMSPart>\n").getBytes("UTF-8"));
    }

    public void readXML(Node node) throws SyntaxErrorException {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        this.init(null, null, null, null, null);
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (string.equals("ContentID")) {
                this.contentID = node2.getFirstChild().getNodeValue();
                continue;
            }
            if (string.equals("ContentLocation")) {
                this.contentLocation = node2.getFirstChild().getNodeValue();
                continue;
            }
            if (string.equals("Encoding")) {
                this.encoding = node2.getFirstChild().getNodeValue();
                continue;
            }
            if (string.equals("MIME-Type")) {
                this.mimeType = node2.getFirstChild().getNodeValue();
                continue;
            }
            if (!node2.hasChildNodes()) continue;
            String string2 = node2.getFirstChild().getNodeValue();
            if (!string.equals("Content")) continue;
            this.content = HexConverter.toBinary(string2);
        }
    }

    public DisplayableMsg getDisplayableMsg() {
        return this.body.getDisplayableMsg();
    }

    public int getSize() {
        if (this.content != null) {
            return this.content.length;
        }
        return 0;
    }

    public int getDirection() {
        return 2;
    }
}

