/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.netmon.mms;

import com.sun.kvem.midp.io.j2se.wma.MultipartMessage;
import com.sun.kvem.netmon.DisplayableMsg;
import com.sun.kvem.netmon.MsgFilterCriteria;
import com.sun.kvem.netmon.MsgTreeNode;
import com.sun.kvem.netmon.MsgUpdateListener;
import com.sun.kvem.netmon.SyntaxErrorException;
import com.sun.kvem.netmon.mms.MMSBody;
import com.sun.kvem.netmon.mms.MMSHeader;
import com.sun.kvem.netmon.mms.MMSPart;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MMSMessage
extends DefaultMutableTreeNode
implements DisplayableMsg {
    protected MMSHeader header;
    protected MMSBody body;
    protected int direction;
    protected long group;
    protected boolean complete;
    protected Date startDate;
    protected Date endDate;
    protected int currentDirection = 2;
    private transient List msgUpdateListeners = new Vector();
    static final String MMS_MSG_TYPE = "mms";

    public static MMSMessage createFromByteArray(byte[] byArray, int n) {
        MMSMessage mMSMessage = null;
        try {
            MultipartMessage multipartMessage = MultipartMessage.createFromByteArray(byArray);
            mMSMessage = new MMSMessage();
            mMSMessage.init(multipartMessage, n);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return mMSMessage;
    }

    public MMSMessage() {
        this.header = new MMSHeader(this);
        this.body = new MMSBody(this);
    }

    public void init(MultipartMessage multipartMessage, int n) {
        this.startDate = new Date();
        this.direction = n;
        this.header.init(multipartMessage, n, this.startDate, "1.0");
        this.body.init(multipartMessage);
        this.add(this.body);
        this.endDate = new Date();
    }

    public MMSHeader getHeader() {
        return this.header;
    }

    public MMSBody getBody() {
        return this.body;
    }

    public void setDirection(int n) {
        this.direction = n;
    }

    public void setGroup(long l) {
        this.group = l;
    }

    public void setComplete(boolean bl) {
        this.complete = bl;
        this.fireMsgUpdateEvent(this, false);
    }

    public String getType() {
        return MMS_MSG_TYPE;
    }

    public String getDefaultType() {
        return MMS_MSG_TYPE;
    }

    public String getTitle() {
        return this.header.getSubject();
    }

    public String getToolTip() {
        return "MMS_TOOLTIP";
    }

    public boolean isComplete() {
        return this.complete;
    }

    public int getDirection() {
        return this.direction;
    }

    public String getURL() {
        return this.header.getFrom();
    }

    public long getGroup() {
        return this.group;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public DisplayableMsg getDisplayableMsg() {
        return this;
    }

    public String toString() {
        return this.header.toString();
    }

    public void addMsgUpdateListener(MsgUpdateListener msgUpdateListener) {
        if (this.msgUpdateListeners == null) {
            this.msgUpdateListeners = new Vector();
        }
        this.msgUpdateListeners.add(msgUpdateListener);
    }

    public void removeMsgUpdateListener(MsgUpdateListener msgUpdateListener) {
        this.msgUpdateListeners.remove(msgUpdateListener);
    }

    public void removeAllMsgUpdateListener() {
        this.msgUpdateListeners.clear();
    }

    public void fireMsgUpdateEvent(MsgTreeNode msgTreeNode, boolean bl) {
        Iterator iterator = this.msgUpdateListeners.iterator();
        while (iterator.hasNext()) {
            MsgUpdateListener msgUpdateListener = (MsgUpdateListener)iterator.next();
            msgUpdateListener.msgUpdated(this, msgTreeNode, bl);
        }
    }

    public void writeXML(String string, FileOutputStream fileOutputStream) throws IOException {
        fileOutputStream.write((string + "<mms.MMSMessage>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<StartDate>" + this.startDate.getTime() + "</StartDate>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<EndDate>" + (this.endDate == null ? -1L : this.endDate.getTime()) + "</EndDate>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<Direction>" + this.direction + "</Direction>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<Group>" + this.group + "</Group>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<Complete>" + this.complete + "</Complete>\n").getBytes("UTF-8"));
        this.header.writeXML(string + "\t", fileOutputStream);
        this.body.writeXML(string + "\t", fileOutputStream);
        fileOutputStream.write((string + "</mms.MMSMessage>\n").getBytes("UTF-8"));
    }

    public void readXML(Node node) throws SyntaxErrorException {
        this.endDate = null;
        this.startDate = null;
        this.direction = -1;
        this.complete = false;
        this.group = 0L;
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.hasChildNodes()) continue;
            String string = node2.getNodeName();
            String string2 = node2.getFirstChild().getNodeValue();
            if (string.equals("StartDate")) {
                this.startDate = new Date(Long.parseLong(string2));
                continue;
            }
            if (string.equals("EndDate")) {
                this.endDate = new Date(Long.parseLong(string2));
                continue;
            }
            if (string.equals("Direction")) {
                this.direction = Integer.parseInt(string2);
                continue;
            }
            if (string.equals("Group")) {
                this.group = Long.parseLong(string2);
                continue;
            }
            if (string.equals("Complete")) {
                this.complete = Boolean.valueOf(string2);
                continue;
            }
            if (string.equals("mms.MMSHeader")) {
                this.header.readXML(node2);
                this.fireMsgUpdateEvent(this, false);
                continue;
            }
            if (!string.equals("mms.MMSBody")) continue;
            this.body.readXML(node2);
            this.add(this.body);
            this.fireMsgUpdateEvent(this, false);
            this.fireMsgUpdateEvent(this.body, true);
        }
    }

    public boolean complyWith(MsgFilterCriteria msgFilterCriteria) {
        Properties properties = msgFilterCriteria.getProperties();
        int n = Integer.parseInt(properties.getProperty("direction", "0"));
        String string = properties.getProperty("to", "");
        String string2 = properties.getProperty("from", "");
        String string3 = properties.getProperty("cc", "");
        String string4 = properties.getProperty("bcc", "");
        String string5 = properties.getProperty("subject", "");
        String string6 = properties.getProperty("contentID", "");
        String string7 = properties.getProperty("contentLocation", "");
        String string8 = properties.getProperty("mimeType", "");
        String string9 = properties.getProperty("encoding", "");
        boolean bl = false;
        switch (n) {
            case 0: {
                bl = true;
                break;
            }
            case 1: {
                bl = this.direction == 1;
                break;
            }
            case 2: {
                boolean bl2 = bl = this.direction == 0;
            }
        }
        if (bl) {
            MMSHeader mMSHeader = this.getHeader();
            String string10 = mMSHeader.getTo();
            boolean bl3 = bl = (string10 == null ? "" : string10.toLowerCase()).indexOf(string.toLowerCase()) >= 0;
            boolean bl4 = bl && ((string10 = mMSHeader.getFrom()) == null ? "" : string10.toLowerCase()).indexOf(string2.toLowerCase()) >= 0 ? true : (bl = false);
            boolean bl5 = bl && ((string10 = mMSHeader.getCC()) == null ? "" : string10.toLowerCase()).indexOf(string3.toLowerCase()) >= 0 ? true : (bl = false);
            boolean bl6 = bl && ((string10 = mMSHeader.getBCC()) == null ? "" : string10.toLowerCase()).indexOf(string4.toLowerCase()) >= 0 ? true : (bl = false);
            boolean bl7 = bl && ((string10 = mMSHeader.getSubject()) == null ? "" : string10.toLowerCase()).indexOf(string5.toLowerCase()) >= 0 ? true : (bl = false);
            if (bl) {
                boolean bl8 = false;
                MMSPart[] mMSPartArray = this.body.getParts();
                if (mMSPartArray != null) {
                    int n2 = mMSPartArray.length;
                    for (int i = 0; i < n2; ++i) {
                        MMSPart mMSPart = mMSPartArray[i];
                        boolean bl9 = bl8 = mMSPart.getContentID().toLowerCase().indexOf(string6.toLowerCase()) >= 0;
                        boolean bl10 = bl8 && ((string10 = mMSPart.getContentLocation()) == null ? "" : string10.toLowerCase()).indexOf(string7.toLowerCase()) >= 0 ? true : (bl8 = false);
                        boolean bl11 = bl8 && ((string10 = mMSPart.getEncoding()) == null ? "" : string10.toLowerCase()).indexOf(string9.toLowerCase()) >= 0 ? true : (bl8 = false);
                        boolean bl12 = bl8 && ((string10 = mMSPart.getMIMEType()) == null ? "" : string10.toLowerCase()).indexOf(string8.toLowerCase()) >= 0 ? true : (bl8 = false);
                        if (bl8) break;
                    }
                }
                bl = bl8;
            }
        }
        return bl;
    }
}

