/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.netmon.mms;

import com.sun.kvem.midp.io.j2se.wma.MultipartMessage;
import com.sun.kvem.midp.io.j2se.wma.common.parse.MMSAddress;
import com.sun.kvem.netmon.DisplayableMsg;
import com.sun.kvem.netmon.MsgTreeNode;
import com.sun.kvem.netmon.SyntaxErrorException;
import com.sun.kvem.netmon.mms.MMSMessage;
import com.sun.kvem.util.ToolkitResources;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MMSHeader
extends DefaultMutableTreeNode
implements MsgTreeNode {
    public static final String MMS_HEADER_TYPE = "mms-header";
    protected MMSMessage msg;
    protected Date startDate;
    protected Date endDate;
    private String subject;
    private String delDate;
    private String priority;
    private String messageType;
    private String txID;
    private String mmsVersion;
    private String contentType;
    private String from;
    private String to;
    private String cc;
    private String bcc;
    private long sendTime;

    public MMSHeader() {
        this(null);
    }

    public MMSHeader(MMSMessage mMSMessage) {
        this.setUserObject(ToolkitResources.getString((String)"NETMON_HEADER"));
        this.setMsg(mMSMessage);
    }

    public void init(MultipartMessage multipartMessage, int n, Date date, String string) {
        this.init(multipartMessage.getSubject(), multipartMessage.getHeader("X-Mms-Delivery-Time"), multipartMessage.getHeader("X-Mms-Priority"), MMSHeader.getMessageTypeString(n), String.valueOf(date.getTime()), string, MMSHeader.getContentTypeString(multipartMessage), MMSHeader.getDevicePortionOfAddress(multipartMessage.getFromAddress()), MMSHeader.collectArrayAsString(multipartMessage.getAddresses("to")), MMSHeader.collectArrayAsString(multipartMessage.getAddresses("cc")), MMSHeader.collectArrayAsString(multipartMessage.getAddresses("bcc")), multipartMessage.getSendTime());
    }

    public void init(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, long l) {
        this.subject = string;
        this.delDate = string2;
        this.priority = string3;
        this.messageType = string4;
        this.txID = string5;
        this.mmsVersion = string6;
        this.contentType = string7;
        this.from = string8;
        this.to = string9;
        this.cc = string10;
        this.bcc = string11;
        this.sendTime = l;
    }

    public void setMsg(MMSMessage mMSMessage) {
        this.msg = mMSMessage;
    }

    public String getType() {
        return MMS_HEADER_TYPE;
    }

    public String getDefaultType() {
        return "mms";
    }

    public String getTitle() {
        return ToolkitResources.getString((String)"NETMON_HEADER");
    }

    public String getToolTip() {
        return ToolkitResources.getString((String)"NETMON_HEADER");
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public DisplayableMsg getDisplayableMsg() {
        return this.msg;
    }

    public String toString() {
        return this.getSubject();
    }

    public void writeXML(String string, FileOutputStream fileOutputStream) throws IOException {
        fileOutputStream.write((string + "<mms.MMSHeader>\n").getBytes("UTF-8"));
        if (this.subject != null) {
            fileOutputStream.write((string + "\t<Subject>").getBytes("UTF-8"));
            fileOutputStream.write(this.subject.getBytes("UTF-8"));
            fileOutputStream.write("</Subject>\n".getBytes("UTF-8"));
        }
        if (this.delDate != null) {
            fileOutputStream.write((string + "\t<DelDate>").getBytes("UTF-8"));
            fileOutputStream.write(this.delDate.getBytes("UTF-8"));
            fileOutputStream.write("</DelDate>\n".getBytes("UTF-8"));
        }
        if (this.priority != null) {
            fileOutputStream.write((string + "\t<Priority>").getBytes("UTF-8"));
            fileOutputStream.write(this.priority.getBytes("UTF-8"));
            fileOutputStream.write("</Priority>\n".getBytes("UTF-8"));
        }
        fileOutputStream.write((string + "\t<MessageType>").getBytes("UTF-8"));
        fileOutputStream.write(this.messageType.getBytes("UTF-8"));
        fileOutputStream.write("</MessageType>\n".getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<TX-ID>").getBytes("UTF-8"));
        fileOutputStream.write(this.txID.getBytes("UTF-8"));
        fileOutputStream.write("</TX-ID>\n".getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<MMS-Version>").getBytes("UTF-8"));
        fileOutputStream.write(this.mmsVersion.getBytes("UTF-8"));
        fileOutputStream.write("</MMS-Version>\n".getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<ContentType>").getBytes("UTF-8"));
        fileOutputStream.write(this.contentType.getBytes("UTF-8"));
        fileOutputStream.write("</ContentType>\n".getBytes("UTF-8"));
        if (this.from != null) {
            fileOutputStream.write((string + "\t<From>").getBytes("UTF-8"));
            fileOutputStream.write(this.from.getBytes("UTF-8"));
            fileOutputStream.write("</From>\n".getBytes("UTF-8"));
        }
        if (this.to != null) {
            fileOutputStream.write((string + "\t<To>").getBytes("UTF-8"));
            fileOutputStream.write(this.to.getBytes("UTF-8"));
            fileOutputStream.write("</To>\n".getBytes("UTF-8"));
        }
        if (this.cc != null) {
            fileOutputStream.write((string + "\t<CC>").getBytes("UTF-8"));
            fileOutputStream.write(this.cc.getBytes("UTF-8"));
            fileOutputStream.write("</CC>\n".getBytes("UTF-8"));
        }
        if (this.bcc != null) {
            fileOutputStream.write((string + "\t<BCC>").getBytes("UTF-8"));
            fileOutputStream.write(this.bcc.getBytes("UTF-8"));
            fileOutputStream.write("</BCC>\n".getBytes("UTF-8"));
        }
        fileOutputStream.write((string + "\t<SendTime>").getBytes("UTF-8"));
        fileOutputStream.write(String.valueOf(this.sendTime).getBytes("UTF-8"));
        fileOutputStream.write("</SendTime>\n".getBytes("UTF-8"));
        fileOutputStream.write((string + "</mms.MMSHeader>\n").getBytes("UTF-8"));
    }

    public void readXML(Node node) throws SyntaxErrorException {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        this.init(null, null, null, null, null, null, null, null, null, null, null, 0L);
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (string.equals("Subject")) {
                this.subject = node2.getFirstChild().getNodeValue();
                continue;
            }
            if (string.equals("DelDate")) {
                this.delDate = node2.getFirstChild().getNodeValue();
                continue;
            }
            if (string.equals("Priority")) {
                this.priority = node2.getFirstChild().getNodeValue();
                continue;
            }
            if (string.equals("MessageType")) {
                this.messageType = node2.getFirstChild().getNodeValue();
                continue;
            }
            if (string.equals("TX-ID")) {
                this.txID = node2.getFirstChild().getNodeValue();
                continue;
            }
            if (string.equals("MMS-Version")) {
                this.mmsVersion = node2.getFirstChild().getNodeValue();
                continue;
            }
            if (string.equals("ContentType")) {
                this.contentType = node2.getFirstChild().getNodeValue();
                continue;
            }
            if (string.equals("From")) {
                this.from = node2.getFirstChild().getNodeValue();
                continue;
            }
            if (string.equals("To")) {
                this.to = node2.getFirstChild().getNodeValue();
                continue;
            }
            if (string.equals("CC")) {
                this.cc = node2.getFirstChild().getNodeValue();
                continue;
            }
            if (string.equals("BCC")) {
                this.bcc = node2.getFirstChild().getNodeValue();
                continue;
            }
            if (!string.equals("SendTime")) continue;
            this.sendTime = Long.parseLong(node2.getFirstChild().getNodeValue());
        }
    }

    public int getDirection() {
        return 2;
    }

    static String getDevicePortionOfAddress(String string) {
        MMSAddress mMSAddress = MMSAddress.getParsedMMSAddress(string);
        if (mMSAddress == null || mMSAddress.address == null) {
            throw new IllegalArgumentException("MMS Address has no device portion");
        }
        return mMSAddress.address;
    }

    private static String collectArrayAsString(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = stringArray.length;
        if (n > 0) {
            stringBuffer.append(MMSHeader.getDevicePortionOfAddress(stringArray[0]));
        }
        for (int i = 1; i < n; ++i) {
            stringBuffer.append("; ");
            stringBuffer.append(MMSHeader.getDevicePortionOfAddress(stringArray[i]));
        }
        return stringBuffer.toString();
    }

    public String getSubject() {
        return this.subject;
    }

    public String getDeliveryDate() {
        return this.delDate;
    }

    public String getPriority() {
        return this.priority;
    }

    private static String getMessageTypeString(int n) {
        if (n == 1) {
            return "m-retrieve-conf";
        }
        return "m-send-req";
    }

    public String getMessageType() {
        return this.messageType;
    }

    public String getTransactionID() {
        return this.txID;
    }

    public String getMMSVersion() {
        return this.mmsVersion;
    }

    public static String getContentTypeString(MultipartMessage multipartMessage) {
        String string;
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = multipartMessage.getStartContentId();
        if (string3 != null) {
            stringBuffer.append("application/vnd.wap.multipart.related");
        } else {
            stringBuffer.append("application/vnd.wap.multipart.mixed");
        }
        if (string3 != null) {
            stringBuffer.append("; start = <");
            stringBuffer.append(string3);
            stringBuffer.append(">; type = ");
            stringBuffer.append(multipartMessage.getMessagePart(string3).getMIMEType());
        }
        if ((string2 = multipartMessage.getApplicationID()) != null) {
            stringBuffer.append("; Application-ID = ");
            stringBuffer.append(string2);
        }
        if ((string = multipartMessage.getReplyToApplicationID()) != null) {
            stringBuffer.append("; Reply-To-Application-ID = ");
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public String getCC() {
        return this.cc;
    }

    public String getBCC() {
        return this.bcc;
    }

    public long getSendTime() {
        return this.sendTime;
    }
}

