/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.netmon.mms;

import com.sun.kvem.midp.io.j2se.wma.MessagePart;
import com.sun.kvem.midp.io.j2se.wma.MultipartMessage;
import com.sun.kvem.netmon.DisplayableMsg;
import com.sun.kvem.netmon.MsgTreeNode;
import com.sun.kvem.netmon.SyntaxErrorException;
import com.sun.kvem.netmon.mms.MMSMessage;
import com.sun.kvem.netmon.mms.MMSPart;
import com.sun.kvem.util.ToolkitResources;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MMSBody
extends DefaultMutableTreeNode
implements MsgTreeNode {
    public static final String MMS_BODY_TYPE = "mms-body";
    protected Date startDate;
    protected Date endDate;
    private MMSMessage msg;
    private MMSPart[] parts;

    public MMSBody() {
        this.msg = null;
    }

    public MMSBody(MMSMessage mMSMessage) {
        this.msg = mMSMessage;
    }

    public void init(MultipartMessage multipartMessage) {
        MessagePart[] messagePartArray = multipartMessage.getMessageParts();
        if (messagePartArray != null) {
            int n = messagePartArray.length;
            this.parts = new MMSPart[n];
            for (int i = 0; i < n; ++i) {
                MMSPart mMSPart;
                this.parts[i] = mMSPart = new MMSPart(this);
                mMSPart.init(messagePartArray[i]);
                this.add(mMSPart);
                this.msg.fireMsgUpdateEvent(mMSPart, true);
            }
        }
    }

    public MMSMessage getMessage() {
        return this.msg;
    }

    public void setMessage(MMSMessage mMSMessage) {
        this.msg = mMSMessage;
    }

    public String getType() {
        return MMS_BODY_TYPE;
    }

    public String getDefaultType() {
        return "mms";
    }

    public String getTitle() {
        return ToolkitResources.getString((String)"NETMON_BODY");
    }

    public String getToolTip() {
        return ToolkitResources.getString((String)"NETMON_BODY_TOOLTIP");
    }

    public String getURL() {
        return this.msg.getURL();
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public String toString() {
        return "";
    }

    public void writeXML(String string, FileOutputStream fileOutputStream) throws IOException {
        fileOutputStream.write((string + "<mms.MMSBody>\n").getBytes("UTF-8"));
        if (this.parts != null) {
            int n = 0;
            while (n < this.parts.length) {
                MMSPart mMSPart = this.parts[n++];
                mMSPart.writeXML(string + "\t", fileOutputStream);
            }
        }
        fileOutputStream.write((string + "</mms.MMSBody>\n").getBytes("UTF-8"));
    }

    public void readXML(Node node) throws SyntaxErrorException {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        ArrayList<MMSPart> arrayList = new ArrayList<MMSPart>();
        try {
            for (int i = 0; i < n; ++i) {
                String string;
                Node node2 = nodeList.item(i);
                if (!node2.hasChildNodes() || !(string = node2.getNodeName()).equals("mms.MMSPart")) continue;
                while (node2 != null) {
                    if (node2 instanceof Element) {
                        MMSPart mMSPart = new MMSPart(this);
                        arrayList.add(mMSPart);
                        mMSPart.readXML(node2);
                        this.add(mMSPart);
                    }
                    node2 = node2.getNextSibling();
                }
                break;
            }
        }
        catch (Exception exception) {
            throw new SyntaxErrorException(exception.getMessage());
        }
        this.parts = arrayList.toArray(new MMSPart[0]);
    }

    public DisplayableMsg getDisplayableMsg() {
        return this.msg;
    }

    public int getDirection() {
        return 2;
    }

    public MMSPart[] getParts() {
        return this.parts;
    }
}

