/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.netmon.http;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.netmon.MsgListener;
import com.sun.kvem.netmon.http.HttpMsgProducer;
import com.sun.kvem.netmon.http.HttpMsgReceiver;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;

public class HttpsMsgReceiver {
    private static final Debug debug = Debug.create((Class)HttpMsgReceiver.class);
    private static Vector listeners = new Vector();
    private static Vector streams = new Vector();
    private static final String HTTPS_MSG_TYPE = "https";

    public static void clearAll() {
        listeners.removeAllElements();
        streams.removeAllElements();
    }

    public static int newStream(String string, int n, long l) {
        try {
            HttpMsgProducer httpMsgProducer = new HttpMsgProducer(string, n, HttpsMsgReceiver.getType(), l);
            httpMsgProducer.addMsgListener(HttpsMsgReceiver.getListeners());
            OutputStream outputStream = httpMsgProducer.getOutputStream();
            HttpsMsgReceiver.getStreams().addElement(outputStream);
            httpMsgProducer.start();
            return HttpsMsgReceiver.getStreams().indexOf(outputStream);
        }
        catch (IOException iOException) {
            debug.exception(1, (Throwable)iOException);
            return -1;
        }
    }

    public static synchronized void updateMsgOneByte(int n, int n2) {
        try {
            OutputStream outputStream = (OutputStream)HttpsMsgReceiver.getStreams().elementAt(n);
            if (outputStream != null) {
                outputStream.write(n2);
                outputStream.flush();
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            debug.exception(1, (Throwable)arrayIndexOutOfBoundsException);
        }
        catch (IOException iOException) {
            debug.exception(1, (Throwable)iOException);
        }
    }

    public static synchronized void updateMsgBuff(int n, byte[] byArray, int n2, int n3) {
        try {
            OutputStream outputStream = (OutputStream)HttpsMsgReceiver.getStreams().elementAt(n);
            if (outputStream != null) {
                outputStream.write(byArray, n2, n3);
                outputStream.flush();
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            debug.exception(1, (Throwable)arrayIndexOutOfBoundsException);
        }
        catch (IOException iOException) {
            debug.exception(1, (Throwable)iOException);
        }
    }

    public static void close(int n) {
        try {
            if ((OutputStream)HttpsMsgReceiver.getStreams().elementAt(n) != null) {
                ((OutputStream)HttpsMsgReceiver.getStreams().elementAt(n)).close();
                HttpsMsgReceiver.getStreams().setElementAt(null, n);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            debug.exception(1, (Throwable)arrayIndexOutOfBoundsException);
        }
        catch (IOException iOException) {
            debug.exception(1, (Throwable)iOException);
        }
    }

    public static void addMsgListener(MsgListener msgListener) {
        HttpsMsgReceiver.getListeners().addElement(msgListener);
    }

    public static void removeMsgListener(MsgListener msgListener) {
        HttpsMsgReceiver.getListeners().removeElement(msgListener);
    }

    protected static Vector getListeners() {
        return listeners;
    }

    protected static Vector getStreams() {
        return streams;
    }

    protected static String getType() {
        return HTTPS_MSG_TYPE;
    }
}

