/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.netmon.http;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.netmon.MsgListener;
import com.sun.kvem.netmon.http.HttpMsgProducer;
import com.sun.kvem.util.PropWrapper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;

public class HttpMsgReceiver {
    private static final Debug debug = Debug.create((Class)HttpMsgReceiver.class);
    private static final Debug debugBytes = Debug.create((Class)HttpMsgReceiver.class, (String)"bytes");
    private static Vector listeners = new Vector();
    private static Vector streams = new Vector();
    static final String HTTP_MSG_TYPE = "http";
    private static PropWrapper props;
    private static PropWrapper extProps;
    public static int Count;

    public static synchronized void clearAll() {
        listeners.removeAllElements();
        streams.removeAllElements();
    }

    public static int newStream(String string, int n, long l) {
        try {
            HttpMsgProducer httpMsgProducer = new HttpMsgProducer(string, n, HttpMsgReceiver.getType(), l);
            httpMsgProducer.addMsgListener(HttpMsgReceiver.getListeners());
            OutputStream outputStream = httpMsgProducer.getOutputStream();
            HttpMsgReceiver.getStreams().addElement(outputStream);
            httpMsgProducer.start();
            int n2 = HttpMsgReceiver.getStreams().indexOf(outputStream);
            return n2;
        }
        catch (IOException iOException) {
            debug.exception(1, (Throwable)iOException);
            return -1;
        }
    }

    public static int numOfOpenStreams() {
        int n = 0;
        Enumeration enumeration = HttpMsgReceiver.getStreams().elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e == null) continue;
            ++n;
        }
        return n;
    }

    public static synchronized void updateMsgOneByte(int n, int n2) {
        debugBytes.println(3, "{0}", (Object)("char md=" + n + " ch:'" + (char)n2 + "' val=" + n2));
        try {
            OutputStream outputStream = (OutputStream)HttpMsgReceiver.getStreams().elementAt(n);
            if (outputStream != null) {
                outputStream.write(n2);
                outputStream.flush();
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            debug.exception(1, (Throwable)arrayIndexOutOfBoundsException);
        }
        catch (IOException iOException) {
            HttpMsgReceiver.close(n);
            debug.exception(1, (Throwable)iOException);
        }
    }

    public static synchronized void updateMsgBuff(int n, byte[] byArray, int n2, int n3) {
        Object object;
        if (debugBytes.level(3)) {
            object = new byte[n3];
            System.arraycopy(byArray, 0, object, 0, n3);
            debugBytes.println(3, "{0}", (Object)("buff size=" + n3 + " md=" + n + " :\n" + new String((byte[])object) + "\nend buff md=" + n));
        }
        try {
            object = (OutputStream)HttpMsgReceiver.getStreams().elementAt(n);
            if (object != null) {
                ((OutputStream)object).write(byArray, n2, n3);
                ((OutputStream)object).flush();
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            debug.exception(1, (Throwable)arrayIndexOutOfBoundsException);
        }
        catch (IOException iOException) {
            HttpMsgReceiver.close(n);
            debug.exception(1, (Throwable)iOException);
        }
    }

    public static void close(int n) {
        try {
            OutputStream outputStream = (OutputStream)HttpMsgReceiver.getStreams().elementAt(n);
            if (outputStream != null) {
                outputStream.close();
                HttpMsgReceiver.getStreams().setElementAt(null, n);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            debug.exception(1, (Throwable)arrayIndexOutOfBoundsException);
        }
        catch (IOException iOException) {
            debug.exception(1, (Throwable)iOException);
        }
    }

    public static void addMsgListener(MsgListener msgListener) {
        HttpMsgReceiver.getListeners().addElement(msgListener);
    }

    public static void removeMsgListener(MsgListener msgListener) {
        HttpMsgReceiver.getListeners().removeElement(msgListener);
    }

    protected static Vector getListeners() {
        return listeners;
    }

    protected static Vector getStreams() {
        return streams;
    }

    protected static String getType() {
        return HTTP_MSG_TYPE;
    }

    static {
        Count = 0;
    }
}

