/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.netmon.http;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.netmon.DisplayableMsg;
import com.sun.kvem.netmon.MsgListener;
import com.sun.kvem.netmon.SyntaxErrorException;
import com.sun.kvem.netmon.http.HttpMessage;
import com.sun.kvem.netmon.util.Queue;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;

public class HttpMsgProducer
extends Thread {
    private static final Debug debug = Debug.create((Class)HttpMsgProducer.class);
    public static int Count = 0;
    private Queue queue = new Queue();
    private Vector listeners = new Vector();
    private int direction;
    private String msgType;
    private String URL;
    private long groupid;

    public HttpMsgProducer(String string, int n, String string2, long l) throws IOException {
        this.direction = n;
        this.msgType = string2;
        this.URL = string;
        this.groupid = l;
    }

    public OutputStream getOutputStream() {
        return this.queue.getOutputStream();
    }

    public synchronized void addMsgListener(MsgListener msgListener) {
        this.listeners.addElement(msgListener);
    }

    public synchronized void addMsgListener(Collection collection) {
        this.listeners.addAll(collection);
    }

    public synchronized void post(DisplayableMsg displayableMsg) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            MsgListener msgListener = (MsgListener)enumeration.nextElement();
            msgListener.post(displayableMsg);
        }
    }

    public void run() {
        HttpMessage httpMessage = null;
        try {
            boolean bl = true;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(this.queue.getInputStream());
            while (bl) {
                try {
                    httpMessage = new HttpMessage();
                    httpMessage.setDirection(this.direction);
                    httpMessage.setType(this.msgType);
                    httpMessage.setURL(this.URL);
                    httpMessage.setGroup(this.groupid);
                    httpMessage.readWTKHeader(bufferedInputStream, null);
                    httpMessage.readHeader(bufferedInputStream, null);
                    if (!httpMessage.isEmpty()) {
                        this.post(httpMessage);
                        httpMessage.readBody(bufferedInputStream, null);
                        continue;
                    }
                    bl = false;
                }
                catch (SyntaxErrorException syntaxErrorException) {
                    debug.exception(1, (Throwable)syntaxErrorException);
                }
            }
        }
        catch (IOException iOException) {
            debug.exception(2, (Throwable)iOException);
        }
    }
}

