/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.netmon.http;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.netmon.DisplayableMsg;
import com.sun.kvem.netmon.MsgFilterCriteria;
import com.sun.kvem.netmon.MsgTreeNode;
import com.sun.kvem.netmon.MsgUpdateListener;
import com.sun.kvem.netmon.SyntaxErrorException;
import com.sun.kvem.netmon.http.HttpBody;
import com.sun.kvem.netmon.http.HttpHeader;
import com.sun.kvem.netmon.util.Writer;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HttpMessage
extends DefaultMutableTreeNode
implements DisplayableMsg {
    protected HttpHeader header;
    protected HttpBody body;
    protected Date startDate = null;
    protected Date endDate = null;
    protected int direction;
    protected String msgType;
    protected String URL;
    protected long group;
    protected boolean done = false;
    private transient Vector msgUpdateListeners = new Vector();
    private static final Debug debug = Debug.create((Class)HttpMessage.class);

    public HttpMessage() {
        this.header = new HttpHeader(this);
        this.body = new HttpBody(this);
    }

    public void setType(String string) {
        this.msgType = string;
    }

    public void setDirection(int n) {
        this.direction = n;
    }

    public void setURL(String string) {
        this.URL = string;
    }

    public void setGroup(long l) {
        this.group = l;
    }

    public void setComplete(boolean bl) {
        this.done = bl;
        this.fireMsgUpdateEvent(this, false);
    }

    public HttpHeader getHeader() {
        return this.header;
    }

    public HttpBody getBody() {
        return this.body;
    }

    public String getType() {
        return this.msgType;
    }

    public String getTitle() {
        return this.header.getStartLine();
    }

    public String getToolTip() {
        return this.header.getToolTip();
    }

    public boolean isEmpty() {
        return this.header.isEmpty();
    }

    public boolean isComplete() {
        return this.done;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public int getDirection() {
        return this.direction;
    }

    public String getURL() {
        return this.URL;
    }

    public long getGroup() {
        return this.group;
    }

    public DisplayableMsg getDisplayableMsg() {
        return this;
    }

    public String toString() {
        return "" + this.header;
    }

    public void readHeader(InputStream inputStream, String string) throws IOException, SyntaxErrorException {
        this.done = false;
        this.header.read(inputStream, string);
        this.fireMsgUpdateEvent(this, false);
    }

    public void readBody(InputStream inputStream, String string) throws IOException, SyntaxErrorException {
        this.add(this.body);
        this.body.read(inputStream, string);
        this.endDate = new Date();
        this.done = true;
        this.fireMsgUpdateEvent(this.body, true);
    }

    public void readWTKHeader(InputStream inputStream, String string) throws IOException {
        String string2;
        if (string == null) {
            string = "8859_1";
        }
        if ((string2 = HttpHeader.readLine(inputStream, string)).length() == 0) {
            this.startDate = new Date();
        } else {
            long l = Long.parseLong(string2);
            this.startDate = new Date(l);
        }
    }

    public void addMsgUpdateListener(MsgUpdateListener msgUpdateListener) {
        if (this.msgUpdateListeners == null) {
            this.msgUpdateListeners = new Vector();
        }
        this.msgUpdateListeners.addElement(msgUpdateListener);
    }

    public void removeMsgUpdateListener(MsgUpdateListener msgUpdateListener) {
        this.msgUpdateListeners.removeElement(msgUpdateListener);
    }

    public void removeAllMsgUpdateListener() {
        this.msgUpdateListeners.removeAllElements();
    }

    public void fireMsgUpdateEvent(MsgTreeNode msgTreeNode, boolean bl) {
        Enumeration enumeration = this.msgUpdateListeners.elements();
        while (enumeration.hasMoreElements()) {
            MsgUpdateListener msgUpdateListener = (MsgUpdateListener)enumeration.nextElement();
            msgUpdateListener.msgUpdated(this, msgTreeNode, bl);
        }
    }

    public void writeXML(String string, FileOutputStream fileOutputStream) throws IOException {
        fileOutputStream.write((string + "<http.HttpMessage>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<StartDate>" + this.startDate.getTime() + "</StartDate>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<EndDate>" + (this.endDate == null ? -1L : this.endDate.getTime()) + "</EndDate>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<Direction>" + this.direction + "</Direction>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<MsgType>" + this.msgType + "</MsgType>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<URL>" + Writer.encodeXML(this.URL) + "</URL>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<Group>" + this.group + "</Group>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<Complete>" + this.done + "</Complete>\n").getBytes("UTF-8"));
        this.header.writeXML(string + "\t", fileOutputStream);
        this.body.writeXML(string + "\t", fileOutputStream);
        fileOutputStream.write((string + "</http.HttpMessage>\n").getBytes("UTF-8"));
    }

    public void readXML(Node node) throws SyntaxErrorException {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.hasChildNodes()) continue;
            String string = node2.getNodeName();
            String string2 = node2.getFirstChild().getNodeValue();
            if (string.equals("StartDate")) {
                this.startDate = new Date(Long.parseLong(string2));
                continue;
            }
            if (string.equals("EndDate")) {
                this.endDate = new Date(Long.parseLong(string2));
                continue;
            }
            if (string.equals("Direction")) {
                this.direction = Integer.parseInt(string2);
                continue;
            }
            if (string.equals("MsgType")) {
                this.msgType = string2;
                continue;
            }
            if (string.equals("URL")) {
                this.URL = string2;
                continue;
            }
            if (string.equals("Group")) {
                this.group = Long.parseLong(string2);
                continue;
            }
            if (string.equals("Complete")) {
                this.done = Boolean.valueOf(string2);
                continue;
            }
            if (string.equals("http.HttpHeader")) {
                this.header.readXML(node2);
                this.fireMsgUpdateEvent(this, false);
                continue;
            }
            if (string.equals("http.HttpBody")) {
                this.body.readXML(node2);
                this.add(this.body);
                this.fireMsgUpdateEvent(this, false);
                this.fireMsgUpdateEvent(this.body, true);
                continue;
            }
            debug.println(2, "Unknown key: {0}", (Object)string);
        }
    }

    public boolean complyWith(MsgFilterCriteria msgFilterCriteria) {
        Properties properties = msgFilterCriteria.getProperties();
        String string = properties.getProperty("URL", "");
        return this.getURL().toLowerCase().indexOf(string.toLowerCase()) >= 0 && this.header.complyWith(msgFilterCriteria) && this.body.complyWith(msgFilterCriteria);
    }

    public String getDefaultType() {
        return "http";
    }
}

