/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.netmon.http;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.netmon.DisplayableMsg;
import com.sun.kvem.netmon.MsgFilterCriteria;
import com.sun.kvem.netmon.MsgTreeNode;
import com.sun.kvem.netmon.SyntaxErrorException;
import com.sun.kvem.netmon.http.HttpMessage;
import com.sun.kvem.netmon.http.ListVector;
import com.sun.kvem.netmon.util.Writer;
import com.sun.kvem.util.ToolkitResources;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HttpHeader
extends DefaultMutableTreeNode
implements MsgTreeNode {
    public static final String HTTP_HEADER_TYPE = "http-header";
    public static final char CR = '\r';
    public static final char LF = '\n';
    public static final String SCR = "\r";
    public static final String SLF = "\n";
    public static final String LF2 = "\n\n";
    public static final String CRLF = "\r\n";
    public static final String CRLF2 = "\r\n\r\n";
    public static final char HEADER_VALUE_SEPERATOR = ',';
    public static final char KEY_VALUE_SEPERATOR = ':';
    public static final char SPACE = ' ';
    public static final char COMMENT = ';';
    public static final int HTTP_DEFAULT_PORT = 80;
    public static final int HTTPS_DEFAULT_PORT = 480;
    public static final int FTP_DEFAULT_PORT = 21;
    public static final String HTTP_PROTOCOL = "http";
    public static final String HTTPS_PROTOCOL = "https";
    public static final String FTP_PROTOCOL = "ftp";
    public static final String HTTP_VERSION_1_1 = "HTTP/1.1";
    public static final String HTTP_VERSION_1_0 = "HTTP/1.0";
    public static final int DEFAULT_BUFF_SIZE = 256;
    public static final String DEFAULT_ENCODING = "8859_1";
    private static final Debug debug = Debug.create((Class)HttpHeader.class);
    private static int byteBuffAccSize = 256;
    protected HttpMessage msg;
    protected Date startDate;
    protected Date endDate;
    private String encoding = "8859_1";
    private String startLine = "";
    private Hashtable header = new Hashtable();

    public HttpHeader() {
        this.init(null, DEFAULT_ENCODING);
    }

    public HttpHeader(HttpMessage httpMessage) {
        this.init(httpMessage, DEFAULT_ENCODING);
    }

    public HttpHeader(HttpMessage httpMessage, String string) {
        this.init(httpMessage, string);
    }

    public static String readLine(Reader reader) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = reader.read();
        while (n >= 0 && n != 10) {
            stringBuffer.append((char)n);
            n = reader.read();
        }
        String string = stringBuffer.toString();
        if (string.startsWith(";")) {
            return HttpHeader.readLine(reader);
        }
        if (string.endsWith(SCR)) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static void readTillEmptyLine(InputStream inputStream) throws IOException {
        String string = HttpHeader.readLine(inputStream, DEFAULT_ENCODING);
        while (string != null && string.length() != 0) {
            string = HttpHeader.readLine(inputStream, DEFAULT_ENCODING);
        }
    }

    public static void readCRLF(InputStream inputStream) throws IOException, SyntaxErrorException {
        byte by = (byte)inputStream.read();
        byte by2 = (byte)inputStream.read();
        if (by < 0 || by2 < 0) {
            throw new IOException("Unexpected connection close while parsing");
        }
        if (by != 13 || by2 != 10) {
            throw new SyntaxErrorException("CRLF missing");
        }
    }

    public static String readLine(InputStream inputStream, String string) throws IOException {
        byte[] byArray = new byte[1];
        StringBuffer stringBuffer = new StringBuffer();
        int n = inputStream.read(byArray);
        if (n == -1) {
            throw new IOException("Unexpected connection close while parsing");
        }
        while (n > 0 && byArray[0] != 10) {
            stringBuffer.append(new String(byArray, string));
            n = inputStream.read(byArray);
        }
        if (n == -1) {
            throw new IOException("Unexpected connection close while parsing");
        }
        n = stringBuffer.length();
        String string2 = n >= 1 && stringBuffer.charAt(n - 1) == '\r' ? stringBuffer.substring(0, n - 1) : stringBuffer.toString();
        return string2;
    }

    public void setStartLine(String string) throws SyntaxErrorException {
        this.startLine = string;
    }

    public void setHeader(String string, String string2) {
        Vector vector = this.parseHeaderValueLine(string2, null);
        this.setHeaderVec(string, vector);
    }

    public void setVersion(String string) throws SyntaxErrorException {
        throw new RuntimeException("Cannot set version with unknown header type (request/response)");
    }

    public void setMsg(HttpMessage httpMessage) {
        this.msg = httpMessage;
    }

    public boolean isRequest() {
        return this.msg.getDirection() == 0;
    }

    public boolean isResponse() {
        return this.msg.getDirection() == 1;
    }

    public String getStartLine() {
        return this.startLine;
    }

    public String getHeader(String string) {
        Vector vector = this.getHeaderVec(string);
        if (vector == null) {
            return null;
        }
        try {
            return (String)vector.firstElement();
        }
        catch (NoSuchElementException noSuchElementException) {
            return "";
        }
    }

    public Hashtable getHeaderHashtable() {
        return this.header;
    }

    public Enumeration getHeaders(String string) {
        Vector vector = this.getHeaderVec(string);
        if (vector == null) {
            return null;
        }
        return vector.elements();
    }

    public String getHeadersStr(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.getHeaders(string);
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            stringBuffer.append(string2);
            if (!enumeration.hasMoreElements()) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    public Enumeration getHeaderNames() {
        return this.header.keys();
    }

    public int getIntHeader(String string) throws NumberFormatException {
        return Integer.parseInt(this.getHeader(string));
    }

    public String getMsgAsString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.startLine);
        stringBuffer.append(CRLF);
        stringBuffer.append(this.getHeaderAsString());
        return stringBuffer.toString();
    }

    public String getHeaderAsString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2 = (String)enumeration.nextElement();
            stringBuffer.append(string2);
            stringBuffer.append(':');
            Enumeration enumeration2 = this.getHeaders(string2);
            if (enumeration2.hasMoreElements()) {
                string = (String)enumeration2.nextElement();
                stringBuffer.append(' ');
                stringBuffer.append(string);
            }
            while (enumeration2.hasMoreElements()) {
                string = (String)enumeration2.nextElement();
                stringBuffer.append(',');
                stringBuffer.append(string);
            }
            stringBuffer.append(CRLF);
        }
        stringBuffer.append(CRLF);
        return stringBuffer.toString();
    }

    public String getVersion() {
        throw new RuntimeException("Cannot retrive version with unknown header type (request/response)");
    }

    public String getType() {
        return HTTP_HEADER_TYPE;
    }

    public String getDefaultType() {
        return HTTP_PROTOCOL;
    }

    public String getTitle() {
        return ToolkitResources.getString((String)"NETMON_HEADER");
    }

    public String getToolTip() {
        return this.getStartLine();
    }

    public boolean isEmpty() {
        return this.getStartLine().length() == 0;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public DisplayableMsg getDisplayableMsg() {
        return this.msg;
    }

    public void read(InputStream inputStream, String string) throws IOException, SyntaxErrorException {
        this.startDate = new Date();
        if (string == null) {
            string = this.encoding;
        }
        Reader reader = this.readHttpHeaderSection(inputStream, string);
        this.readStartLine(reader);
        this.readHttpHeader(reader);
        this.endDate = new Date();
    }

    public void readStartLine(Reader reader) throws IOException {
        this.startLine = HttpHeader.readLine(reader);
        if (this.startLine != null && this.startLine.length() == 0) {
            this.startLine = HttpHeader.readLine(reader);
        }
    }

    public void addToHeader(String string, String string2) {
        Vector vector = this.parseHeaderValueLine(string2, null);
        Vector vector2 = this.getHeaderVec(string);
        if (vector2 == null) {
            this.setHeaderVec(string, vector);
        } else {
            vector2.addAll(vector);
        }
    }

    public void removeHeader(String string) {
        this.header.remove(string.toLowerCase().trim());
    }

    public void removeHeaderValues(String string, String string2) {
        Vector vector = this.parseHeaderValueLine(string2, null);
        this.getHeaderVec(string).removeAll(vector);
    }

    public void clearHeader() {
        this.header.clear();
    }

    private void setHeaderVec(String string, Vector vector) {
        this.header.put(string.toLowerCase().trim(), vector);
    }

    private Vector getHeaderVec(String string) {
        return (Vector)this.header.get(string.toLowerCase().trim());
    }

    public String toString() {
        return this.getMsgAsString();
    }

    public boolean equals(HttpHeader httpHeader) {
        return httpHeader.getStartLine().equals(this.getStartLine()) && this.header.equals(httpHeader.header);
    }

    public void writeXML(String string, FileOutputStream fileOutputStream) throws IOException {
        fileOutputStream.write((string + "<http.HttpHeader>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<StartLine>" + Writer.encodeXML(this.startLine) + "</StartLine>\n").getBytes("UTF-8"));
        Enumeration enumeration = this.header.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            fileOutputStream.write((string + "\t<Key>").getBytes("UTF-8"));
            fileOutputStream.write(string2.getBytes("UTF-8"));
            fileOutputStream.write("</Key>\n".getBytes("UTF-8"));
            fileOutputStream.write((string + "\t<Value>").getBytes("UTF-8"));
            fileOutputStream.write(this.getHeadersStr(string2).getBytes("UTF-8"));
            fileOutputStream.write("</Value>\n".getBytes("UTF-8"));
        }
        fileOutputStream.write((string + "</http.HttpHeader>\n").getBytes("UTF-8"));
    }

    public void readXML(Node node) throws SyntaxErrorException {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (string.equals("StartLine")) {
                this.startLine = node2.getFirstChild().getNodeValue();
                continue;
            }
            if (string.equals("Key")) {
                String string2 = node2.getFirstChild().getNodeValue();
                Node node3 = nodeList.item(++i);
                while (!node3.hasChildNodes()) {
                    node3 = nodeList.item(++i);
                }
                if (string.equals("Value")) {
                    throw new SyntaxErrorException();
                }
                String string3 = node3.getFirstChild().getNodeValue();
                this.addToHeader(string2, string3);
                continue;
            }
            debug.println(2, "Unknown key: {0}", (Object)string);
        }
    }

    public boolean complyWith(MsgFilterCriteria msgFilterCriteria) {
        Properties properties = msgFilterCriteria.getProperties();
        String string = properties.getProperty("statusLine", "");
        String string2 = properties.getProperty("header", "");
        return this.getStartLine().toLowerCase().indexOf(string.toLowerCase()) != -1 && this.headerContains(string2.toLowerCase());
    }

    private void init(HttpMessage httpMessage, String string) {
        this.setUserObject(ToolkitResources.getString((String)"NETMON_HEADER"));
        this.encoding = string;
        this.msg = httpMessage;
    }

    private Reader readHttpHeaderSection(InputStream inputStream, String string) throws IOException, SyntaxErrorException {
        byte[] byArray;
        byte[] byArray2 = new byte[byteBuffAccSize];
        int n = 0;
        int n2 = inputStream.read();
        if (n2 >= 0) {
            byArray2[n] = (byte)n2;
            this.startDate = new Date();
        }
        while (!(n2 < 0 || n >= 2 && byArray2[n] == 10 && byArray2[n - 1] == 10 || n >= 4 && byArray2[n] == 10 && byArray2[n - 1] == 13 && byArray2[n - 2] == 10 && byArray2[n - 3] == 13)) {
            if (++n >= byArray2.length) {
                byteBuffAccSize = byArray2.length * 2;
                byArray = new byte[byArray2.length * 2];
                System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
                byArray2 = byArray;
            }
            if ((n2 = inputStream.read()) < 0) continue;
            byArray2[n] = (byte)n2;
        }
        byArray = new byte[n];
        System.arraycopy(byArray2, 0, byArray, 0, n);
        debug.println(2, "{0}", (Object)("header section:--\n" + new String(byArray) + "\nend header section--"));
        if (debug.level(3)) {
            StringBuffer stringBuffer = new StringBuffer();
            System.out.print("\nbuff:");
            for (int i = 0; i < byArray.length; ++i) {
                stringBuffer.append(" ");
                stringBuffer.append(byArray[i]);
            }
            System.out.println(stringBuffer.toString());
            System.out.println(SLF);
        }
        if (n2 < 0) {
            throw new IOException("Unexpected connection close while parsing");
        }
        return new InputStreamReader((InputStream)new ByteArrayInputStream(byArray), string);
    }

    private void readHttpHeader(Reader reader) throws IOException, SyntaxErrorException {
        this.clearHeader();
        String string = HttpHeader.readLine(reader);
        while (string.length() > 0) {
            int n = string.indexOf(58);
            if (n <= 0) {
                debug.println(2, "syntax error while parsing header\nline={0}\nStatus line={1}", (Object)string, (Object)this.startLine);
                throw new SyntaxErrorException("line: " + string);
            }
            Vector vector = this.parseHeaderValueLine(string.substring(n + 1).trim(), null);
            this.setHeaderVec(string.substring(0, n), vector);
            string = HttpHeader.readLine(reader);
        }
    }

    private Vector parseHeaderValueLine(String string, Vector vector) {
        if (vector == null) {
            vector = new ListVector();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken().trim());
        }
        return vector;
    }

    private boolean headerContains(String string) {
        Enumeration enumeration = this.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (this.getHeadersStr(string2).toLowerCase().indexOf(string) < 0 && string2.toLowerCase().indexOf(string) < 0) continue;
            return true;
        }
        return false;
    }

    public int getDirection() {
        return 2;
    }
}

