/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.netmon.http;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.netmon.DisplayableMsg;
import com.sun.kvem.netmon.MsgTreeNode;
import com.sun.kvem.netmon.SyntaxErrorException;
import com.sun.kvem.netmon.http.HttpBody;
import com.sun.kvem.netmon.http.HttpHeader;
import com.sun.kvem.netmon.util.HexConverter;
import com.sun.kvem.util.ToolkitResources;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HttpChunk
extends DefaultMutableTreeNode
implements MsgTreeNode {
    private static final Debug debug = Debug.create((Class)HttpChunk.class);
    public static final String CHUNK_TYPE = "http-chunk";
    public static final char EXTENTION_SEPERATOR = ';';
    protected Date startDate;
    protected Date endDate;
    private byte[] chunk = new byte[0];
    private int chunkIndex;
    private String extentions = "";
    private HttpBody body;

    public HttpChunk() {
        this.chunkIndex = -1;
        this.body = null;
    }

    public HttpChunk(int n, HttpBody httpBody) {
        this.chunkIndex = n;
        this.body = httpBody;
    }

    public void setChunk(byte[] byArray) {
        this.chunk = byArray;
    }

    public void setBody(HttpBody httpBody) {
        this.body = httpBody;
    }

    public String getType() {
        return CHUNK_TYPE;
    }

    public String getDefaultType() {
        return "http";
    }

    public String getTitle() {
        if (this.chunkIndex >= 0) {
            return ToolkitResources.getString((String)"NETMON_CHUNK") + " " + this.chunkIndex;
        }
        return ToolkitResources.getString((String)"NETMON_CHUNK");
    }

    public String getToolTip() {
        return ToolkitResources.getString((String)"NETMON_CHUNK_TOOLTIP");
    }

    public int getSize() {
        if (this.chunk == null) {
            return 0;
        }
        try {
            return this.getSize("8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Default encoding 8859_1 is not supported.");
        }
    }

    public int getSize(String string) throws UnsupportedEncodingException {
        if (this.chunk == null) {
            return 0;
        }
        return this.getStatusLine().getBytes(string).length + 2 + this.chunk.length + (this.chunk.length > 0 ? 2 : 0);
    }

    public int getDataSize() {
        return this.chunk.length;
    }

    public String getStatusLine() {
        return Integer.toHexString(this.chunk.length) + ';' + this.extentions;
    }

    public byte[] getBytes() {
        try {
            return this.getBytes("8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            debug.exception(1, (Throwable)unsupportedEncodingException);
            return null;
        }
    }

    public byte[] getBytes(String string) throws UnsupportedEncodingException {
        String string2 = this.getStatusLine() + "\r\n";
        byte[] byArray = new byte[string2.length() + this.chunk.length + 2];
        byte[] byArray2 = string2.getBytes(string);
        System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
        System.arraycopy(this.chunk, 0, byArray, byArray2.length, this.chunk.length);
        System.arraycopy("\r\n".getBytes(string), 0, byArray, byArray.length - 2, 2);
        return byArray;
    }

    public byte[] getDataBytes() {
        return this.chunk;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public String getURL() {
        return this.body.getURL();
    }

    public void read(InputStream inputStream, String string) throws IOException, SyntaxErrorException {
        this.startDate = new Date();
        if (string == null) {
            string = "8859_1";
        }
        this.parseStatusLine(inputStream, string);
        this.readChunkBody(inputStream);
        this.endDate = new Date();
    }

    public String toString() {
        try {
            byte[] byArray = this.getBytes("8859_1");
            return new String(byArray, "8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            debug.exception(1, (Throwable)unsupportedEncodingException);
            return unsupportedEncodingException.getMessage();
        }
    }

    public void writeXML(String string, FileOutputStream fileOutputStream) throws IOException {
        fileOutputStream.write((string + "<http.HttpChunk>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<Length>" + this.chunk.length + "</Length>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<Data>\n").getBytes("UTF-8"));
        fileOutputStream.write((HexConverter.toHex(string + "\t", this.chunk) + "\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t</Data>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "</http.HttpChunk>\n").getBytes("UTF-8"));
    }

    public void readXML(Node node) throws SyntaxErrorException {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.hasChildNodes()) continue;
            String string = node2.getNodeName();
            String string2 = node2.getFirstChild().getNodeValue();
            if (!string.equals("Data")) continue;
            this.chunk = HexConverter.toBinary(string2);
        }
    }

    private void parseStatusLine(InputStream inputStream, String string) throws IOException, SyntaxErrorException {
        int n;
        String string2 = HttpHeader.readLine(inputStream, string);
        int n2 = string2.indexOf(59);
        try {
            if (n2 < 0) {
                n = Integer.parseInt(string2.trim(), 16);
            } else {
                n = Integer.parseInt(string2.substring(0, n2).trim(), 16);
                this.extentions = string2.substring(n2 + 1);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new SyntaxErrorException("Invalid chunk size. line = <" + string2 + ">");
        }
        this.chunk = new byte[n];
    }

    private void readChunkBody(InputStream inputStream) throws IOException, SyntaxErrorException {
        if (this.chunk.length == 0) {
            return;
        }
        int n = inputStream.read(this.chunk);
        int n2 = 0;
        while (n >= 0 && n2 < this.chunk.length) {
            if ((n2 += n) >= this.chunk.length) continue;
            n = inputStream.read(this.chunk, n2, this.chunk.length - n2);
        }
        if (n < 0) {
            throw new IOException("Unexpected connection close while parsing");
        }
        HttpHeader.readCRLF(inputStream);
    }

    public DisplayableMsg getDisplayableMsg() {
        return this.body.getDisplayableMsg();
    }

    public int getDirection() {
        return 2;
    }
}

