/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.netmon.http;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.netmon.DisplayableMsg;
import com.sun.kvem.netmon.MsgFilterCriteria;
import com.sun.kvem.netmon.MsgTreeNode;
import com.sun.kvem.netmon.SyntaxErrorException;
import com.sun.kvem.netmon.http.HttpChunk;
import com.sun.kvem.netmon.http.HttpMessage;
import com.sun.kvem.netmon.util.HexConverter;
import com.sun.kvem.util.ToolkitResources;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HttpBody
extends DefaultMutableTreeNode
implements MsgTreeNode {
    public static final int LENGTH_TYPE_CHUNK = 0;
    public static final int LENGTH_TYPE_LENGTH = 1;
    public static final int LENGTH_TYPE_CON_CLOSE = 3;
    public static final int LENGTH_TYPE_NO_BODY = 4;
    public static final String CONTENT_LENGTH_KEY = "Content-Length";
    public static final String TRANSFER_ENCODING_KEY = "Transfer-Encoding";
    public static final String CHUNK_TRANSFER_ENC = "chunked";
    public static final String HTTP_BODY_TYPE = "http-body";
    protected Date startDate;
    protected Date endDate;
    private HttpMessage msg;
    private int lengthType = -1;
    private int length = -1;
    private Vector chunks;
    private ByteArrayOutputStream rowBody;
    private ByteArrayOutputStream contentBody = this.rowBody = new ByteArrayOutputStream();
    private static final Debug debug = Debug.create((Class)HttpBody.class);

    public HttpBody() {
        this.msg = null;
    }

    public HttpBody(HttpMessage httpMessage) {
        this.msg = httpMessage;
    }

    public void setMsg(HttpMessage httpMessage) {
        this.msg = httpMessage;
        if (this.chunks != null) {
            Enumeration enumeration = this.chunks.elements();
            while (enumeration.hasMoreElements()) {
                HttpChunk httpChunk = (HttpChunk)enumeration.nextElement();
                httpChunk.setBody(this);
            }
        }
    }

    public int getLengthType() {
        return this.lengthType;
    }

    public int getSize() {
        try {
            return this.getSize("8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("default encoding 8859_1 is not supported");
        }
    }

    public int getSize(String string) throws UnsupportedEncodingException {
        return this.rowBody.size();
    }

    public byte[] getRowBytes() {
        return this.rowBody.toByteArray();
    }

    public byte[] getContentBytes() {
        return this.contentBody.toByteArray();
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.rowBody.toByteArray());
    }

    public String getType() {
        return HTTP_BODY_TYPE;
    }

    public String getDefaultType() {
        return "http";
    }

    public String getTitle() {
        return ToolkitResources.getString((String)"NETMON_BODY");
    }

    public String getToolTip() {
        return ToolkitResources.getString((String)"NETMON_BODY_TOOLTIP");
    }

    public String getURL() {
        return this.msg.getURL();
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void read(InputStream inputStream, String string) throws IOException, SyntaxErrorException {
        this.startDate = new Date();
        if (string == null) {
            string = "8859_1";
        }
        this.findContentLengthType();
        switch (this.lengthType) {
            case 0: {
                this.readChunks(inputStream, string);
                break;
            }
            case 1: {
                this.readBodyLength(inputStream);
                break;
            }
            case 3: {
                this.readBodyConClose(inputStream);
                break;
            }
            case 4: {
                break;
            }
            default: {
                throw new SyntaxErrorException("unknown content length");
            }
        }
        this.endDate = new Date();
        if (debug.level(3)) {
            StringBuffer stringBuffer = new StringBuffer();
            System.out.print("\nbody:");
            byte[] byArray = this.getRowBytes();
            for (int i = Math.max(0, byArray.length - 4); i < byArray.length; ++i) {
                stringBuffer.append(" ");
                stringBuffer.append(byArray[i]);
            }
            System.out.println(stringBuffer.toString());
            System.out.println("\n");
        }
    }

    public String toString() {
        return new String(this.contentBody.toByteArray());
    }

    public void writeXML(String string, FileOutputStream fileOutputStream) throws IOException {
        fileOutputStream.write((string + "<http.HttpBody>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<LengthType>" + this.lengthType + "</LengthType>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<Length>" + this.length + "</Length>\n").getBytes("UTF-8"));
        if (this.lengthType == 0) {
            if (this.chunks != null) {
                Enumeration enumeration = this.chunks.elements();
                while (enumeration.hasMoreElements()) {
                    HttpChunk httpChunk = (HttpChunk)enumeration.nextElement();
                    httpChunk.writeXML(string + "\t", fileOutputStream);
                }
            }
        } else {
            byte[] byArray = this.rowBody.toByteArray();
            fileOutputStream.write((string + "\t<Data>\n").getBytes("UTF-8"));
            fileOutputStream.write((HexConverter.toHex(string + "\t", byArray) + "\n").getBytes("UTF-8"));
            fileOutputStream.write((string + "\t</Data>\n").getBytes("UTF-8"));
        }
        fileOutputStream.write((string + "</http.HttpBody>\n").getBytes("UTF-8"));
    }

    public void readXML(Node node) throws SyntaxErrorException {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        try {
            for (int i = 0; i < n; ++i) {
                Node node2 = nodeList.item(i);
                if (!node2.hasChildNodes()) continue;
                String string = node2.getNodeName();
                String string2 = node2.getFirstChild().getNodeValue();
                if (string.equals("LengthType")) {
                    this.lengthType = Integer.parseInt(string2);
                    continue;
                }
                if (string.equals("Length")) {
                    this.length = Integer.parseInt(string2);
                    continue;
                }
                if (this.lengthType == 0) {
                    int n2 = 0;
                    while (node2 != null) {
                        if (node2.getNodeType() == 1) {
                            HttpChunk httpChunk = new HttpChunk(n2, this);
                            httpChunk.readXML(node2);
                            this.addChunk(httpChunk);
                            ++n2;
                        }
                        node2 = node2.getNextSibling();
                    }
                    break;
                }
                if (string.equals("Data")) {
                    this.rowBody.write(HexConverter.toBinary(string2));
                    break;
                }
                debug.println(2, "Unknown key: {0}", (Object)string);
            }
        }
        catch (Exception exception) {
            debug.exception(1, (Throwable)exception);
            throw new SyntaxErrorException(exception.getMessage());
        }
    }

    public boolean complyWith(MsgFilterCriteria msgFilterCriteria) {
        Properties properties = msgFilterCriteria.getProperties();
        String string = properties.getProperty("body", "");
        return this.bodyContains(string.toLowerCase());
    }

    private void readBodyLength(InputStream inputStream) throws IOException, SyntaxErrorException {
        debug.println(2, "reading message body with length");
        byte[] byArray = new byte[this.length];
        int n = inputStream.read(byArray);
        int n2 = 0;
        while (n >= 0 && n2 < this.length) {
            this.rowBody.write(byArray, n2, n);
            if ((n2 += n) < this.length) {
                n = inputStream.read(byArray, n2, this.length - n2);
            }
            this.msg.fireMsgUpdateEvent(this, false);
        }
        if (n == -1) {
            throw new IOException("Unexpected connection close while parsing");
        }
    }

    private void readBodyConClose(InputStream inputStream) throws IOException, SyntaxErrorException {
        debug.println(2, "Reading message body until connection close");
        byte[] byArray = new byte[256];
        try {
            int n = inputStream.read(byArray);
            while (n >= 0) {
                this.rowBody.write(byArray, 0, n);
                n = inputStream.read(byArray);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void readChunks(InputStream inputStream, String string) throws IOException, SyntaxErrorException {
        debug.println(2, "Reading message body chunked");
        this.contentBody = new ByteArrayOutputStream();
        int n = 0;
        HttpChunk httpChunk = new HttpChunk(n++, this);
        httpChunk.read(inputStream, string);
        while (httpChunk.getDataSize() > 0) {
            this.addChunk(httpChunk);
            httpChunk = new HttpChunk(n++, this);
            httpChunk.read(inputStream, string);
        }
        this.addChunk(httpChunk);
    }

    private void addChunk(HttpChunk httpChunk) throws IOException {
        if (this.chunks == null) {
            this.chunks = new Vector();
        }
        this.chunks.addElement(httpChunk);
        this.add(httpChunk);
        this.msg.fireMsgUpdateEvent(httpChunk, true);
        this.contentBody.write(httpChunk.getDataBytes());
        this.rowBody.write(httpChunk.getBytes());
        this.msg.fireMsgUpdateEvent(this, false);
    }

    private void findContentLengthType() throws IOException, SyntaxErrorException {
        debug.println(2, "Checking content length type");
        String string = this.msg.getHeader().getHeader(CONTENT_LENGTH_KEY);
        String string2 = this.msg.getHeader().getHeader(TRANSFER_ENCODING_KEY);
        debug.println(2, "Content-Length: <" + string + ">");
        debug.println(2, "Transfer-Coding: <" + string2 + ">");
        if (!(string == null || string2 != null && string2.equalsIgnoreCase(CHUNK_TRANSFER_ENC))) {
            try {
                this.length = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SyntaxErrorException("invalid content-length. length = " + string);
            }
            this.lengthType = 1;
            return;
        }
        if (string2 != null && string2.equalsIgnoreCase(CHUNK_TRANSFER_ENC) && string == null) {
            this.length = -1;
            this.lengthType = 0;
            return;
        }
        if (string == null && (string2 == null || !string2.equalsIgnoreCase(CHUNK_TRANSFER_ENC)) && this.msg.getHeader().isResponse()) {
            this.length = -1;
            this.lengthType = 3;
            return;
        }
        if (string == null && (string2 == null || !string2.equalsIgnoreCase(CHUNK_TRANSFER_ENC)) && this.msg.getHeader().isRequest()) {
            this.length = -1;
            this.lengthType = 4;
            return;
        }
        throw new SyntaxErrorException("Content-Length with chunk encoding.");
    }

    private boolean bodyContains(String string) {
        String string2 = new String(this.getContentBytes());
        return string2.toLowerCase().indexOf(string) >= 0;
    }

    public DisplayableMsg getDisplayableMsg() {
        return this.msg;
    }

    public int getDirection() {
        return 2;
    }
}

