/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.netmon.gui.stream;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.netmon.MsgTreeNode;
import com.sun.kvem.netmon.gui.HexViewPanel;
import com.sun.kvem.netmon.gui.MsgTreeNodeViewer;
import com.sun.kvem.netmon.stream.StreamMessage;
import com.sun.kvem.util.PropWrapper;
import com.sun.kvem.util.ResourceLabel;
import com.sun.kvem.util.ToolkitResources;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public abstract class StreamMessageViewer
extends JPanel
implements MsgTreeNodeViewer {
    private static final Debug debug = Debug.create((Class)StreamMessageViewer.class);
    private JPanel top = new JPanel();
    private HexViewPanel inHexPanel = new HexViewPanel();
    private HexViewPanel outHexPanel = new HexViewPanel();
    private JLabel inSizeLabel = new JLabel();
    private JLabel outSizeLabel = new JLabel();
    private JTextArea propsArea = new JTextArea();
    protected StreamMessage msg;
    protected Properties props;

    public StreamMessageViewer() {
        this.top.setLayout(new BoxLayout(this.top, 1));
        this.propsArea.setEditable(false);
        this.propsArea.setBackground((Color)UIManager.get("Label.background"));
        this.propsArea.setForeground((Color)UIManager.get("Label.foreground"));
        this.propsArea.setFont((Font)UIManager.get("Label.font"));
        this.propsArea.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
        this.top.add(this.propsArea);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add((Component)new ResourceLabel("NETMON_IN"));
        jPanel.add(this.inHexPanel);
        jPanel.setMinimumSize(new Dimension(0, 100));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.add((Component)new ResourceLabel("NETMON_OUT"));
        jPanel2.add(this.outHexPanel);
        jPanel2.setMinimumSize(new Dimension(0, 100));
        JSplitPane jSplitPane = new JSplitPane(0, jPanel, jPanel2);
        jSplitPane.setMinimumSize(new Dimension(0, 200));
        jSplitPane.setDividerLocation(0.5);
        jSplitPane.setResizeWeight(0.5);
        this.setLayout(new BorderLayout());
        this.add((Component)this.top, "North");
        this.add((Component)jSplitPane, "Center");
    }

    public JComponent show(MsgTreeNode msgTreeNode) {
        this.msg = (StreamMessage)msgTreeNode;
        byte[] byArray = this.msg.getInBytes();
        this.inHexPanel.show(byArray);
        this.inSizeLabel.setText(ToolkitResources.getString((String)"NETMON_SIZE") + " " + byArray.length);
        byte[] byArray2 = this.msg.getOutBytes();
        this.outHexPanel.show(byArray2);
        this.outSizeLabel.setText(ToolkitResources.getString((String)"NETMON_SIZE") + " " + byArray2.length);
        StringBuffer stringBuffer = new StringBuffer();
        Properties properties = this.msg.getProperties();
        stringBuffer.append("URL:\t").append(this.msg.getType()).append(":").append(properties.getProperty("URL")).append("\n");
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.equals("URL")) continue;
            String string2 = ToolkitResources.getString((String)string);
            String string3 = properties.getProperty(string);
            stringBuffer.append(string2).append(":\t").append(string3).append("\n");
        }
        this.propsArea.setText(stringBuffer.toString());
        return this;
    }

    public void nodeUpdated() {
        byte[] byArray = this.msg.getInBytes();
        this.inHexPanel.update(byArray);
        this.inSizeLabel.setText(ToolkitResources.getString((String)"NETMON_SIZE") + " " + byArray.length);
        byte[] byArray2 = this.msg.getOutBytes();
        this.outHexPanel.update(byArray2);
        this.outSizeLabel.setText(ToolkitResources.getString((String)"NETMON_SIZE") + " " + byArray2.length);
    }

    public void setProperties(Properties properties) {
        this.props = properties;
        try {
            PropWrapper propWrapper = new PropWrapper(properties, "kvem.netmon.");
            String string = propWrapper.getStr("fixed_font_name", "Courier New");
            int n = propWrapper.getInt("fixed_font_size", 12);
            this.inHexPanel.setFixedFont(new Font(string, 0, n));
            this.outHexPanel.setFixedFont(new Font(string, 0, n));
        }
        catch (Exception exception) {
            debug.exception(2, (Throwable)exception);
        }
    }
}

