/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.netmon.gui.sms;

import com.sun.kvem.netmon.MsgTreeNode;
import com.sun.kvem.netmon.gui.HashTableModel;
import com.sun.kvem.netmon.gui.MsgTreeNodeViewer;
import com.sun.kvem.netmon.sms.SMSMessage;
import com.sun.kvem.util.ToolkitResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.text.SimpleDateFormat;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SMSMessageViewer
extends JPanel
implements MsgTreeNodeViewer {
    private SMSMessage msg;
    private HashTableModel tableModel = new HashTableModel(ToolkitResources.getString((String)"NETMON_KEYS"), ToolkitResources.getString((String)"NETMON_VALUES"));
    private JPanel top = new JPanel();
    private JPanel bottom = new JPanel();
    private JTable headerTable = new JTable(this.tableModel);
    private JScrollPane scrollPane = new JScrollPane(this.headerTable);
    private JLabel titleLabel = new JLabel();
    private JLabel dateLabel = new JLabel();
    private JTextArea bottomTextArea = new JTextArea();
    private JScrollPane bottomScrollPane = new JScrollPane(this.bottomTextArea);
    private Properties props;

    public SMSMessageViewer() {
        this.top.setPreferredSize(new Dimension(0, 40));
        this.top.setLayout(new BoxLayout(this.top, 1));
        this.top.add(this.titleLabel);
        this.top.add(this.dateLabel);
        this.bottom.setPreferredSize(new Dimension(0, 45));
        this.bottom.setLayout(new BorderLayout());
        this.bottom.add(Box.createRigidArea(new Dimension(0, 5)), "North");
        this.bottom.add((Component)this.bottomScrollPane, "Center");
        this.bottomTextArea.setEditable(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.top, "North");
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)this.bottom, "South");
        this.headerTable.setSelectionMode(0);
        ListSelectionModel listSelectionModel = this.headerTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (listSelectionModel.isSelectionEmpty()) {
                    SMSMessageViewer.this.bottomTextArea.setText("");
                } else {
                    int n = listSelectionModel.getMinSelectionIndex();
                    String string = (String)SMSMessageViewer.this.tableModel.getValueAt(n, 0);
                    String string2 = (String)SMSMessageViewer.this.tableModel.getValueAt(n, 1);
                    SMSMessageViewer.this.bottomTextArea.setText(string + ": " + string2);
                    SMSMessageViewer.this.bottomTextArea.setCaretPosition(0);
                }
            }
        });
    }

    public JComponent show(MsgTreeNode msgTreeNode) {
        this.msg = (SMSMessage)msgTreeNode;
        this.tableModel.setHash(this.msg.getHeader().getHashtable());
        this.titleLabel.setText(ToolkitResources.getString((String)"URL") + ": " + this.msg.getURL());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(ToolkitResources.getString((String)"NETMON_DATE_FORMAT"));
        String string = simpleDateFormat.format(this.msg.getStartDate());
        this.dateLabel.setText(ToolkitResources.getString((String)"TIME") + ": " + string);
        return this;
    }

    public void nodeUpdated() {
        this.show(this.msg);
    }

    public void setProperties(Properties properties) {
        this.props = properties;
    }
}

