/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.netmon.gui.sms;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.netmon.MsgTreeNode;
import com.sun.kvem.netmon.gui.HexViewPanel;
import com.sun.kvem.netmon.gui.MsgTreeNodeViewer;
import com.sun.kvem.netmon.sms.SMSFragment;
import com.sun.kvem.util.PropWrapper;
import com.sun.kvem.util.ToolkitResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class SMSFragmentViewer
extends JPanel
implements MsgTreeNodeViewer {
    private static final Debug debug = Debug.create((Class)SMSFragmentViewer.class);
    private JPanel top = new JPanel();
    private JLabel sizeLabel = new JLabel();
    private JLabel urlLabel = new JLabel();
    private JPanel middle = new JPanel();
    private JTextArea textArea = new JTextArea();
    private JScrollPane scrollPane = new JScrollPane(this.textArea);
    private Component rigidArea = Box.createRigidArea(new Dimension(0, 5));
    private HexViewPanel hexPanel = new HexViewPanel();
    private SMSFragment fragment;
    private Properties props;

    public SMSFragmentViewer() {
        this.top.setPreferredSize(new Dimension(0, 40));
        this.top.setLayout(new BoxLayout(this.top, 1));
        this.top.add(this.urlLabel);
        this.top.add(this.sizeLabel);
        this.middle.setLayout(new BoxLayout(this.middle, 1));
        this.middle.add(Box.createRigidArea(new Dimension(0, 5)));
        this.middle.add(this.scrollPane);
        this.middle.add(this.rigidArea);
        this.middle.add(this.hexPanel);
        this.textArea.setEditable(false);
        this.scrollPane.setPreferredSize(new Dimension(Integer.MAX_VALUE, 130));
        this.setLayout(new BorderLayout());
        this.add((Component)this.middle, "Center");
        this.add((Component)this.top, "North");
    }

    public JComponent show(MsgTreeNode msgTreeNode) {
        this.fragment = (SMSFragment)msgTreeNode;
        this.middle.removeAll();
        if (this.fragment.getBody().getMessage().isText()) {
            this.middle.add(Box.createRigidArea(new Dimension(0, 5)));
            this.middle.add(this.scrollPane);
            this.middle.add(this.rigidArea);
            this.middle.add(this.hexPanel);
            this.textArea.setText(this.fragment.toString());
            this.textArea.setCaretPosition(0);
        } else {
            this.middle.add(this.rigidArea);
            this.middle.add(this.hexPanel);
        }
        this.hexPanel.show(this.fragment.getDataBytes());
        this.sizeLabel.setText(ToolkitResources.getString((String)"NETMON_SIZE") + " " + this.fragment.getDataSize());
        this.urlLabel.setText(ToolkitResources.getString((String)"URL") + ": " + this.fragment.getURL());
        return this;
    }

    public void nodeUpdated() {
        if (this.fragment.getBody().getMessage().isText()) {
            this.textArea.setText(this.fragment.toString());
            this.textArea.setCaretPosition(0);
        }
        byte[] byArray = this.fragment.getDataBytes();
        this.hexPanel.update(byArray);
        this.sizeLabel.setText(ToolkitResources.getString((String)"NETMON_SIZE") + " " + byArray.length);
    }

    public void setProperties(Properties properties) {
        this.props = properties;
        try {
            PropWrapper propWrapper = new PropWrapper(properties, "kvem.netmon.");
            String string = propWrapper.getStr("fixed_font_name", "Courier New");
            int n = propWrapper.getInt("fixed_font_size", 12);
            this.hexPanel.setFixedFont(new Font(string, 0, n));
        }
        catch (Exception exception) {
            debug.exception(2, (Throwable)exception);
        }
    }
}

