/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.netmon.gui.sms;

import com.sun.kvem.netmon.MsgFilterCriteria;
import com.sun.kvem.netmon.util.Filter;
import com.sun.kvem.netmon.util.GenericMsgFilter;
import com.sun.kvem.util.ToolkitResources;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public class MsgFilterDialog
extends com.sun.kvem.netmon.gui.MsgFilterDialog {
    JComboBox protocolField = new JComboBox<String>(new String[]{ToolkitResources.getString((String)"NETMON_ALL"), ToolkitResources.getString((String)"WMA_CONSOLE.SMS"), ToolkitResources.getString((String)"WMA_CONSOLE.CBS")});
    JComboBox typeField = new JComboBox<String>(new String[]{ToolkitResources.getString((String)"NETMON_ALL"), ToolkitResources.getString((String)"WMA_CONSOLE.TEXT"), ToolkitResources.getString((String)"WMA_CONSOLE.BINARY")});
    JComboBox directionField = new JComboBox<String>(new String[]{ToolkitResources.getString((String)"NETMON_ALL"), ToolkitResources.getString((String)"NETMON_IN"), ToolkitResources.getString((String)"NETMON_OUT")});
    JTextField fromField = new JTextField();
    JTextField toField = new JTextField();
    JTextField contentField = new JTextField();

    public MsgFilterDialog() {
        this.content.setLayout(new BoxLayout(this.content, 1));
        this.addToContent(ToolkitResources.getString((String)"NETMON_PROTOCOL") + ":", this.protocolField);
        this.addToContent(ToolkitResources.getString((String)"TYPE") + ":", this.typeField);
        this.addToContent(ToolkitResources.getString((String)"NETMON_DIRECTION") + ":", this.directionField);
        this.addToContent(ToolkitResources.getString((String)"WMA_CONSOLE.FROM") + ":", this.fromField);
        this.addToContent(ToolkitResources.getString((String)"WMA_CONSOLE.TO") + ":", this.toField);
        this.addToContent(ToolkitResources.getString((String)"NETMON_CONTENT") + ":", this.contentField);
        this.typeField.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
                MsgFilterDialog.this.contentField.setEditable(jComboBox.getSelectedIndex() != 2);
            }
        });
        this.content.add(Box.createRigidArea(new Dimension(0, 5)));
        this.content.add(this.createButtonsPanel());
        this.content.add(Box.createRigidArea(new Dimension(0, 5)));
        this.content.setPreferredSize(new Dimension(300, (int)this.content.getPreferredSize().getHeight()));
        this.setContentPane(this.content);
        this.pack();
        this.setResizable(false);
    }

    public void setFilter(Filter filter) {
        if (filter instanceof GenericMsgFilter) {
            GenericMsgFilter genericMsgFilter = (GenericMsgFilter)filter;
            MsgFilterCriteria msgFilterCriteria = genericMsgFilter.getCriteria();
            Properties properties = msgFilterCriteria.getProperties();
            this.protocolField.setSelectedIndex(Integer.parseInt(properties.getProperty("protocol", "0")));
            this.typeField.setSelectedIndex(Integer.parseInt(properties.getProperty("type", "0")));
            this.directionField.setSelectedIndex(Integer.parseInt(properties.getProperty("direction", "0")));
            this.fromField.setText(properties.getProperty("from", ""));
            this.toField.setText(properties.getProperty("to", ""));
            this.contentField.setText(properties.getProperty("content", ""));
        }
    }

    protected void reset() {
        this.directionField.setSelectedIndex(0);
        this.protocolField.setSelectedIndex(0);
        this.typeField.setSelectedIndex(0);
        this.fromField.setText("");
        this.toField.setText("");
        this.contentField.setText("");
    }

    protected void createFilter() {
        Properties properties = new Properties();
        properties.setProperty("direction", Integer.toString(this.directionField.getSelectedIndex()));
        properties.setProperty("protocol", Integer.toString(this.protocolField.getSelectedIndex()));
        properties.setProperty("type", Integer.toString(this.typeField.getSelectedIndex()));
        properties.setProperty("from", this.fromField.getText());
        properties.setProperty("to", this.toField.getText());
        properties.setProperty("content", this.contentField.getText());
        MsgFilterCriteria msgFilterCriteria = new MsgFilterCriteria(properties);
        this.filter = new GenericMsgFilter(msgFilterCriteria);
    }
}

