/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.netmon.gui.obex;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.netmon.MsgTreeNode;
import com.sun.kvem.netmon.gui.HexViewPanel;
import com.sun.kvem.netmon.gui.HorizontalScroller;
import com.sun.kvem.netmon.gui.MsgTreeNodeViewer;
import com.sun.kvem.netmon.gui.obex.ObexHeadersTable;
import com.sun.kvem.netmon.obex.ObexHeader;
import com.sun.kvem.netmon.obex.ObexPacket;
import com.sun.kvem.util.PropWrapper;
import com.sun.kvem.util.ResourceLabel;
import com.sun.kvem.util.ToolkitResources;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;

public final class ObexPacketViewer
extends JPanel
implements MsgTreeNodeViewer {
    private static final Debug debug = Debug.create((Class)ObexPacketViewer.class);
    protected Properties props;
    private JLabel title;
    private JLabel headLabel;
    private ObexHeadersTable headers;
    private JLabel dataLabel;
    private JPanel extraInfo;
    private HexViewPanel dataHexPanel = new HexViewPanel();
    private ObexPacket prevPacket;
    private Vector components;
    private HorizontalScroller top = new HorizontalScroller(this);
    private JComponent headersTableHeader;

    public ObexPacketViewer() {
        this.title = new JLabel("   ");
        this.headLabel = new ResourceLabel("NETMON_OBEX_HEADERS");
        this.headers = new ObexHeadersTable();
        this.headersTableHeader = this.headers.getTableHeader();
        this.setLayout(new BoxLayout(this, 1));
        this.dataLabel = new JLabel("   ");
        this.title.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.title.getPreferredSize().height));
        this.title.setAlignmentX(0.5f);
        this.headLabel.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.headLabel.getPreferredSize().height));
        this.headLabel.setAlignmentX(0.5f);
        this.dataLabel.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.dataLabel.getPreferredSize().height));
        this.dataLabel.setAlignmentX(0.5f);
        this.extraInfo = new JPanel();
        this.extraInfo.setLayout(new BoxLayout(this.extraInfo, 1));
        this.extraInfo.setBorder(null);
        this.dataHexPanel = new HexViewPanel();
        this.add(this.title);
        this.add(this.headLabel);
        this.add(this.headersTableHeader);
        this.add(this.headers);
        this.add(this.extraInfo);
        this.add(this.dataLabel);
        this.add(this.dataHexPanel);
    }

    public JComponent show(MsgTreeNode msgTreeNode) {
        ObexPacket obexPacket = (ObexPacket)msgTreeNode;
        if (obexPacket != this.prevPacket) {
            if (!obexPacket.isBad()) {
                this.title.setText(ToolkitResources.format((String)"NETMON_OBEX_PACKET_TITLE", (Object[])new Object[]{obexPacket.getTitle(), obexPacket.getFinalBit() ? "Final, " : "", Integer.toString(obexPacket.getLength())}));
                Vector vector = obexPacket.getHeaders();
                if (vector.size() > 0) {
                    this.headLabel.setText("NETMON_OBEX_HEADERS");
                    this.headersTableHeader.setVisible(true);
                    this.headers.setHeaders(vector);
                    this.headers.setVisible(true);
                } else {
                    this.headLabel.setText("NETMON_OBEX_NO_HEADERS");
                    this.headersTableHeader.setVisible(false);
                    this.headers.setVisible(false);
                }
                this.extraInfo.removeAll();
                for (int i = 0; i < vector.size(); ++i) {
                    ObexHeader obexHeader = (ObexHeader)vector.elementAt(i);
                    JTable jTable = obexHeader.getComponent();
                    if (jTable == null) continue;
                    String string = obexHeader.getLabelName();
                    JLabel jLabel = new JLabel(string);
                    jLabel.setMaximumSize(new Dimension(Integer.MAX_VALUE, jLabel.getPreferredSize().height));
                    jLabel.setAlignmentX(0.5f);
                    this.extraInfo.add(jLabel);
                    this.extraInfo.add(jTable.getTableHeader());
                    this.extraInfo.add(jTable);
                }
                byte[] byArray = obexPacket.getBody();
                if (byArray == null) {
                    this.dataHexPanel.setVisible(false);
                    this.dataLabel.setVisible(false);
                } else {
                    this.dataHexPanel.setVisible(true);
                    this.dataLabel.setVisible(true);
                    this.dataLabel.setText(ToolkitResources.format((String)"NETMON_OBEX_DATA_SECTION", (Object)Integer.toString(byArray.length)));
                    this.dataHexPanel.show(byArray);
                }
            } else {
                this.title.setText(ToolkitResources.format((String)"NETMON_OBEX_PACKET_CORRUPTED", (Object[])new Object[]{obexPacket.getTitle(), obexPacket.getFinalBit() ? "Final, " : "", Integer.toString(obexPacket.getLength())}));
                this.headLabel.setText("NETMON_OBEX_RAW_PACKET");
                this.headersTableHeader.setVisible(false);
                this.headers.setVisible(false);
                this.extraInfo.removeAll();
                this.dataLabel.setVisible(false);
                this.dataHexPanel.setVisible(true);
                this.dataHexPanel.show(obexPacket.getData());
            }
        }
        this.prevPacket = obexPacket;
        return this.top;
    }

    public void nodeUpdated() {
    }

    public void setProperties(Properties properties) {
        this.props = properties;
        try {
            PropWrapper propWrapper = new PropWrapper(properties, "kvem.netmon.");
            String string = propWrapper.getStr("fixed_font_name", "Courier New");
            String string2 = propWrapper.getStr("variable_font_name", "Arial");
            int n = propWrapper.getInt("fixed_font_size", 12);
            int n2 = propWrapper.getInt("variable_font_size", 14);
            this.title.setFont(new Font(string2, 1, n2 + 1));
            this.dataHexPanel.setFixedFont(new Font(string, 0, n));
        }
        catch (Exception exception) {
            debug.exception(2, (Throwable)exception);
        }
    }
}

