/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.netmon.gui.obex;

import com.sun.kvem.netmon.obex.ObexOperation;
import com.sun.kvem.util.ToolkitResources;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;

final class ObexOperationsTable
extends JTable {
    Vector operations;

    ObexOperationsTable() {
        this.setModel(new HeadersTableModel());
        TableColumnModel tableColumnModel = this.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(80);
        tableColumnModel.getColumn(1).setPreferredWidth(400);
        tableColumnModel.getColumn(2).setPreferredWidth(600);
        tableColumnModel.getColumn(3).setPreferredWidth(300);
    }

    void setOperations(Vector vector) {
        this.operations = vector;
    }

    class HeadersTableModel
    extends AbstractTableModel {
        private final String[] columnNames = new String[]{"NETMON_TABLEHEADER_INDEX", "NETMON_OBEX_OPERATION", "NETMON_OBEX_RESULT", "NETMON_OBEX_DATA"};

        HeadersTableModel() {
        }

        public String getColumnName(int n) {
            return ToolkitResources.getString((String)this.columnNames[n]);
        }

        public int getRowCount() {
            if (ObexOperationsTable.this.operations == null) {
                return 0;
            }
            return ObexOperationsTable.this.operations.size();
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public Object getValueAt(int n, int n2) {
            ObexOperation obexOperation = (ObexOperation)ObexOperationsTable.this.operations.elementAt(n);
            switch (n2) {
                case 0: {
                    return new Integer(n + 1);
                }
                case 1: {
                    return obexOperation.getOperationType();
                }
                case 2: {
                    return obexOperation.getOperationResult();
                }
                case 3: {
                    return ToolkitResources.format((String)"NETMON_DATALENGTH", (int)obexOperation.getDataLength());
                }
            }
            return null;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public void setValueAt(Object object, int n, int n2) {
        }
    }
}

