/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.netmon.gui.obex;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.netmon.MsgTreeNode;
import com.sun.kvem.netmon.gui.HorizontalScroller;
import com.sun.kvem.netmon.gui.MsgTreeNodeViewer;
import com.sun.kvem.netmon.gui.obex.ObexHeadersTable;
import com.sun.kvem.netmon.obex.ObexOperation;
import com.sun.kvem.util.PropWrapper;
import com.sun.kvem.util.ResourceLabel;
import com.sun.kvem.util.ToolkitResources;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ObexOperationViewer
extends JPanel
implements MsgTreeNodeViewer {
    private static final Debug debug = Debug.create((Class)ObexOperationViewer.class);
    protected Properties props;
    private JLabel title;
    private JLabel sentHeadLabel;
    private JLabel recvHeadLabel;
    private ObexHeadersTable sentHeaders;
    private ObexHeadersTable recvHeaders;
    private ObexOperation prevOperation;
    private Vector components;
    private HorizontalScroller top = new HorizontalScroller(this);

    public ObexOperationViewer() {
        this.title = new JLabel("   ");
        this.recvHeadLabel = new ResourceLabel("NETMON_OBEX_RECEIVED_HEADERS");
        this.sentHeadLabel = new ResourceLabel("NETMON_OBEX_SENT_HEADERS");
        this.sentHeaders = new ObexHeadersTable();
        this.recvHeaders = new ObexHeadersTable();
        this.setLayout(new BoxLayout(this, 1));
        this.title.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.title.getPreferredSize().height));
        this.title.setAlignmentX(0.5f);
        this.recvHeadLabel.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.recvHeadLabel.getPreferredSize().height));
        this.recvHeadLabel.setAlignmentX(0.5f);
        this.sentHeadLabel.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.sentHeadLabel.getPreferredSize().height));
        this.sentHeadLabel.setAlignmentX(0.5f);
        this.add(this.title);
        this.add(this.sentHeadLabel);
        this.add(this.sentHeaders.getTableHeader());
        this.add(this.sentHeaders);
        this.add(this.recvHeadLabel);
        this.add(this.recvHeaders.getTableHeader());
        this.add(this.recvHeaders);
    }

    public JComponent show(MsgTreeNode msgTreeNode) {
        ObexOperation obexOperation = (ObexOperation)msgTreeNode;
        if (obexOperation != this.prevOperation) {
            this.title.setText(ToolkitResources.format((String)"NETMON_OBEX_OPERATION_TITLE", (Object)obexOperation.getTitle()));
            this.sentHeaders.setHeaders(obexOperation.getSentHeaders());
            this.recvHeaders.setHeaders(obexOperation.getRecvHeaders());
        }
        this.prevOperation = obexOperation;
        return this.top;
    }

    public void nodeUpdated() {
        this.sentHeaders.revalidate();
        this.recvHeaders.revalidate();
    }

    public void setProperties(Properties properties) {
        this.props = properties;
        try {
            PropWrapper propWrapper = new PropWrapper(properties, "kvem.netmon.");
            String string = propWrapper.getStr("fixed_font_name", "Courier New");
            String string2 = propWrapper.getStr("variable_font_name", "Arial");
            int n = propWrapper.getInt("fixed_font_size", 12);
            int n2 = propWrapper.getInt("variable_font_size", 14);
            this.title.setFont(new Font(string2, 1, n2 + 1));
        }
        catch (Exception exception) {
            debug.exception(2, (Throwable)exception);
        }
    }
}

