/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.netmon.gui.obex;

import com.sun.kvem.netmon.obex.ObexHeader;
import com.sun.kvem.util.ToolkitResources;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;

final class ObexHeadersTable
extends JTable {
    Vector headers;

    ObexHeadersTable() {
        this.setModel(new HeadersTableModel());
        TableColumnModel tableColumnModel = this.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(80);
        tableColumnModel.getColumn(1).setPreferredWidth(400);
        tableColumnModel.getColumn(2).setPreferredWidth(600);
        tableColumnModel.getColumn(3).setPreferredWidth(300);
    }

    void setHeaders(Vector vector) {
        this.headers = vector;
    }

    class HeadersTableModel
    extends AbstractTableModel {
        private final String[] columnNames = new String[]{"NETMON_TABLEHEADER_INDEX", "NETMON_OBEX_NAME", "NETMON_OBEX_VALUE", "NETMON_OBEX_SIZE"};

        HeadersTableModel() {
        }

        public String getColumnName(int n) {
            return ToolkitResources.getString((String)this.columnNames[n]);
        }

        public int getRowCount() {
            if (ObexHeadersTable.this.headers == null) {
                return 0;
            }
            return ObexHeadersTable.this.headers.size();
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public Object getValueAt(int n, int n2) {
            ObexHeader obexHeader = (ObexHeader)ObexHeadersTable.this.headers.elementAt(n);
            switch (n2) {
                case 0: {
                    return new Integer(n + 1);
                }
                case 1: {
                    return obexHeader.getName();
                }
                case 2: {
                    return obexHeader.getValue();
                }
                case 3: {
                    return ToolkitResources.format((String)"NETMON_DATALENGTH", (int)obexHeader.getLength());
                }
            }
            return null;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public void setValueAt(Object object, int n, int n2) {
        }
    }
}

