/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.netmon.gui.obex;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.netmon.MsgTreeNode;
import com.sun.kvem.netmon.gui.HorizontalScroller;
import com.sun.kvem.netmon.gui.MsgTreeNodeViewer;
import com.sun.kvem.netmon.gui.obex.ObexOperationsTable;
import com.sun.kvem.netmon.obex.ObexConnection;
import com.sun.kvem.util.PropWrapper;
import com.sun.kvem.util.ResourceLabel;
import com.sun.kvem.util.ToolkitResources;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public final class ObexConnectionViewer
extends JPanel
implements MsgTreeNodeViewer {
    private static final Debug debug = Debug.create((Class)ObexConnectionViewer.class);
    protected Properties props;
    private JLabel title;
    private JLabel operationsLabel;
    private ObexOperationsTable operations;
    private ObexConnection prevConnection;
    private Vector components;
    private HorizontalScroller top = new HorizontalScroller(this);

    public ObexConnectionViewer() {
        this.title = new JLabel("   ");
        this.operationsLabel = new ResourceLabel("NETMON_OBEX_OPERATIONS");
        this.operations = new ObexOperationsTable();
        this.setLayout(new BoxLayout(this, 1));
        this.title.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.title.getPreferredSize().height));
        this.title.setAlignmentX(0.5f);
        this.operationsLabel.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.operationsLabel.getPreferredSize().height));
        this.operationsLabel.setAlignmentX(0.5f);
        this.add(this.title);
        this.add(this.operationsLabel);
        this.add(this.operations.getTableHeader());
        this.add(this.operations);
    }

    public JComponent show(MsgTreeNode msgTreeNode) {
        ObexConnection obexConnection = (ObexConnection)msgTreeNode;
        if (obexConnection != this.prevConnection) {
            this.title.setText(ToolkitResources.format((String)"NETMON_OBEX_CONNECTION_TITLE", (Object)obexConnection.getTitle()));
            this.operations.setOperations(obexConnection.getOperations());
        }
        this.prevConnection = obexConnection;
        return this.top;
    }

    public void nodeUpdated() {
        this.operations.revalidate();
    }

    public void setProperties(Properties properties) {
        this.props = properties;
        try {
            PropWrapper propWrapper = new PropWrapper(properties, "kvem.netmon.");
            String string = propWrapper.getStr("fixed_font_name", "Courier New");
            String string2 = propWrapper.getStr("variable_font_name", "Arial");
            int n = propWrapper.getInt("fixed_font_size", 12);
            int n2 = propWrapper.getInt("variable_font_size", 14);
            this.title.setFont(new Font(string2, 1, n2 + 1));
        }
        catch (Exception exception) {
            debug.exception(2, (Throwable)exception);
        }
    }
}

