/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.netmon.gui.mms;

import com.sun.kvem.netmon.MsgFilterCriteria;
import com.sun.kvem.netmon.util.Filter;
import com.sun.kvem.netmon.util.GenericMsgFilter;
import com.sun.kvem.util.ToolkitResources;
import java.awt.Dimension;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public class MsgFilterDialog
extends com.sun.kvem.netmon.gui.MsgFilterDialog {
    JComboBox directionField = new JComboBox<String>(new String[]{ToolkitResources.getString((String)"NETMON_ALL"), ToolkitResources.getString((String)"NETMON_IN"), ToolkitResources.getString((String)"NETMON_OUT")});
    JTextField fromField = new JTextField();
    JTextField toField = new JTextField();
    JTextField ccField = new JTextField();
    JTextField bccField = new JTextField();
    JTextField subjectField = new JTextField();
    JTextField contentIDField = new JTextField();
    JTextField contentLocationField = new JTextField();
    JTextField mimeTypeField = new JTextField();
    JTextField encodingField = new JTextField();

    public MsgFilterDialog() {
        this.content.setLayout(new BoxLayout(this.content, 1));
        this.addToContent(ToolkitResources.getString((String)"NETMON_DIRECTION") + ":", this.directionField);
        this.addToContent(ToolkitResources.getString((String)"WMA_CONSOLE.FROM") + ":", this.fromField);
        this.addToContent(ToolkitResources.getString((String)"WMA_CONSOLE.TO") + ":", this.toField);
        this.addToContent(ToolkitResources.getString((String)"WMA_CONSOLE.CC") + ":", this.ccField);
        this.addToContent(ToolkitResources.getString((String)"WMA_CONSOLE.BCC") + ":", this.bccField);
        this.addToContent(ToolkitResources.getString((String)"WMA_CONSOLE.SUBJECT") + ":", this.subjectField);
        this.addToContent(ToolkitResources.getString((String)"WMA_CONSOLE.CONTENT_ID") + ":", this.contentIDField);
        this.addToContent(ToolkitResources.getString((String)"WMA_CONSOLE.CONTENT_LOC") + ":", this.contentLocationField);
        this.addToContent(ToolkitResources.getString((String)"WMA_CONSOLE.MIME_TYPE") + ":", this.mimeTypeField);
        this.addToContent(ToolkitResources.getString((String)"WMA_CONSOLE.ENCODING") + ":", this.encodingField);
        this.content.add(Box.createRigidArea(new Dimension(0, 5)));
        this.content.add(this.createButtonsPanel());
        this.content.add(Box.createRigidArea(new Dimension(0, 5)));
        this.content.setPreferredSize(new Dimension(300, (int)this.content.getPreferredSize().getHeight()));
        this.setContentPane(this.content);
        this.pack();
        this.setResizable(false);
    }

    public void setFilter(Filter filter) {
        if (filter instanceof GenericMsgFilter) {
            GenericMsgFilter genericMsgFilter = (GenericMsgFilter)filter;
            MsgFilterCriteria msgFilterCriteria = genericMsgFilter.getCriteria();
            Properties properties = msgFilterCriteria.getProperties();
            this.directionField.setSelectedIndex(Integer.parseInt(properties.getProperty("direction", "0")));
            this.fromField.setText(properties.getProperty("from", ""));
            this.toField.setText(properties.getProperty("to", ""));
            this.ccField.setText(properties.getProperty("cc", ""));
            this.bccField.setText(properties.getProperty("bcc", ""));
            this.subjectField.setText(properties.getProperty("subject", ""));
            this.contentIDField.setText(properties.getProperty("contentID", ""));
            this.contentLocationField.setText(properties.getProperty("contentLocation", ""));
            this.mimeTypeField.setText(properties.getProperty("mimeType", ""));
            this.encodingField.setText(properties.getProperty("encoding", ""));
        }
    }

    protected void reset() {
        this.directionField.setSelectedIndex(0);
        this.fromField.setText("");
        this.toField.setText("");
        this.ccField.setText("");
        this.bccField.setText("");
        this.subjectField.setText("");
        this.contentIDField.setText("");
        this.contentLocationField.setText("");
        this.mimeTypeField.setText("");
        this.encodingField.setText("");
    }

    protected void createFilter() {
        Properties properties = new Properties();
        properties.setProperty("direction", Integer.toString(this.directionField.getSelectedIndex()));
        properties.setProperty("from", this.fromField.getText());
        properties.setProperty("to", this.toField.getText());
        properties.setProperty("cc", this.ccField.getText());
        properties.setProperty("bcc", this.bccField.getText());
        properties.setProperty("subject", this.subjectField.getText());
        properties.setProperty("contentID", this.contentIDField.getText());
        properties.setProperty("contentLocation", this.contentLocationField.getText());
        properties.setProperty("mimeType", this.mimeTypeField.getText());
        properties.setProperty("encoding", this.encodingField.getText());
        MsgFilterCriteria msgFilterCriteria = new MsgFilterCriteria(properties);
        this.filter = new GenericMsgFilter(msgFilterCriteria);
    }
}

