/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.netmon.gui.mms;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.netmon.MsgTreeNode;
import com.sun.kvem.netmon.gui.MsgTreeNodeViewer;
import com.sun.kvem.netmon.mms.MMSHeader;
import com.sun.kvem.netmon.mms.MMSMessage;
import com.sun.kvem.util.ToolkitResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class MMSMessageViewer
extends JPanel
implements MsgTreeNodeViewer {
    private static final Debug debug = Debug.create((Class)MMSMessageViewer.class);
    private MMSMessage msg;
    private JPanel top = new JPanel();
    private JPanel bottom = new JPanel();
    private JTable headerTable = new JTable();
    private DefaultTableModel tableModel = (DefaultTableModel)this.headerTable.getModel();
    private JScrollPane scrollPane = new JScrollPane(this.headerTable);
    private JLabel titleLabel = new JLabel();
    private JLabel dateLabel = new JLabel();
    private JTextArea bottomTextArea = new JTextArea();
    private JScrollPane bottomScrollPane = new JScrollPane(this.bottomTextArea);
    private Properties props;
    private static SimpleDateFormat dateFormatter = new SimpleDateFormat(ToolkitResources.getString((String)"NETMON_DATE_FORMAT"));

    public MMSMessageViewer() {
        this.top.setPreferredSize(new Dimension(0, 40));
        this.top.setLayout(new BoxLayout(this.top, 1));
        this.top.add(this.titleLabel);
        this.top.add(this.dateLabel);
        this.bottom.setPreferredSize(new Dimension(0, 45));
        this.bottom.setLayout(new BorderLayout());
        this.bottom.add(Box.createRigidArea(new Dimension(0, 5)), "North");
        this.bottom.add((Component)this.bottomScrollPane, "Center");
        this.bottomTextArea.setEditable(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.top, "North");
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)this.bottom, "South");
        this.headerTable.setSelectionMode(0);
        ListSelectionModel listSelectionModel = this.headerTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (listSelectionModel.isSelectionEmpty()) {
                    MMSMessageViewer.this.bottomTextArea.setText("");
                } else {
                    int n = listSelectionModel.getMinSelectionIndex();
                    String string = (String)MMSMessageViewer.this.tableModel.getValueAt(n, 0);
                    String string2 = (String)MMSMessageViewer.this.tableModel.getValueAt(n, 1);
                    MMSMessageViewer.this.bottomTextArea.setText(string + ": " + string2);
                    MMSMessageViewer.this.bottomTextArea.setCaretPosition(0);
                }
            }
        });
        this.tableModel.setColumnCount(2);
        this.tableModel.setColumnIdentifiers(new Object[]{ToolkitResources.getString((String)"NETMON_KEYS"), ToolkitResources.getString((String)"NETMON_VALUES")});
    }

    public JComponent show(MsgTreeNode msgTreeNode) {
        String string;
        long l;
        String string2;
        String string3;
        Object object;
        this.msg = (MMSMessage)msgTreeNode;
        MMSHeader mMSHeader = this.msg.getHeader();
        this.titleLabel.setText(ToolkitResources.getString((String)"URL") + ": " + this.msg.getURL());
        String string4 = dateFormatter.format(this.msg.getStartDate());
        this.dateLabel.setText(ToolkitResources.getString((String)"TIME") + ": " + string4);
        while (this.tableModel.getRowCount() > 0) {
            this.tableModel.removeRow(0);
        }
        this.tableModel.addRow(new Object[]{"X-Mms-Message-Type", mMSHeader.getMessageType()});
        this.tableModel.addRow(new Object[]{"X-Mms-Transaction-ID", mMSHeader.getTransactionID()});
        this.tableModel.addRow(new Object[]{"X-Mms-MMS-Version", mMSHeader.getMMSVersion()});
        String string5 = mMSHeader.getDeliveryDate();
        if (string5 != null) {
            try {
                object = new Date(Long.parseLong(string5));
                this.tableModel.addRow(new Object[]{"X-Mms-Delivery-Time", dateFormatter.format((Date)object)});
            }
            catch (NumberFormatException numberFormatException) {
                debug.exception(3, (Throwable)numberFormatException);
            }
        }
        if ((object = mMSHeader.getPriority()) != null) {
            this.tableModel.addRow(new Object[]{"X-Mms-Priority", object});
        }
        this.tableModel.addRow(new Object[]{"From", mMSHeader.getFrom()});
        String string6 = mMSHeader.getTo();
        if (string6 != null) {
            this.tableModel.addRow(new Object[]{"To", string6});
        }
        if ((string3 = mMSHeader.getCC()) != null) {
            this.tableModel.addRow(new Object[]{"Cc", string3});
        }
        if ((string2 = mMSHeader.getBCC()) != null) {
            this.tableModel.addRow(new Object[]{"Bcc", string2});
        }
        if ((l = mMSHeader.getSendTime()) != 0L) {
            this.tableModel.addRow(new Object[]{"Date", dateFormatter.format(new Date(l))});
        }
        if ((string = mMSHeader.getSubject()) != null) {
            this.tableModel.addRow(new Object[]{"Subject", string});
        }
        this.tableModel.addRow(new Object[]{"Content-Type", mMSHeader.getContentType()});
        this.headerTable.setDefaultEditor(this.headerTable.getColumnClass(0), null);
        this.headerTable.setDefaultEditor(this.headerTable.getColumnClass(1), null);
        return this;
    }

    public void nodeUpdated() {
        this.show(this.msg);
    }

    public void setProperties(Properties properties) {
        this.props = properties;
    }
}

