/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.netmon.gui.http;

import com.sun.kvem.netmon.MsgFilterCriteria;
import com.sun.kvem.netmon.util.Filter;
import com.sun.kvem.netmon.util.GenericMsgFilter;
import com.sun.kvem.util.ResourceLabel;
import com.sun.kvem.util.TableLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JTextField;

public class MsgFilterDialog
extends com.sun.kvem.netmon.gui.MsgFilterDialog {
    JTextField urlField = new JTextField(20);
    JTextField statusLineField = new JTextField();
    JTextField headerField = new JTextField();
    JTextField bodyField = new JTextField();

    public MsgFilterDialog() {
        this.content.setLayout(new BoxLayout(this.content, 1));
        Container container = new Container();
        TableLayout tableLayout = new TableLayout(2);
        tableLayout.setColumnWidth(0, 0);
        tableLayout.setColumnWidth(1, 1);
        tableLayout.setInsets(new Insets(0, 5, 0, 5));
        container.setLayout((LayoutManager)tableLayout);
        container.add((Component)new ResourceLabel("URL"));
        container.add(this.urlField);
        container.add((Component)new ResourceLabel("NETMON_STATUS_LINE"));
        container.add(this.statusLineField);
        container.add((Component)new ResourceLabel("NETMON_HEADER_TEXT"));
        container.add(this.headerField);
        container.add((Component)new ResourceLabel("NETMON_BODY_TEXT"));
        container.add(this.bodyField);
        this.content.add(container);
        this.content.add(Box.createRigidArea(new Dimension(0, 5)));
        this.content.add(this.createButtonsPanel());
        this.content.add(Box.createRigidArea(new Dimension(0, 5)));
        this.setContentPane(this.content);
        this.pack();
        this.setResizable(false);
    }

    public void setFilter(Filter filter) {
        if (filter instanceof GenericMsgFilter) {
            GenericMsgFilter genericMsgFilter = (GenericMsgFilter)filter;
            MsgFilterCriteria msgFilterCriteria = genericMsgFilter.getCriteria();
            Properties properties = msgFilterCriteria.getProperties();
            this.urlField.setText(properties.getProperty("URL", ""));
            this.statusLineField.setText(properties.getProperty("statusLine", ""));
            this.headerField.setText(properties.getProperty("header", ""));
            this.bodyField.setText(properties.getProperty("body", ""));
        }
    }

    protected void reset() {
        this.urlField.setText("");
        this.statusLineField.setText("");
        this.headerField.setText("");
        this.bodyField.setText("");
    }

    protected void createFilter() {
        Properties properties = new Properties();
        properties.setProperty("URL", this.urlField.getText());
        properties.setProperty("statusLineField", this.statusLineField.getText());
        properties.setProperty("header", this.headerField.getText());
        properties.setProperty("body", this.bodyField.getText());
        MsgFilterCriteria msgFilterCriteria = new MsgFilterCriteria(properties);
        this.filter = new GenericMsgFilter(msgFilterCriteria);
    }
}

