/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.netmon.gui.http;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.netmon.MsgTreeNode;
import com.sun.kvem.netmon.gui.HashTableModel;
import com.sun.kvem.netmon.gui.MsgTreeNodeViewer;
import com.sun.kvem.netmon.http.HttpMessage;
import com.sun.kvem.util.ToolkitResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.text.SimpleDateFormat;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class HttpMessageViewer
extends JPanel
implements MsgTreeNodeViewer {
    private static final Debug debug = Debug.create((Class)HttpMessageViewer.class);
    private HashTableModel tableModel = new HashTableModel(ToolkitResources.getString((String)"NETMON_KEYS"), ToolkitResources.getString((String)"NETMON_VALUES"));
    private JPanel top = new JPanel();
    private JPanel bottom = new JPanel();
    private JTable headerTable = new JTable(this.tableModel);
    private JScrollPane scrollPane = new JScrollPane(this.headerTable);
    private JLabel titleLabel = new JLabel();
    private JLabel startLineLabel = new JLabel();
    private JLabel dateLabel = new JLabel();
    private JTextArea bottomTextArea = new JTextArea();
    private JScrollPane bottomScrollPane = new JScrollPane(this.bottomTextArea);
    private HttpMessage msg;
    private Properties props;

    public HttpMessageViewer() {
        this.top.setPreferredSize(new Dimension(0, 60));
        this.top.setLayout(new BoxLayout(this.top, 1));
        this.top.add(this.titleLabel);
        this.top.add(this.startLineLabel);
        this.top.add(this.dateLabel);
        this.bottom.setPreferredSize(new Dimension(0, 45));
        this.bottom.setLayout(new BorderLayout());
        this.bottom.add(Box.createRigidArea(new Dimension(0, 5)), "North");
        this.bottom.add((Component)this.bottomScrollPane, "Center");
        this.bottomTextArea.setEditable(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.top, "North");
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)this.bottom, "South");
        this.headerTable.setSelectionMode(0);
        ListSelectionModel listSelectionModel = this.headerTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (listSelectionModel.isSelectionEmpty()) {
                    HttpMessageViewer.this.bottomTextArea.setText("");
                } else {
                    int n = listSelectionModel.getMinSelectionIndex();
                    String string = (String)HttpMessageViewer.this.tableModel.getValueAt(n, 0);
                    String string2 = (String)HttpMessageViewer.this.tableModel.getValueAt(n, 1);
                    HttpMessageViewer.this.bottomTextArea.setText(string + ": " + string2);
                }
            }
        });
    }

    public JComponent show(MsgTreeNode msgTreeNode) {
        this.msg = (HttpMessage)msgTreeNode;
        this.tableModel.setHash(this.msg.getHeader().getHeaderHashtable());
        this.titleLabel.setText(ToolkitResources.getString((String)"URL") + ": " + this.msg.getURL());
        this.startLineLabel.setText(ToolkitResources.getString((String)"NETMON_STATUS_LINE") + ": " + this.msg.getHeader().getStartLine());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(ToolkitResources.getString((String)"NETMON_DATE_FORMAT"));
        String string = simpleDateFormat.format(this.msg.getStartDate());
        this.dateLabel.setText(ToolkitResources.getString((String)"TIME") + ": " + string);
        return this;
    }

    public void nodeUpdated() {
        this.show(this.msg);
    }

    public void setProperties(Properties properties) {
        this.props = properties;
    }
}

