/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.netmon.gui.http;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.netmon.MsgTreeNode;
import com.sun.kvem.netmon.gui.HexViewPanel;
import com.sun.kvem.netmon.gui.MsgTreeNodeViewer;
import com.sun.kvem.netmon.http.HttpChunk;
import com.sun.kvem.util.PropWrapper;
import com.sun.kvem.util.ToolkitResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Properties;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class HttpChunkViewer
extends JPanel
implements MsgTreeNodeViewer {
    private static final Debug debug = Debug.create((Class)HttpChunkViewer.class);
    private JPanel top = new JPanel();
    private JLabel sizeLabel = new JLabel();
    private JLabel urlLabel = new JLabel();
    private HexViewPanel hexPanel = new HexViewPanel();
    private HttpChunk chunk;
    private Properties props;

    public HttpChunkViewer() {
        this.top.setPreferredSize(new Dimension(0, 40));
        this.top.setLayout(new BoxLayout(this.top, 1));
        this.top.add(this.urlLabel);
        this.top.add(this.sizeLabel);
        this.setLayout(new BorderLayout());
        this.add((Component)this.hexPanel, "Center");
        this.add((Component)this.top, "North");
    }

    public JComponent show(MsgTreeNode msgTreeNode) {
        this.chunk = (HttpChunk)msgTreeNode;
        this.hexPanel.show(this.chunk.getDataBytes());
        this.sizeLabel.setText(ToolkitResources.getString((String)"NETMON_SIZE") + " " + this.chunk.getDataSize());
        this.urlLabel.setText(ToolkitResources.getString((String)"URL") + ": " + this.chunk.getURL());
        return this;
    }

    public void nodeUpdated() {
        byte[] byArray = this.chunk.getDataBytes();
        this.hexPanel.update(byArray);
        this.sizeLabel.setText(ToolkitResources.getString((String)"NETMON_SIZE") + " " + byArray.length);
    }

    public void setProperties(Properties properties) {
        this.props = properties;
        try {
            PropWrapper propWrapper = new PropWrapper(properties, "kvem.netmon.");
            String string = propWrapper.getStr("fixed_font_name", "Courier New");
            int n = propWrapper.getInt("fixed_font_size", 12);
            this.hexPanel.setFixedFont(new Font(string, 0, n));
        }
        catch (Exception exception) {
            debug.exception(2, (Throwable)exception);
        }
    }
}

