/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.netmon.gui.bluetooth;

import com.sun.kvem.netmon.bluetooth.DataElement;
import com.sun.kvem.netmon.bluetooth.ServiceRecord;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

class ServiceRecordView
extends JTree {
    DefaultMutableTreeNode top;
    int numRows;

    public ServiceRecordView(DefaultMutableTreeNode defaultMutableTreeNode) {
        super(defaultMutableTreeNode);
        this.top = defaultMutableTreeNode;
    }

    public static ServiceRecordView create() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Service Record");
        return new ServiceRecordView(defaultMutableTreeNode);
    }

    public void setServiceRecord(ServiceRecord serviceRecord) {
        this.numRows = 1;
        int n = 0;
        this.top.removeAllChildren();
        if (serviceRecord == null) {
            return;
        }
        TreeMap treeMap = new TreeMap(serviceRecord.getRecords());
        while (!treeMap.isEmpty()) {
            Integer n2 = (Integer)treeMap.firstKey();
            DataElement dataElement = (DataElement)treeMap.remove(n2);
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(ServiceRecordView.getAttributeName(n2) + dataElement);
            int n3 = dataElement.getDataType();
            if (n3 == 48 || n3 == 56 || n3 == -2) {
                this.addDataSequence(defaultMutableTreeNode, dataElement, n2);
            }
            this.top.add(defaultMutableTreeNode);
            ++this.numRows;
        }
        ((DefaultTreeModel)this.treeModel).nodeStructureChanged(this.top);
        for (n = 0; n < this.numRows; ++n) {
            this.expandRow(n);
        }
    }

    private void addDataSequence(DefaultMutableTreeNode defaultMutableTreeNode, DataElement dataElement, int n) {
        Vector vector = dataElement.getVector();
        for (int i = 0; i < vector.size(); ++i) {
            DataElement dataElement2 = (DataElement)vector.elementAt(i);
            String string = "";
            int n2 = -1;
            switch (n) {
                case -1: {
                    break;
                }
                case 1: {
                    string = "ServiceClass" + i + ": ";
                    break;
                }
                case 4: {
                    string = "Protocol" + i + ": ";
                    n2 = -2;
                    break;
                }
                case -2: {
                    string = i == 0 ? "ProtocolName: " : "ProtocolSpecificParameter" + (i - 1) + ": ";
                }
            }
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(string + dataElement2);
            int n3 = dataElement2.getDataType();
            if (n3 == 48 || n3 == 56) {
                this.addDataSequence(defaultMutableTreeNode2, dataElement2, n2);
            }
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            ++this.numRows;
        }
    }

    private static final String getAttributeName(int n) {
        String string;
        switch (n) {
            case 0: {
                string = "ServiceRecordHandle";
                break;
            }
            case 1: {
                string = "ServiceClassIDList";
                break;
            }
            case 2: {
                string = "ServiceRecordState";
                break;
            }
            case 3: {
                string = "ServiceID";
                break;
            }
            case 4: {
                string = "ProtocolDescriptorList";
                break;
            }
            case 5: {
                string = "BrowseGroupList";
                break;
            }
            case 6: {
                string = "LanguageBasedAttributeIDList";
                break;
            }
            case 7: {
                string = "ServiceInfoTimeToLive";
                break;
            }
            case 8: {
                string = "ServiceAvailability";
                break;
            }
            case 9: {
                string = "BluetoothProfileDescriptorList";
                break;
            }
            case 10: {
                string = "DocumentationURL";
                break;
            }
            case 11: {
                string = "ClientExecutableURL";
                break;
            }
            case 12: {
                string = "IconURL";
                break;
            }
            case 512: {
                string = "VersionNumberList";
                break;
            }
            case 513: {
                string = "ServiceDatabaseState";
                break;
            }
            default: {
                return "Attrib #" + n + ": ";
            }
        }
        return "Attrib #" + n + "(" + string + "): ";
    }
}

