/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.netmon.gui.bluetooth;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.netmon.MsgTreeNode;
import com.sun.kvem.netmon.bluetooth.Notifier;
import com.sun.kvem.netmon.gui.HorizontalScroller;
import com.sun.kvem.netmon.gui.MsgTreeNodeViewer;
import com.sun.kvem.netmon.gui.bluetooth.ServiceRecordView;
import com.sun.kvem.util.PropWrapper;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class BluetoothNotifierViewer
extends JPanel
implements MsgTreeNodeViewer {
    private static final Debug debug = Debug.create((Class)BluetoothNotifierViewer.class);
    protected Properties props;
    private JLabel title;
    private ServiceRecordView serviceRecordView;
    private Notifier prevNotifier;
    private Vector components;
    private HorizontalScroller top = new HorizontalScroller(this);

    public BluetoothNotifierViewer() {
        this.title = new JLabel("   ");
        this.serviceRecordView = ServiceRecordView.create();
        this.setLayout(new BoxLayout(this, 1));
        this.title.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.title.getPreferredSize().height));
        this.title.setAlignmentX(0.5f);
        this.serviceRecordView.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.serviceRecordView.setAlignmentX(0.5f);
        this.add(this.title);
        this.add(this.serviceRecordView);
    }

    public JComponent show(MsgTreeNode msgTreeNode) {
        Notifier notifier = (Notifier)msgTreeNode;
        if (notifier != this.prevNotifier) {
            this.title.setText(notifier.getTitle());
            this.serviceRecordView.setServiceRecord(notifier.getServiceRecord());
        }
        return this.top;
    }

    public void nodeUpdated() {
        this.serviceRecordView.revalidate();
    }

    public void setProperties(Properties properties) {
        this.props = properties;
        try {
            PropWrapper propWrapper = new PropWrapper(properties, "kvem.netmon.");
            String string = propWrapper.getStr("fixed_font_name", "Courier New");
            String string2 = propWrapper.getStr("variable_font_name", "Arial");
            int n = propWrapper.getInt("fixed_font_size", 12);
            int n2 = propWrapper.getInt("variable_font_size", 14);
            this.title.setFont(new Font(string2, 1, n2 + 1));
        }
        catch (Exception exception) {
            debug.exception(2, (Throwable)exception);
        }
    }
}

