/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.netmon.gui;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.environment.ToolkitDirs;
import com.sun.kvem.netmon.DisplayableMsg;
import com.sun.kvem.netmon.MsgListener;
import com.sun.kvem.netmon.gui.HorizontalScroller;
import com.sun.kvem.netmon.gui.MsgFilterDialog;
import com.sun.kvem.netmon.gui.MsgJTree;
import com.sun.kvem.netmon.gui.MsgView;
import com.sun.kvem.netmon.gui.NetMonFrame;
import com.sun.kvem.netmon.util.AcceptAllFilter;
import com.sun.kvem.netmon.util.Filter;
import com.sun.kvem.netmon.util.GroupMsgComparator;
import com.sun.kvem.netmon.util.TimeMsgComparator;
import com.sun.kvem.netmon.util.URLMsgComparator;
import com.sun.kvem.util.ToolkitResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class NetMonPanel
extends JPanel
implements MsgListener {
    private static final Debug debug = Debug.create((Class)NetMonPanel.class);
    private static final Dimension TREE_SIZE = new Dimension(240, 0);
    private static final Dimension STATUS_BAR_SIZE = new Dimension(0, 25);
    JSplitPane splitPane = new JSplitPane();
    MsgView msgView;
    MsgJTree msgTree;
    JScrollPane treeScroll;
    JLabel statusText = new JLabel();
    JPanel statusBar = new JPanel();
    MessageFormat statusFormat;
    Properties props;
    Class contentType;
    private JCheckBox filterChkBox;
    private String imageRoot = ToolkitDirs.LIB + "images" + File.separator;
    private ImageIcon filterIcon = new ImageIcon(this.imageRoot + "filter.gif");
    private Filter currentFilter = null;
    Action filterAction;
    Action unfilterAction;
    Action filterSettingsAction;
    private NetMonFrame parent;

    public NetMonPanel(Properties properties, String string, Class clazz, NetMonFrame netMonFrame) {
        this.props = properties;
        this.setName(string);
        this.contentType = clazz;
        this.parent = netMonFrame;
        this.initActions();
        this.statusFormat = new MessageFormat(ToolkitResources.getString((String)"NETMON_STATUS_BAR_FORMAT"));
        this.msgView = new MsgView(properties);
        this.msgTree = new MsgJTree(properties, this.msgView);
        this.treeScroll = new HorizontalScroller(this.msgTree);
        this.treeScroll.setPreferredSize(TREE_SIZE);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.treeScroll, "Center");
        jPanel.add((Component)this.getFilterPanel(), "South");
        this.splitPane.setLeftComponent(jPanel);
        this.splitPane.setRightComponent(this.msgView);
        this.add((Component)this.splitPane, "Center");
        this.statusBar.setPreferredSize(STATUS_BAR_SIZE);
        this.statusBar.setLayout(new FlowLayout(0));
        this.statusBar.add(this.statusText);
        this.statusBar.setBorder(BorderFactory.createLoweredBevelBorder());
        this.add((Component)this.statusBar, "South");
        this.msgTree.setScrollsOnExpand(true);
        this.setFilter(AcceptAllFilter.instance());
    }

    private JToolBar getFilterPanel() {
        JToolBar jToolBar = new JToolBar();
        Dimension dimension = new Dimension(20, 20);
        this.filterChkBox = new JCheckBox(ToolkitResources.getString((String)"FILTER"));
        this.filterChkBox.setToolTipText(ToolkitResources.getString((String)"FILTER_CHK_BOX_TOOLTIP"));
        this.filterChkBox.setMnemonic(ToolkitResources.getString((String)"FILTER_CHK_BOX_SHORTCUT").charAt(0));
        this.filterChkBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    NetMonPanel.this.filterAction.actionPerformed(new ActionEvent(itemEvent.getSource(), 0, ""));
                } else {
                    NetMonPanel.this.unfilterAction.actionPerformed(new ActionEvent(itemEvent.getSource(), 0, ""));
                }
            }
        });
        jToolBar.add(this.filterChkBox);
        JButton jButton = new JButton(this.filterSettingsAction);
        jButton.setToolTipText(ToolkitResources.getString((String)"FILTER_SETTINGS_TOOLTIP"));
        jButton.setMnemonic(ToolkitResources.getString((String)"SETTINGS_SHORTCUT").charAt(0));
        jButton.setIcon(this.filterIcon);
        jToolBar.add(jButton);
        jToolBar.addSeparator(dimension);
        JLabel jLabel = new JLabel(" " + ToolkitResources.getString((String)"NETMON_SORT_BY") + ": ");
        jLabel.setToolTipText(ToolkitResources.getString((String)"NETMON_SORT_BY_TOOLTIP"));
        jToolBar.add(jLabel);
        JComboBox<Object> jComboBox = new JComboBox<Object>(new Object[]{new TimeMsgComparator(), new URLMsgComparator(new TimeMsgComparator()), new GroupMsgComparator(new TimeMsgComparator())});
        jComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                Comparator comparator = (Comparator)itemEvent.getItem();
                NetMonPanel.this.sortBy(comparator);
            }
        });
        jComboBox.setToolTipText(ToolkitResources.getString((String)"NETMON_SORT_BY_TOOLTIP"));
        jComboBox.setMaximumSize(jComboBox.getPreferredSize());
        jLabel.setLabelFor(jComboBox);
        jLabel.setDisplayedMnemonic(ToolkitResources.getString((String)"NETMON_SORT_BY_SHORTCUT").charAt(0));
        jToolBar.add(jComboBox);
        return jToolBar;
    }

    private void initActions() {
        this.filterSettingsAction = new AbstractAction(ToolkitResources.getString((String)"FILTER_SETTINGS")){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Class<?> clazz;
                    DisplayableMsg displayableMsg = (DisplayableMsg)NetMonPanel.this.contentType.newInstance();
                    String string = displayableMsg.getDefaultType();
                    String string2 = "com.sun.kvem.netmon.gui.";
                    try {
                        clazz = Class.forName(string2 + string + ".MsgFilterDialog");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        clazz = Class.forName(string2 + "dflt.MsgFilterDialog");
                    }
                    MsgFilterDialog msgFilterDialog = (MsgFilterDialog)clazz.newInstance();
                    msgFilterDialog.setTitle(ToolkitResources.getString((String)"NETMON_MESSAGE_FILTER") + " (" + NetMonPanel.this.getName() + ")");
                    msgFilterDialog.setFilter(NetMonPanel.this.currentFilter);
                    msgFilterDialog.pack();
                    msgFilterDialog.setLocationRelativeTo(NetMonPanel.this.parent);
                    msgFilterDialog.setDefaultCloseOperation(2);
                    msgFilterDialog.setModal(true);
                    msgFilterDialog.setVisible(true);
                    Filter filter = msgFilterDialog.getFilter();
                    if (filter != null) {
                        NetMonPanel.this.currentFilter = filter;
                        NetMonPanel.this.parent.saveFilters();
                        if (NetMonPanel.this.filterChkBox.isSelected()) {
                            NetMonPanel.this.setFilter(NetMonPanel.this.currentFilter);
                            NetMonPanel.this.filter();
                        } else {
                            NetMonPanel.this.filterChkBox.setSelected(true);
                        }
                    }
                }
                catch (Exception exception) {
                    debug;
                    Debug.warning((String)exception.toString());
                    debug.exception(2, (Throwable)exception);
                }
            }
        };
        this.filterAction = new AbstractAction(ToolkitResources.getString((String)"FILTER")){

            public void actionPerformed(ActionEvent actionEvent) {
                NetMonPanel.this.setFilter(NetMonPanel.this.currentFilter);
                NetMonPanel.this.filter();
            }
        };
        this.unfilterAction = new AbstractAction(ToolkitResources.getString((String)"CANCEL_FILTER")){

            public void actionPerformed(ActionEvent actionEvent) {
                NetMonPanel.this.unfilter();
            }
        };
    }

    public void sortBy(Comparator comparator) {
        this.msgTree.sortBy(comparator);
    }

    public void clearMsges() {
        this.msgTree.clearMsges();
        this.msgView.removeAll();
        this.updateStatusBar();
    }

    public void saveMessages(FileOutputStream fileOutputStream) throws IOException {
        Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)this.msgTree.getModel().getRoot()).children();
        while (enumeration.hasMoreElements()) {
            DisplayableMsg displayableMsg = (DisplayableMsg)enumeration.nextElement();
            displayableMsg.writeXML("", fileOutputStream);
        }
    }

    public void loadMessages(List list) {
        LinkedList<DisplayableMsg> linkedList = new LinkedList<DisplayableMsg>();
        for (int i = 0; i < list.size(); ++i) {
            DisplayableMsg displayableMsg = (DisplayableMsg)list.get(i);
            if (!this.contentType.isInstance(displayableMsg)) continue;
            linkedList.add(displayableMsg);
        }
        this.msgTree.load(linkedList);
    }

    public void saveFilter(FileOutputStream fileOutputStream) throws IOException {
        String string = this.getContentType();
        fileOutputStream.write(("\t<" + string + ">\n").getBytes("UTF-8"));
        this.currentFilter.writeXML("\t\t\t", fileOutputStream);
        fileOutputStream.write(("\t</" + string + ">\n").getBytes("UTF-8"));
    }

    public void setFilter(Filter filter) {
        this.currentFilter = filter;
    }

    public void filter() {
        this.msgTree.filter(this.currentFilter);
        this.updateStatusBar();
        this.filterChkBox.setSelected(true);
    }

    public void unfilter() {
        this.msgTree.filter(AcceptAllFilter.instance());
        this.updateStatusBar();
        this.filterChkBox.setSelected(false);
    }

    public int getShownMsgCount() {
        return this.msgTree.getShownMsgCount();
    }

    public int getTotalMsgCount() {
        return this.msgTree.getTotalMsgCount();
    }

    public void post(DisplayableMsg displayableMsg) {
        this.msgTree.post(displayableMsg);
        this.updateStatusBar();
    }

    private void updateStatusBar() {
        Object[] objectArray = new Object[]{new Integer(this.getShownMsgCount()), new Integer(this.getTotalMsgCount())};
        this.statusText.setText(this.statusFormat.format(objectArray));
    }

    public void updateStatusBar(String string) {
        this.statusText.setText(string);
    }

    public String getContentType() {
        String string = this.contentType.getName();
        int n = string.lastIndexOf(".");
        if (n < 0 || n >= string.length() - 1) {
            throw new RuntimeException();
        }
        string = string.substring(n + 1);
        return string;
    }
}

