/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.netmon.gui;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.environment.ModulesRegistry;
import com.sun.kvem.environment.ToolkitDirs;
import com.sun.kvem.netmon.DisplayableMsg;
import com.sun.kvem.netmon.MsgListener;
import com.sun.kvem.netmon.MsgTreeNode;
import com.sun.kvem.netmon.MsgUpdateListener;
import com.sun.kvem.netmon.SyntaxErrorException;
import com.sun.kvem.netmon.comm.CommMessage;
import com.sun.kvem.netmon.comm.CommMsgReceiver;
import com.sun.kvem.netmon.datagram.DatagramMessage;
import com.sun.kvem.netmon.datagram.DatagramMsgReceiver;
import com.sun.kvem.netmon.gui.NetMonPanel;
import com.sun.kvem.netmon.http.HttpMessage;
import com.sun.kvem.netmon.http.HttpMsgReceiver;
import com.sun.kvem.netmon.http.HttpsMsgReceiver;
import com.sun.kvem.netmon.socket.SocketMessage;
import com.sun.kvem.netmon.socket.SocketMsgReceiver;
import com.sun.kvem.netmon.ssl.SSLMessage;
import com.sun.kvem.netmon.ssl.SSLMsgReceiver;
import com.sun.kvem.netmon.util.AcceptAllFilter;
import com.sun.kvem.netmon.util.Filter;
import com.sun.kvem.netmon.util.Reader;
import com.sun.kvem.netmon.util.Writer;
import com.sun.kvem.util.SmartFileChooser;
import com.sun.kvem.util.ToolkitResources;
import com.sun.kvem.util.WindowUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class NetMonFrame
extends JFrame
implements MsgListener,
MsgUpdateListener {
    private static final Debug debug = Debug.create((Class)NetMonFrame.class);
    private static final Dimension FRAME_SIZE = new Dimension(850, 500);
    public static final String NETMON_SESSION_FILE_EXT = "nms";
    public static MessageFormat fileExistsMsgFormat = new MessageFormat(ToolkitResources.getString((String)"FILE_EXISTS_MSG"));
    public static final String DEFAULT_FILTER_FILE_NAME = "netmon_filter.dat";
    NetMonPanel[] protocolPanels;
    JMenuBar menuBar = new JMenuBar();
    JToolBar toolBar = new JToolBar();
    Action clearMsgesAction;
    Action saveSession;
    Action saveSessionAs;
    Action loadSession;
    Action closeAction;
    private Properties props;
    private String filterFileName;
    private File currentFile = null;
    private boolean loadedNewSessionFile = false;
    private File defaultDir = new File(ToolkitDirs.SESSION);
    private Frame device = null;
    private boolean online;
    private JTabbedPane tabs;
    private Hashtable tabOrder;
    private static LoadSessionProgressIndicator loadIndicator;

    public boolean openLoadDialog() {
        return this.loadSession();
    }

    public NetMonFrame(Properties properties, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Serializable serializable;
        WindowUtils.setLookAndFeel();
        this.props = properties;
        this.online = bl;
        this.device = null;
        this.updateTitle();
        this.tabs = new JTabbedPane();
        this.tabOrder = new Hashtable();
        NetMonPanel netMonPanel = new NetMonPanel(properties, ToolkitResources.getString((String)"NETMON_PROTOCOL_HTTP") + " / " + ToolkitResources.getString((String)"NETMON_PROTOCOL_HTTPS"), HttpMessage.class, this);
        HttpMsgReceiver.addMsgListener(netMonPanel);
        HttpMsgReceiver.addMsgListener(this);
        HttpsMsgReceiver.addMsgListener(netMonPanel);
        HttpsMsgReceiver.addMsgListener(this);
        this.tabOrder.put("http", new Integer(this.tabs.getTabCount()));
        this.tabOrder.put("https", new Integer(this.tabs.getTabCount()));
        this.tabs.add(netMonPanel);
        NetMonPanel netMonPanel2 = null;
        try {
            netMonPanel2 = new NetMonPanel(properties, ToolkitResources.getString((String)"NETMON_PROTOCOL_SMS"), Class.forName("com.sun.kvem.netmon.sms.SMSMessage"), this);
            serializable = Class.forName("com.sun.kvem.netmon.sms.SMSMsgReceiver");
            object4 = serializable.getMethod("addMsgListener", MsgListener.class);
            ((Method)object4).invoke(null, netMonPanel2);
            ((Method)object4).invoke(null, this);
            this.tabOrder.put("sms", new Integer(this.tabs.getTabCount()));
            this.tabOrder.put("cbs", new Integer(this.tabs.getTabCount()));
            this.tabs.add(netMonPanel2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            debug.println(2, "no SMS protocol for network monitor.");
            debug.exception(2, (Throwable)classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            debug.exception(2, (Throwable)noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            debug.exception(2, (Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            debug.exception(2, (Throwable)invocationTargetException);
        }
        serializable = null;
        try {
            serializable = new NetMonPanel(properties, ToolkitResources.getString((String)"NETMON_PROTOCOL_MMS"), Class.forName("com.sun.kvem.netmon.mms.MMSMessage"), this);
            object4 = Class.forName("com.sun.kvem.netmon.mms.MMSMsgReceiver");
            object3 = ((Class)object4).getMethod("addMsgListener", MsgListener.class);
            ((Method)object3).invoke(null, serializable);
            ((Method)object3).invoke(null, this);
            this.tabOrder.put("mms", new Integer(this.tabs.getTabCount()));
            this.tabs.add((Component)serializable);
        }
        catch (ClassNotFoundException classNotFoundException) {
            debug.println(2, "no MMS protocol for network monitor.");
            debug.exception(2, (Throwable)classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            debug.exception(2, (Throwable)noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            debug.exception(2, (Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            debug.exception(2, (Throwable)invocationTargetException);
        }
        object4 = null;
        try {
            object4 = new NetMonPanel(properties, ToolkitResources.getString((String)"NETMON_PROTOCOL_OBEX"), Class.forName("com.sun.kvem.netmon.obex.ObexHandler"), this);
            object3 = Class.forName("com.sun.kvem.netmon.obex.ObexMsgReceiver");
            object2 = ((Class)object3).getMethod("addMsgListener", MsgListener.class);
            ((Method)object2).invoke(null, object4);
            ((Method)object2).invoke(null, this);
            this.tabOrder.put("obex", new Integer(this.tabs.getTabCount()));
            this.tabs.add((Component)object4);
        }
        catch (ClassNotFoundException classNotFoundException) {
            debug.println(2, "no OBEX protocol for network monitor.");
            debug.exception(2, (Throwable)classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            debug.exception(2, (Throwable)noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            debug.exception(2, (Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            debug.exception(2, (Throwable)invocationTargetException);
        }
        object3 = null;
        try {
            object3 = new NetMonPanel(properties, ToolkitResources.getString((String)"NETMON_PROTOCOL_BLUETOOTH"), Class.forName("com.sun.kvem.netmon.bluetooth.BluetoothHandler"), this);
            object2 = Class.forName("com.sun.kvem.netmon.bluetooth.BluetoothMsgReceiver");
            object = ((Class)object2).getMethod("addMsgListener", MsgListener.class);
            ((Method)object).invoke(null, object3);
            ((Method)object).invoke(null, this);
            this.tabOrder.put("bluetooth", new Integer(this.tabs.getTabCount()));
            this.tabs.add((Component)object3);
        }
        catch (ClassNotFoundException classNotFoundException) {
            debug.println(2, "no BLUETOOTH protocols for network monitor.");
            debug.exception(2, (Throwable)classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            debug.exception(2, (Throwable)noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            debug.exception(2, (Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            debug.exception(2, (Throwable)invocationTargetException);
        }
        object2 = new NetMonPanel(properties, ToolkitResources.getString((String)"NETMON_PROTOCOL_SOCKET"), SocketMessage.class, this);
        SocketMsgReceiver.addMsgListener((MsgListener)object2);
        SocketMsgReceiver.addMsgListener(this);
        this.tabOrder.put("socket", new Integer(this.tabs.getTabCount()));
        this.tabs.add((Component)object2);
        object = new NetMonPanel(properties, ToolkitResources.getString((String)"NETMON_PROTOCOL_SSL"), SSLMessage.class, this);
        SSLMsgReceiver.addMsgListener((MsgListener)object);
        SSLMsgReceiver.addMsgListener(this);
        this.tabOrder.put("ssl", new Integer(this.tabs.getTabCount()));
        this.tabs.add((Component)object);
        NetMonPanel netMonPanel3 = new NetMonPanel(properties, ToolkitResources.getString((String)"NETMON_PROTOCOL_DATAGRAM"), DatagramMessage.class, this);
        DatagramMsgReceiver.addMsgListener(netMonPanel3);
        DatagramMsgReceiver.addMsgListener(this);
        this.tabOrder.put("datagram", new Integer(this.tabs.getTabCount()));
        this.tabs.add(netMonPanel3);
        NetMonPanel netMonPanel4 = new NetMonPanel(properties, ToolkitResources.getString((String)"NETMON_PROTOCOL_COMM"), CommMessage.class, this);
        CommMsgReceiver.addMsgListener(netMonPanel4);
        CommMsgReceiver.addMsgListener(this);
        this.tabOrder.put("comm", new Integer(this.tabs.getTabCount()));
        this.tabs.add(netMonPanel4);
        this.tabs.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                NetMonFrame.this.tabs.setTitleAt(NetMonFrame.this.tabs.getSelectedIndex(), NetMonFrame.this.tabs.getSelectedComponent().getName());
            }
        });
        int n = 5;
        int n2 = 0;
        if (netMonPanel2 != null) {
            ++n;
        }
        if (serializable != null) {
            ++n;
        }
        if (object4 != null) {
            ++n;
        }
        if (object3 != null) {
            ++n;
        }
        this.protocolPanels = new NetMonPanel[n];
        this.protocolPanels[n2++] = netMonPanel;
        this.protocolPanels[n2++] = object2;
        this.protocolPanels[n2++] = object;
        this.protocolPanels[n2++] = netMonPanel3;
        this.protocolPanels[n2++] = netMonPanel4;
        if (netMonPanel2 != null) {
            this.protocolPanels[n2++] = netMonPanel2;
        }
        if (serializable != null) {
            this.protocolPanels[n2++] = serializable;
        }
        if (object4 != null) {
            this.protocolPanels[n2++] = object4;
        }
        if (object3 != null) {
            this.protocolPanels[n2++] = object3;
        }
        this.setSize(FRAME_SIZE);
        this.setJMenuBar(this.menuBar);
        this.getContentPane().add((Component)this.toolBar, "North");
        this.getContentPane().add((Component)this.tabs, "Center");
        this.filterFileName = ToolkitDirs.LIB + properties.getProperty("kvem.netmon.filter_file_name", DEFAULT_FILTER_FILE_NAME);
        this.loadFilter(AcceptAllFilter.instance());
        this.getAccessibleContext().setAccessibleName(ToolkitResources.getString((String)"NETMON_NETWORK_MONITOR_TITLE_PREF"));
        this.getAccessibleContext().setAccessibleDescription(ToolkitResources.getString((String)"NETMON_NETWORK_MONITOR_DESC"));
        this.initActions();
        this.initMenu();
        String string = ToolkitDirs.LIB + "images" + File.separator + "NetworkMonitor.gif";
        WindowUtils.setFrameIcon((JFrame)this, (String)string);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                ModulesRegistry.registerModule((Object)this);
            }

            public void windowClosed(WindowEvent windowEvent) {
                ModulesRegistry.deregisterModule((Object)this);
            }
        });
    }

    public void setDeviceFrame(Frame frame) {
        this.device = frame;
        this.updateTitle();
    }

    private void initActions() {
        this.clearMsgesAction = new AbstractAction(ToolkitResources.getString((String)"CLEAR")){

            public void actionPerformed(ActionEvent actionEvent) {
                for (int i = 0; i < NetMonFrame.this.protocolPanels.length; ++i) {
                    NetMonFrame.this.protocolPanels[i].clearMsges();
                }
            }
        };
        this.clearMsgesAction.setEnabled(this.online);
        this.saveSessionAs = new AbstractAction(ToolkitResources.getString((String)"SAVE_SESSION_AS")){

            public void actionPerformed(ActionEvent actionEvent) {
                File file;
                SmartFileChooser smartFileChooser = new SmartFileChooser(NetMonFrame.this.currentFile, NetMonFrame.this.defaultDir);
                smartFileChooser.setAcceptAllFileFilterUsed(false);
                smartFileChooser.addExtFilter(NetMonFrame.NETMON_SESSION_FILE_EXT, ToolkitResources.getString((String)"NETON_FILE_FILTER_DESC"));
                int n = smartFileChooser.showSaveDialog((Component)NetMonFrame.this);
                if (n == 0 && NetMonFrame.this.saveSession(file = smartFileChooser.getSelectedFile())) {
                    NetMonFrame.this.currentFile = file;
                    NetMonFrame.this.updateTitle();
                }
            }
        };
        this.saveSession = new AbstractAction(ToolkitResources.getString((String)"SAVE_SESSION")){

            public void actionPerformed(ActionEvent actionEvent) {
                if (NetMonFrame.this.currentFile == null) {
                    NetMonFrame.this.saveSessionAs.actionPerformed(actionEvent);
                } else {
                    NetMonFrame.this.saveSession(NetMonFrame.this.currentFile);
                }
            }
        };
        this.loadSession = new AbstractAction(ToolkitResources.getString((String)"MONITORS.OPEN")){

            public void actionPerformed(ActionEvent actionEvent) {
                NetMonFrame.this.loadSession();
            }
        };
        this.loadSession.setEnabled(!this.online);
        this.closeAction = new AbstractAction(ToolkitResources.getString((String)"CLOSE")){

            public void actionPerformed(ActionEvent actionEvent) {
                NetMonFrame.this.dispose();
            }
        };
    }

    private boolean saveSession(File file) {
        boolean bl = false;
        try {
            if (new Writer(this.protocolPanels).saveSession(file)) {
                bl = true;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            debug.exception(1, (Throwable)fileNotFoundException);
            JOptionPane.showMessageDialog(this, ToolkitResources.getString((String)"NETMON_FILE_NOT_FOUND") + "\n" + this.currentFile.getAbsoluteFile(), ToolkitResources.getString((String)"ERROR_TITLE"), 0);
        }
        catch (IOException iOException) {
            debug.exception(1, (Throwable)iOException);
            JOptionPane.showMessageDialog(this, ToolkitResources.getString((String)"NETMON_UNKNOWN_ERROR") + "\n" + iOException.getMessage(), ToolkitResources.getString((String)"ERROR_TITLE"), 0);
        }
        return bl;
    }

    private boolean loadSession() {
        SmartFileChooser smartFileChooser = new SmartFileChooser(this.currentFile, this.defaultDir);
        smartFileChooser.setAcceptAllFileFilterUsed(false);
        smartFileChooser.addExtFilter(NETMON_SESSION_FILE_EXT, ToolkitResources.getString((String)"NETON_FILE_FILTER_DESC"));
        int n = smartFileChooser.showOpenDialog((Component)this);
        loadIndicator = new LoadSessionProgressIndicator(this);
        if (n == 0) {
            this.loadedNewSessionFile = false;
            final File file = smartFileChooser.getSelectedFile();
            loadIndicator.pack();
            WindowUtils.center((Window)loadIndicator, (Window)this);
            new Thread(new Runnable(){

                public void run() {
                    try {
                        NetMonFrame.this.protocolPanels[0].updateStatusBar(ToolkitResources.getString((String)"LOADING"));
                        NetMonFrame.this.setVisible(true);
                        if (new Reader(NetMonFrame.this.protocolPanels).loadSession(file)) {
                            NetMonFrame.this.currentFile = file;
                            NetMonFrame.this.updateTitle();
                            NetMonFrame.this.loadedNewSessionFile = true;
                        }
                        NetMonFrame.this.protocolPanels[0].updateStatusBar("");
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        debug.exception(1, (Throwable)fileNotFoundException);
                        JOptionPane.showMessageDialog(NetMonFrame.this, ToolkitResources.getString((String)"NETMON_FILE_NOT_FOUND") + "\n" + file.getAbsoluteFile(), ToolkitResources.getString((String)"ERROR_TITLE"), 0);
                    }
                    catch (SyntaxErrorException syntaxErrorException) {
                        debug.exception(1, (Throwable)syntaxErrorException);
                        JOptionPane.showMessageDialog(NetMonFrame.this, ToolkitResources.getString((String)"CORRUPTED_FILE"), ToolkitResources.getString((String)"NETMON_ERROR_TITLE"), 0);
                    }
                    loadIndicator.dispose();
                }
            }).start();
            loadIndicator.setVisible(true);
            return this.loadedNewSessionFile;
        }
        return false;
    }

    private void initMenu() {
        JMenu jMenu = new JMenu(ToolkitResources.getString((String)"FILE"));
        jMenu.setMnemonic(ToolkitResources.getString((String)"FILE_SHORTCUT").charAt(0));
        this.menuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem(this.loadSession);
        jMenuItem.setMnemonic(ToolkitResources.getString((String)"OPEN_SHORTCUT").charAt(0));
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(this.saveSession);
        jMenuItem.setMnemonic(ToolkitResources.getString((String)"SAVE_SESSION_SHORTCUT").charAt(0));
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(this.saveSessionAs);
        jMenuItem.setMnemonic(ToolkitResources.getString((String)"SAVE_SESSION_AS_SHORTCUT").charAt(0));
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem(this.closeAction);
        jMenuItem.setMnemonic(ToolkitResources.getString((String)"CLOSE_SHORTCUT").charAt(0));
        jMenu.add(jMenuItem);
        jMenu = new JMenu(ToolkitResources.getString((String)"EDIT"));
        jMenu.setMnemonic(ToolkitResources.getString((String)"EDIT_SHORTCUT").charAt(0));
        this.menuBar.add(jMenu);
        jMenuItem = new JMenuItem(this.clearMsgesAction);
        jMenuItem.setMnemonic(ToolkitResources.getString((String)"CLEAR_SHORTCUT").charAt(0));
        jMenu.add(jMenuItem);
    }

    private void updateTitle() {
        StringBuffer stringBuffer = new StringBuffer(ToolkitResources.getString((String)"NETMON_NETWORK_MONITOR_TITLE_PREF"));
        if (this.device != null) {
            stringBuffer.append(" - ").append(this.device.getTitle());
        }
        if (this.currentFile != null) {
            stringBuffer.append(" [" + this.currentFile.getName()).append("]");
        }
        stringBuffer.append(" - ").append(ToolkitResources.getString((String)"MONITOR_TITLE_SUFF"));
        this.setTitle(stringBuffer.toString());
    }

    public void clearAll() {
        for (int i = 0; i < this.protocolPanels.length; ++i) {
            this.protocolPanels[i].clearMsges();
        }
        HttpMsgReceiver.clearAll();
        HttpsMsgReceiver.clearAll();
    }

    boolean saveFilters() {
        boolean bl = false;
        try {
            File file = new File(this.filterFileName);
            if (new Writer(this.protocolPanels).saveFilters(file)) {
                bl = true;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            debug.exception(1, (Throwable)fileNotFoundException);
            JOptionPane.showMessageDialog(this, ToolkitResources.getString((String)"NETMON_FILE_NOT_FOUND") + "\n" + this.currentFile.getAbsoluteFile(), ToolkitResources.getString((String)"ERROR_TITLE"), 0);
        }
        catch (IOException iOException) {
            debug.exception(1, (Throwable)iOException);
            JOptionPane.showMessageDialog(this, ToolkitResources.getString((String)"NETMON_UNKNOWN_ERROR") + "\n" + iOException.getMessage(), ToolkitResources.getString((String)"ERROR_TITLE"), 0);
        }
        return bl;
    }

    private Filter loadFilter(Filter filter) {
        Filter filter2 = filter;
        File file = new File(this.filterFileName);
        if (file.isFile()) {
            try {
                new Reader(this.protocolPanels).loadFilter(file, filter);
            }
            catch (Exception exception) {
                debug.exception(1, (Throwable)exception);
            }
        }
        return filter2;
    }

    public void post(DisplayableMsg displayableMsg) {
        displayableMsg.addMsgUpdateListener(this);
    }

    public void msgUpdated(DisplayableMsg displayableMsg, MsgTreeNode msgTreeNode, boolean bl) {
        int n = (Integer)this.tabOrder.get(displayableMsg.getDefaultType());
        if (n != this.tabs.getSelectedIndex()) {
            this.tabs.setTitleAt(n, this.tabs.getComponentAt(n).getName() + " *");
        }
    }

    public void stop() {
        this.loadSession.setEnabled(true);
    }

    private static class LoadSessionProgressIndicator
    extends JDialog {
        private JProgressBar progress = new JProgressBar();
        private JLabel stage = new JLabel(ToolkitResources.getString((String)"LOADING"));

        public LoadSessionProgressIndicator(JFrame jFrame) {
            super((Frame)jFrame, true);
            this.setDefaultCloseOperation(0);
            this.setTitle(ToolkitResources.getString((String)"LOADING_TITLE"));
            this.progress.setIndeterminate(true);
            this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
            this.getContentPane().add(this.stage);
            this.getContentPane().add(this.progress);
            this.pack();
        }
    }
}

