/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.netmon.gui;

import com.sun.kvem.environment.ToolkitDirs;
import com.sun.kvem.netmon.DisplayableMsg;
import com.sun.kvem.netmon.MsgTreeNode;
import com.sun.kvem.util.PropWrapper;
import java.awt.Component;
import java.awt.Font;
import java.io.File;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

class MsgTreeRenderer
extends DefaultTreeCellRenderer {
    private static final String ICON_NAME_SUFIX = "-msg.gif";
    Font defFont;
    private String imageRoot = ToolkitDirs.LIB + "images" + File.separator;
    private ImageIcon defaultIcon = new ImageIcon(this.imageRoot + "default-msg.gif");
    private Hashtable iconCache = new Hashtable();
    private PropWrapper props;

    public MsgTreeRenderer(Properties properties, Font font) {
        this.props = new PropWrapper(properties, "kvem.netmon.tree.");
        this.defFont = font;
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        this.selected = bl;
        this.hasFocus = bl4;
        this.setFont(this.defFont);
        if (bl) {
            this.setForeground(this.getTextSelectionColor());
        } else {
            this.setForeground(this.getTextNonSelectionColor());
        }
        if (object instanceof MsgTreeNode) {
            MsgTreeNode msgTreeNode = (MsgTreeNode)object;
            this.setIcon(msgTreeNode);
            this.setToolTipText(msgTreeNode.getToolTip());
            if (msgTreeNode instanceof DisplayableMsg) {
                DisplayableMsg displayableMsg = (DisplayableMsg)msgTreeNode;
                if (!displayableMsg.isComplete()) {
                    this.setFont(this.defFont.deriveFont(1));
                }
                this.setText(displayableMsg.getTitle());
                this.setToolTipText(displayableMsg.getTitle());
            } else {
                this.setText(msgTreeNode.getTitle());
            }
        } else {
            this.setIcon(this.defaultIcon);
            this.setToolTipText(object.toString());
            this.setText(object.toString());
        }
        return this;
    }

    ImageIcon getIcon(String string) {
        ImageIcon imageIcon = (ImageIcon)this.iconCache.get(string);
        if (imageIcon != null) {
            return imageIcon;
        }
        imageIcon = new ImageIcon(this.imageRoot + string);
        if (imageIcon.getIconWidth() == -1) {
            return null;
        }
        this.iconCache.put(string, imageIcon);
        return imageIcon;
    }

    private void setIcon(MsgTreeNode msgTreeNode) {
        ImageIcon imageIcon;
        int n = msgTreeNode.getDirection();
        String string = msgTreeNode.getType();
        if (n != 2) {
            String string2 = n == 0 ? string + "-out.gif" : string + "-in.gif";
            imageIcon = this.getIcon(string2);
            if (imageIcon == null) {
                string2 = msgTreeNode.getType() + ICON_NAME_SUFIX;
                imageIcon = this.getIcon(string2);
            }
        } else {
            String string3 = msgTreeNode.getType() + ICON_NAME_SUFIX;
            imageIcon = this.getIcon(string3);
        }
        if (imageIcon == null) {
            imageIcon = this.defaultIcon;
        }
        this.setIcon(imageIcon);
    }
}

