/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.netmon.gui;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.netmon.DisplayableMsg;
import com.sun.kvem.netmon.MsgListener;
import com.sun.kvem.netmon.MsgTreeNode;
import com.sun.kvem.netmon.MsgUpdateListener;
import com.sun.kvem.netmon.gui.MsgTreeNodeViewer;
import com.sun.kvem.netmon.gui.MsgTreeRenderer;
import com.sun.kvem.netmon.gui.MsgView;
import com.sun.kvem.netmon.gui.dflt.DefaultViewer;
import com.sun.kvem.netmon.util.AcceptAllFilter;
import com.sun.kvem.netmon.util.Filter;
import com.sun.kvem.netmon.util.TimeMsgComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class MsgJTree
extends JTree
implements MsgUpdateListener,
MsgListener,
TreeSelectionListener {
    private static final Debug debug = Debug.create((Class)MsgJTree.class);
    private static final int HEIGHT_PADDING = 30;
    private static final int WIDTH_PADDING = 30;
    private static final String VIEWER_PACKAGE_PREFIX = "com.sun.kvem.netmon.gui.";
    private DefaultMutableTreeNode rootNode;
    private DefaultTreeModel treeModel;
    private MsgTreeRenderer treeCellRenderer;
    private MsgView view;
    private DefaultViewer defaultViewer = new DefaultViewer();
    private Hashtable viewerCache = new Hashtable();
    private MsgTreeNodeViewer viewer = this.defaultViewer;
    private Properties props;
    private Comparator comparator = new TimeMsgComparator();
    private Filter filter = AcceptAllFilter.instance();
    private Vector excludeMsgs = new Vector();
    private TreePath selectionPath = null;

    public MsgJTree(Properties properties, MsgView msgView) {
        this.props = properties;
        this.defaultViewer.setProperties(properties);
        this.rootNode = new JTree.DynamicUtilTreeNode((Object)"", new Object[0]);
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.treeCellRenderer = new MsgTreeRenderer(properties, this.getFont());
        this.getSelectionModel().setSelectionMode(1);
        this.setCellRenderer(this.treeCellRenderer);
        this.setModel(this.treeModel);
        this.addTreeSelectionListener(this);
        this.setToolTipText("");
        this.view = msgView;
        this.revalidate();
    }

    public Filter getCurrFilter() {
        return this.filter;
    }

    public int getShownMsgCount() {
        return this.getModel().getChildCount(this.getModel().getRoot());
    }

    public int getTotalMsgCount() {
        return this.getShownMsgCount() + this.excludeMsgs.size();
    }

    public synchronized void sortBy(Comparator comparator) {
        this.comparator = comparator;
        this.repostTree();
    }

    public synchronized void filter(Filter filter) {
        this.filter = filter;
        this.repostTree();
    }

    public synchronized void clearMsges() {
        DisplayableMsg displayableMsg;
        int n = this.treeModel.getChildCount(this.rootNode);
        for (int i = 0; i < n; ++i) {
            displayableMsg = (DisplayableMsg)this.treeModel.getChild(this.rootNode, i);
            displayableMsg.removeMsgUpdateListener(this);
        }
        this.rootNode.removeAllChildren();
        Enumeration enumeration = this.excludeMsgs.elements();
        while (enumeration.hasMoreElements()) {
            displayableMsg = (DisplayableMsg)enumeration.nextElement();
            displayableMsg.removeMsgUpdateListener(this);
        }
        this.excludeMsgs.removeAllElements();
        this.treeModel.nodeStructureChanged(this.rootNode);
        this.resetSelection();
    }

    public synchronized void post(DisplayableMsg displayableMsg) {
        if (this.filter.accept(displayableMsg)) {
            int n;
            int n2 = this.rootNode.getChildCount();
            for (n = n2 - 1; n >= 0; --n) {
                if (this.comparator.compare(displayableMsg, this.treeModel.getChild(this.rootNode, n)) < 0) continue;
                this.treeModel.insertNodeInto(displayableMsg, this.rootNode, n + 1);
                break;
            }
            if (n < 0) {
                this.treeModel.insertNodeInto(displayableMsg, this.rootNode, 0);
            }
            TreePath treePath = new TreePath(this.rootNode);
            this.expandPath(treePath);
        } else {
            this.excludeMsgs.addElement(displayableMsg);
        }
        displayableMsg.addMsgUpdateListener(this);
    }

    public synchronized void msgUpdated(DisplayableMsg displayableMsg, MsgTreeNode msgTreeNode, boolean bl) {
        this.storeSelection();
        if (this.excludeMsgs.contains(displayableMsg) && this.filter.accept(displayableMsg)) {
            this.excludeMsgs.removeElement(displayableMsg);
            displayableMsg.removeMsgUpdateListener(this);
            this.post(displayableMsg);
        } else {
            Object object;
            TreePath treePath;
            this.treeModel.nodeChanged(msgTreeNode.getParent());
            if (bl) {
                this.treeModel.nodeStructureChanged(msgTreeNode.getParent());
            }
            if ((treePath = this.getSelectionPath()) != null && (object = treePath.getLastPathComponent()) != null && object.equals(msgTreeNode)) {
                this.viewer.nodeUpdated();
            }
        }
        this.restoreSelection();
    }

    public synchronized void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        Object object = treeSelectionEvent.getPath().getLastPathComponent();
        if (object instanceof MsgTreeNode) {
            MsgTreeNode msgTreeNode = (MsgTreeNode)object;
            String string = this.getClassNameFor(msgTreeNode);
            this.viewer = (MsgTreeNodeViewer)this.viewerCache.get(string);
            if (this.viewer == null) {
                try {
                    Class<?> clazz = Class.forName(string);
                    this.viewer = (MsgTreeNodeViewer)clazz.newInstance();
                    this.viewer.setProperties(this.props);
                }
                catch (Exception exception) {
                    debug.exception(2, (Throwable)exception);
                    this.viewer = this.defaultViewer;
                }
                this.viewerCache.put(string, this.viewer);
            }
            JComponent jComponent = this.viewer.show(msgTreeNode);
            this.view.setViewerPanel(jComponent);
        } else {
            this.view.removeViewer();
        }
    }

    public void load(List list) {
        this.clearMsges();
        Collections.sort(list, this.comparator);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            DisplayableMsg displayableMsg = (DisplayableMsg)iterator.next();
            if (this.filter.accept(displayableMsg)) {
                this.rootNode.add(displayableMsg);
                continue;
            }
            this.excludeMsgs.addElement(displayableMsg);
        }
        this.treeModel.nodeStructureChanged(this.rootNode);
    }

    private String getClassNameFor(Object object) {
        String string = object.getClass().getName() + "Viewer";
        int n = string.lastIndexOf(".");
        if (n < 0 || n >= string.length() - 1) {
            throw new RuntimeException();
        }
        String string2 = object instanceof MsgTreeNode ? ((MsgTreeNode)object).getDefaultType() + "." : "";
        return VIEWER_PACKAGE_PREFIX + string2 + string.substring(n + 1);
    }

    private synchronized void repostTree() {
        Object object;
        this.storeSelection();
        ArrayList<DisplayableMsg> arrayList = new ArrayList<DisplayableMsg>();
        Enumeration<TreeNode> enumeration = this.rootNode.children();
        while (enumeration.hasMoreElements()) {
            object = (DisplayableMsg)enumeration.nextElement();
            arrayList.add((DisplayableMsg)object);
        }
        this.rootNode.removeAllChildren();
        arrayList.addAll(this.excludeMsgs);
        this.excludeMsgs.removeAllElements();
        Collections.sort(arrayList, this.comparator);
        object = arrayList.iterator();
        while (object.hasNext()) {
            DisplayableMsg displayableMsg = (DisplayableMsg)object.next();
            if (this.filter.accept(displayableMsg)) {
                this.rootNode.add(displayableMsg);
                continue;
            }
            this.excludeMsgs.addElement(displayableMsg);
        }
        this.treeModel.nodeStructureChanged(this.rootNode);
        this.restoreSelection();
    }

    private void resetSelection() {
        this.selectionPath = null;
        this.clearSelection();
        this.view.removeViewer();
    }

    private void storeSelection() {
        TreePath treePath = this.getSelectionModel().getSelectionPath();
        if (treePath != null) {
            this.selectionPath = treePath;
        }
    }

    private void restoreSelection() {
        MsgTreeNode msgTreeNode;
        DisplayableMsg displayableMsg;
        Object object;
        if (this.selectionPath != null && (object = this.selectionPath.getLastPathComponent()) != this.getModel().getRoot() && !this.excludeMsgs.contains(displayableMsg = (msgTreeNode = (MsgTreeNode)object).getDisplayableMsg())) {
            this.getSelectionModel().setSelectionPath(this.selectionPath);
            return;
        }
        this.clearSelection();
        this.view.removeViewer();
    }
}

