/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.netmon.gui;

import com.sun.kvem.util.GraphPaperLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class HexViewPanel
extends JPanel
implements ComponentListener,
ChangeListener {
    public static final int BYTES_PER_LINE = 16;
    private static String[] symbolicChars = new String[256];
    private static String[] hexChars = new String[256];
    private GraphPaperLayout graphLayout = new GraphPaperLayout(new Dimension(10, 10), 1, 1);
    private JPanel hexCenterPanel = new JPanel();
    private HexTextArea hexArea = new HexTextArea();
    private JTextArea textArea = new JTextArea();
    private JTextArea countArea = new JTextArea();
    private JScrollBar scrollBar = new JScrollBar();
    private int firstByte;
    private byte[] bodyBytes;
    private int cols;
    private int rows;
    private int count;

    public HexViewPanel() {
        this.hexArea.setEditable(false);
        this.hexArea.setBorder(BorderFactory.createLineBorder(Color.black));
        this.textArea.setEditable(false);
        this.textArea.setBorder(BorderFactory.createLineBorder(Color.black));
        this.countArea.setEditable(false);
        this.hexCenterPanel.setLayout((LayoutManager)this.graphLayout);
        this.hexCenterPanel.add((Component)this.countArea, new Rectangle(0, 0, 1, 10));
        this.hexCenterPanel.add((Component)this.hexArea, new Rectangle(1, 0, 6, 10));
        this.hexCenterPanel.add((Component)this.textArea, new Rectangle(7, 0, 3, 10));
        this.scrollBar.getModel().addChangeListener(this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.hexCenterPanel, "Center");
        this.add((Component)this.scrollBar, "East");
        this.addComponentListener(this);
    }

    public void setFixedFont(Font font) {
        super.setFont(font);
        this.hexArea.setFont(font);
        this.textArea.setFont(font);
        this.countArea.setFont(font);
    }

    public synchronized void show(byte[] byArray) {
        this.bodyBytes = byArray;
        this.firstByte = 0;
        this.scrollBar.setMinimum(0);
        this.scrollBar.setValue(0);
        this.countArea.setBackground(this.getParent().getBackground());
        this.calcView();
        this.showBytes();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension(dimension.width, 70);
    }

    public synchronized void update(byte[] byArray) {
        int n = this.bodyBytes.length;
        this.bodyBytes = byArray;
        this.calcView();
        if (n > this.firstByte && n < this.firstByte + this.count) {
            this.showBytes();
        }
    }

    public synchronized void showBytes() {
        int n = 0;
        this.firstByte = this.scrollBar.getValue() * this.cols;
        if (this.firstByte < 0) {
            this.firstByte = 0;
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        for (int i = 0; i < this.count && this.firstByte + i < this.bodyBytes.length; ++i) {
            n = this.firstByte + i;
            if (n % this.cols == 0) {
                stringBuffer3.append(Integer.toHexString(n) + ":\n");
            }
            stringBuffer.append(this.getHexValue(this.bodyBytes[n]));
            stringBuffer.append(" ");
            stringBuffer2.append(this.getSymbolicChar(this.bodyBytes[this.firstByte + i]));
            if ((i + 1) % this.cols != 0) continue;
            stringBuffer.append("\n");
            stringBuffer2.append("\n");
        }
        this.hexArea.setText(stringBuffer.toString());
        this.textArea.setText(stringBuffer2.toString());
        this.countArea.setText(stringBuffer3.toString());
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.calcView();
        this.showBytes();
    }

    public void componentShown(ComponentEvent componentEvent) {
        this.calcView();
        this.showBytes();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.scrollBar.getValue() * this.cols != this.firstByte) {
            this.showBytes();
        }
    }

    private String getSymbolicChar(byte n) {
        return symbolicChars[n >= 0 ? n : 256 + n];
    }

    private String getHexValue(byte n) {
        return hexChars[n >= 0 ? n : 256 + n];
    }

    private synchronized void calcView() {
        this.cols = 16;
        this.rows = this.hexArea.getRows();
        this.count = this.cols * this.rows;
        if (this.count <= 0) {
            this.scrollBar.setMaximum(0);
            this.scrollBar.setValue(0);
            return;
        }
        this.scrollBar.setMaximum(Math.max(0, this.bodyBytes.length / this.cols - this.rows + 1));
    }

    static {
        for (int i = 0; i < symbolicChars.length; ++i) {
            HexViewPanel.symbolicChars[i] = !Character.isISOControl((char)i) ? String.valueOf((char)i) : ".";
            HexViewPanel.hexChars[i] = Integer.toHexString(i);
            if (hexChars[i].length() == 1) {
                HexViewPanel.hexChars[i] = "0" + hexChars[i];
            }
            hexChars[i].toUpperCase();
        }
    }

    private static class HexTextArea
    extends JTextArea {
        private HexTextArea() {
        }

        public int getColumns() {
            return super.getWidth() / super.getColumnWidth();
        }

        public int getRows() {
            return super.getHeight() / super.getRowHeight();
        }
    }
}

