/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.netmon.bluetooth;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.netmon.SyntaxErrorException;
import com.sun.kvem.netmon.bluetooth.DataElement;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.TreeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ServiceRecord {
    private static final Debug debug = Debug.create((Class)ServiceRecord.class);
    private Hashtable records = new Hashtable();

    public static ServiceRecord parseServiceRecord(byte[] byArray) throws IOException {
        ServiceRecord serviceRecord = new ServiceRecord();
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        while (true) {
            int n;
            try {
                n = dataInputStream.readInt();
            }
            catch (EOFException eOFException) {
                return serviceRecord;
            }
            DataElement dataElement = new DataElement(dataInputStream);
            serviceRecord.records.put(new Integer(n), dataElement);
        }
    }

    public Hashtable getRecords() {
        return this.records;
    }

    public void writeXML(String string, FileOutputStream fileOutputStream) throws IOException {
        fileOutputStream.write((string + "<ServiceRecord>\n").getBytes("UTF-8"));
        TreeMap treeMap = new TreeMap(this.records);
        while (!treeMap.isEmpty()) {
            Integer n = (Integer)treeMap.firstKey();
            fileOutputStream.write((string + "\t<ID>" + n + "</ID>\n").getBytes("UTF-8"));
            DataElement dataElement = (DataElement)treeMap.remove(n);
            dataElement.writeXML(string + "\t", fileOutputStream);
        }
        fileOutputStream.write((string + "</ServiceRecord>\n").getBytes("UTF-8"));
    }

    public void readXML(Node node) throws SyntaxErrorException {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.hasChildNodes()) continue;
            String string = node2.getNodeName();
            String string2 = node2.getFirstChild().getNodeValue();
            try {
                if (string.equals("ID")) {
                    n2 = Integer.parseInt(string2);
                    continue;
                }
                if (string.equals("DataElement")) {
                    DataElement dataElement = new DataElement();
                    dataElement.readXML(node2);
                    this.records.put(new Integer(n2), dataElement);
                    continue;
                }
                debug.println(2, "Unknown key: {0}", (Object)string);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw new SyntaxErrorException(numberFormatException);
            }
        }
    }
}

